/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  treesortablesignals.cc - Gtk::TreeSortable virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtktreesortable.h>
#include "treesortablesignals.hh"
#include "private/treesortableiface.hh"

using namespace Xfc;

/*  Gtk::TreeSortableSignals
 */

Gtk::TreeSortableSignals::~TreeSortableSignals()
{
}
	
void
Gtk::TreeSortableSignals::on_sort_column_changed()
{
	GtkTreeSortableIface *g_iface = TreeSortableIface::get_parent_iface(instance_);
	if (g_iface && g_iface->sort_column_changed)
		g_iface->sort_column_changed((GtkTreeSortable*)instance_);
}

