/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  plugsignals.cc - Gtk::Plug virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "plug.hh"
#include "plugsignals.hh"
#include "private/plugclass.hh"

using namespace Xfc;

/*  Gtk::PlugSignals
 */

Gtk::PlugSignals::PlugSignals(Plug *plug)
: WindowSignals(plug)
{
}

Gtk::PlugSignals::~PlugSignals()
{
}

void
Gtk::PlugSignals::on_embedded()
{
	GtkPlugClass *g_class = PlugClass::get_parent_class(instance_);
	if (g_class && g_class->embedded)
		g_class->embedded((GtkPlug*)instance_);
}

