# this file is expected to be included by a debian.rules file
# which looks very similar to the following:
#
#!/usr/bin/make -f
#
# Sample debian.rules file - for GNU Hello (1.3).
#
# modified by Bill Mitchell for portability across various packages
# 05aug94 - some bugs fixed (thanks, Peter Tobias)
# 08aug94 - modified to use debain.rules.inc
#           debian.rules.inc will be standardized and version-controlled
# 
# PKG_ABRV = dc
# PKG_VERSION = 0.2
# DEBIAN_VERSION = 6
# INSTALL_INFO_ARGS = 
# BINARY1 = dc
# TARGET1 = dc
# BINARY2 = 
# TARGET2 = 
# MAKE_CLEAN = rm -f dc *.o
# MAN1_EXT = 
# MAN5_EXT = 
# MAN8_EXT = 
# 
# CC = gcc
# INSTALL_DEBIAN_FILES = install -o root -g root -m 640
# INSTALL_DEBIAN_SCRIPTS = install -o root -g root -m 755
# INSTALL_PROGS = install -o root -g root -m 755
# INSTALL_PUBLIC_FILES = install -o root -g root -m 644
# INSTALL_CONFIG_FILES = install -o root -g root -m 644
# BIN_PATH = /usr/bin
# COPYRIGHT_PATH = /usr/doc/copyright
# 
# 	include debian.rules.inc
#
# --------------------------------------------------------------------
#
# $Log: debian.rules.inc,v $
# Revision 1.6  1994/09/23  01:18:24  root
# changes for debian guidelines updates
# these require matching debian.rules changes
# see the internal example for more info
#
# Revision 1.6  1994/09/22  23:57:20  root
# Changes to support packaging guidelines updates
# - new package file naming conventions
# - preinst and postinst scripts  and s bugfix for the "make info" stuffa bugfix for the "make info" stuff
#
# Revision 1.5  1994/09/03  20:52:49  root
# changed logic for "make info"
#
# Revision 1.4  1994/09/03  19:21:31  root
# added a bunch of SKEL_FILE targets (now have 1 thru 10)
# in build:, try to build an info: target if there is one
#
# Revision 1.4  1994/09/03  18:13:07  root
# if there's an 'ifno:' Makefile target, try to build it
#
# Revision 1.3  1994/08/28  16:53:25  root
# expunge install target
# added dquotes around [ -z "$(WHATEVER)" ] tests
# added SKEL stuff
#
# Revision 1.2  1994/08/14  16:09:07  root
# fix problem putting conffiles and the files it lists in binary package
#
# Revision 1.1  1994/08/09  06:55:15  root
# Initial revision
#
#

TEMP_FILE_NAME=/tmp/$(PKG_ABRV).debian-tmp
PKG_NAME = $(PKG_ABRV)-$(PKG_VERSION)
DEBIAN_NAME = $(PKG_NAME)-$(DEBIAN_VERSION)

build:		checkdir
	if [ -f \./configure ];\
	then\
		./configure --prefix=/usr;\
	fi;
	-grep -q ^info: Makefile
	-$(MAKE) -f Makefile info
	-$(MAKE) -f makefile info
	$(MAKE)

clean:		checkdir
	$(MAKE_CLEAN)
	-rm -rf debian-tmp *~

binary:		checkroot build version
	-rm -rf debian-tmp
	mkdir debian-tmp
	mkdir debian-tmp/DEBIAN
	mkdir debian-tmp/usr
	mkdir debian-tmp/usr/bin
	if [ ! -z "MAN1_EXT" -o ! -z "MAN5_EXT" -o ! -z "MAN8_EXT" ];\
	then\
		mkdir debian-tmp/usr/man;\
	fi;
	for i in *.info;\
	do\
		if [ -f $$i -a ! -d debian-tmp/usr/info ];\
		then\
			mkdir debian-tmp/usr/info;\
		fi;\
	done;
	mkdir debian-tmp/usr/doc
	mkdir debian-tmp/usr/doc/copyright
	if [ ! -z "$(BINARY1)" ];\
	then\
		$(INSTALL_PROGS) \
			$(BINARY1) debian-tmp/usr/bin/$(TARGET1);\
	fi;
	if [ ! -z "$(BINARY2)" ];\
	then\
		$(INSTALL_PROGS) \
			$(BINARY2) debian-tmp/usr/bin/$(TARGET2);\
	fi;
	if [ ! -z "$(SKEL_DIR)" ];\
	then\
		mkdir --parents debian-tmp/$(SKEL_DIR);\
		if [ ! -z "$(SKEL_FILE_1)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_1) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_1);\
		fi;\
		if [ ! -z "$(SKEL_FILE_2)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_2) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_2);\
		fi;\
		if [ ! -z "$(SKEL_FILE_3)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_3) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_3);\
		fi;\
		if [ ! -z "$(SKEL_FILE_4)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_4) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_4);\
		fi;\
		if [ ! -z "$(SKEL_FILE_5)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_5) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_5);\
		fi;\
		if [ ! -z "$(SKEL_FILE_6)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_6) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_6);\
		fi;\
		if [ ! -z "$(SKEL_FILE_7)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_7) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_7);\
		fi;\
		if [ ! -z "$(SKEL_FILE_8)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_8) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_8);\
		fi;\
		if [ ! -z "$(SKEL_FILE_9)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_9) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_9);\
		fi;\
		if [ ! -z "$(SKEL_FILE_10)" ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
			$(SKEL_FILE_10) debian-tmp/$(SKEL_DIR)/$(SKEL_TARGET_10);\
		fi;\
	fi;
	$(INSTALL_DEBIAN_FILES) \
		debian.control debian-tmp/DEBIAN/control
	if [ -f debian.conffiles ];\
	then\
		$(INSTALL_DEBIAN_FILES) \
			debian.conffiles debian-tmp/DEBIAN/conffiles;\
		for i in `cat debian.conffiles`;\
		do\
			mkdir --parents debian-tmp`dirname $$i`;\
			cp `basename $$i` debian-tmp$$i;\
		done;\
	fi;
	for i in preinst postinst prerm postrm;\
	do\
		if [ -f debian.$$i ];\
		then\
			$(INSTALL_DEBIAN_SCRIPTS) \
				debian.$$i debian-tmp/DEBIAN/$$i;\
		fi;\
	done;
	for i in *.info;\
	do\
		if [ -f $$i ];\
		then\
			$(INSTALL_PUBLIC_FILES) \
				$$i debian-tmp/usr/info;\
			gzip -9v debian-tmp/usr/info/$$i;\
		fi;\
	done;
	if [ ! -z "$(MAN1_EXT)" ];\
	then\
		mkdir debian-tmp/usr/man/man1;\
		for i in *.$(MAN1_EXT);\
		do\
			MAN_NAME=`basename $$i .$(MAN1_EXT)`;\
			$(INSTALL_PUBLIC_FILES) \
			$$i debian-tmp/usr/man/man1/$$MAN_NAME.1;\
		done;\
	fi;
	if [ ! -z "$(MAN5_EXT)" ];\
	then\
		mkdir debian-tmp/usr/man/man5;\
		for i in *.$(MAN5_EXT);\
		do\
			MAN_NAME=`basename $$i .$(MAN5_EXT)`;\
			$(INSTALL_PUBLIC_FILES) \
			$$i debian-tmp/usr/man/man5/$$MAN_NAME.5;\
		done;\
	fi;
	if [ ! -z "$(MAN8_EXT)" ];\
	then\
		mkdir debian-tmp/usr/man/man8;\
		for i in *.$(MAN8_EXT);\
		do\
			MAN_NAME=`basename $$i .$(MAN8_EXT)`;\
			$(INSTALL_PUBLIC_FILES) \
			$$i debian-tmp/usr/man/man8/$$MAN_NAME.8;\
		done;\
	fi;
	$(INSTALL_PUBLIC_FILES) \
		debian.COPYRIGHT debian-tmp/$(COPYRIGHT_PATH)/$(PKG_ABRV)
	chown -R root.root debian-tmp
	chmod -R g-ws debian-tmp
	dpkg --build debian-tmp
	mv debian-tmp.deb ../$(DEBIAN_NAME).deb

source:		checkdir clean version
	chmod +x debian.rules
	cd .. && \
	tar cf $(DEBIAN_NAME).tar $(PKG_NAME) && \
	gzip -9vf $(DEBIAN_NAME).tar

diff:		checkdir clean version
	cd .. && \
	(diff -ruN $(PKG_NAME).orig $(PKG_NAME) >$(DEBIAN_NAME).diff; [ $$? = 1 ]) && \
	gzip -9vf $(DEBIAN_NAME).diff

checkdir:
	test -f debian.rules

checkroot:	checkdir
	test root = "`whoami`"

version:
	sed -e "s/^VERSION:.*/VERSION: $(PKG_VERSION)-$(DEBIAN_VERSION)/" \
		<debian.control >$(TEMP_FILE_NAME)
	cp $(TEMP_FILE_NAME) debian.control
	rm $(TEMP_FILE_NAME)

