/*
 * which.c: implementation of which(1) as part of a Cygwin environment
 *
 * Copyright 1998, 2001  Corinna Vinschen, <corinna@vinschen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

static char *SCCSid = "@(#)which V1.5, Corinna Vinschen, " __DATE__ "\n";

int
check (const char *cmd)
{
  struct stat st;

  if (stat (cmd, &st))
    return 0;
  if (! S_ISREG (st.st_mode))
    return 0;
  return !access (cmd, X_OK);
}

int
main (int argc, char **argv)
{
  char *myname;
  char **path = NULL;
  char *PATH, *pp, *buf, *bufp;
  int pcnt = 0;
  int aopt = 0;

  if (! (myname = strrchr (argv[0], '\\')) &&
      ! (myname = strrchr (argv[0], '/')))
    myname = argv[0];
  else
    ++myname;
  if (strrchr (myname, '.'))
    *strrchr (myname, '.') = '\0';

  if (argc > 2 && ! strcmp (argv[1], "-a"))
    {
      --argc;
      ++argv;
      aopt = 1;
    }
  if (argc < 2)
    {
      fprintf (stderr, "usage: %s [-a] command...\n", myname);
      return 1;
    }
  if (!(PATH = getenv ("PATH")))
    {
      fprintf (stderr, "%s: no PATH variable\n", myname);
      return 2;
    }
  if (!(buf = strdup (PATH)))
    {
      fprintf (stderr, "%s: out of memory\n", myname);
      return 2;
    }
  bufp = buf;
  while (pp = strtok (bufp, ":"))
    {
      if (! (path = realloc (path, (pcnt + 1) * sizeof (char *))))
        {
	  fprintf (stderr, "%s: out of memory\n", myname);
	  return 2;
        }
      path[pcnt++] = pp;
      bufp = NULL;
    }
  while (--argc > 0)
    {
      int i;
      char *cmd = *++argv;
      char cmdpath[PATH_MAX];
      int found = 0;

      for (i = 0; i < pcnt; ++i)
	{
	  strcpy (cmdpath, path[i]);
	  if (cmdpath[strlen (cmdpath) - 1] != '/')
		  strcat (cmdpath, "/");
	  strcat (cmdpath, cmd);
	  if (check (cmdpath))
	    {
	      puts (cmdpath);
	      found = 1;
	      if (! aopt)
		break;
	    }
	}
      if (i >= pcnt && ! found)
	fprintf (stderr, "%s: Command not found.\n", cmd);
    }
  free (buf);
  free (path);
  return 0;
}

