/* From VGAlib, changed for svgalib */


#include <unistd.h>	/* for usleep( long ) */
#include <vga.h>

static char line[1024];

static void testmode(int mode)
{
   int xmax, ymax, colors, i, x, y;
	vga_modeinfo *modeinfo;

    vga_setmode(mode);

	modeinfo = vga_getmodeinfo(mode);

	printf("Width: %d  Height: %d  Colors: %d\n",
		modeinfo->width,
		modeinfo->height,
		modeinfo->colors);
	printf("DisplayStartRange: %xh  Maxpixels: %d  Blit: %s\n", 
		modeinfo->startaddressrange,
		modeinfo->maxpixels,
		modeinfo->haveblit ? "YES" : "NO");

	vga_screenoff();
	usleep(200000);
	vga_screenon();
	
   xmax   = vga_getxdim()-1;
   ymax   = vga_getydim()-1;

	vga_setcolor(15 + 255 * 256 + 32767 * 256);
   vga_drawline(   0,    0, xmax,    0);
   vga_drawline(xmax,    0, xmax, ymax);
   vga_drawline(xmax, ymax,    0, ymax);
   vga_drawline(   0, ymax,    0,    0);
   
   for(i = 0; i <= 15; i++) {
       vga_setcolor(i + 256 * i * 16);
       vga_drawline(10+i*5, 10, 90+i*5, 90);
   }
   for(i = 0; i <= 15; i++) {
       vga_setcolor(i + 256 * i * 16);
       vga_drawline(90+i*5, 10, 10+i*5, 90);
   }

	if (vga_getcolors() >= 32768)
		for (y = 100; y < 190; y++)
			for (x = 0; x < xmax; x++) {
				vga_setrgbcolor(x * 256 / xmax, 0, 0); 
				vga_drawpixel(x, y);
			}
	
	/*
	if (vga_getcolors() == 32768) {
		for (y = 100; y < 190; y++)
			for (x = 0; x < xmax; x++) {
				vga_setcolor(x * 32 / xmax + 
					(((y - 100) * 32 / 90) << 5)); 
				vga_drawpixel(x, y);
			}
	}
	else
	if (vga_getcolors() == 65536) {
		for (y = 100; y < 190; y++)
			for (x = 0; x < xmax; x++) {
				vga_setcolor(x * 32 / xmax + 
					(((y - 100) * 64 / 90) << 5)); 
				vga_drawpixel(x, y);
			}
	}
	else
	if (vga_getcolors() == 65536 * 256) {
		for (y = 100; y < 190; y++)
			for (x = 0; x < xmax; x++) {
				vga_setcolor(x * 256 / xmax + 
					(((y - 100) * 256 / 90) << 8)); 
				vga_drawpixel(x, y);
			}
	}
	else {
	*/
   if (vga_getcolors() == 256) {
       for(i = 0; i < 64; i++)
           vga_setpalette(i+128, i, i, i);
       for(i = 0; i <= xmax; i++)
       	   line[i] = 128 + i%64;
   } 
   if (vga_getcolors() == 16)       
       for(i = 0; i <= xmax; i++)
       	   line[i] = i%16;
   if (vga_getcolors() == 2)       
       for(i = 0; i <= xmax; i++)
       	   line[i] = 0x11;
   if (vga_getcolors() <= 256)
	for(i = 100; i < 190; i++)
  		vga_drawscanline(i, line);
/*       
       }
*/
	getchar();

	vga_setmode(TEXT);
}


char *modename[] = {
	"textmode",
	"320x200, 16 colors (4 bitplanes)",
	"640x200, 16 colors",
	"640x350, 16 colors",
	"640x480, 16 colors",
	"320x200, 256 colors (linear)",
	"320x240, 256 colors (Mode X)",
	"320x400, 256 colors",
	"360x480, 256 colors",
	"640x480, monochrome (1 bitplane)",
	"640x480, 256 colors (SVGA, linear)",
	"800x600, 256 colors",
	"1024x768, 256 colors",
	"320x200, 32K colors",
	"320x200, 64K colors",
	"320x200, 16M colors",
	"640x480, 32768 colors (5-5-5 RGB)",
	"640x480, 65536 colors (5-6-5 RGB)",
	"640x480, 16M colors (8-8-8 RGB truecolor)",
	"800x600, 32768 colors",
	"800x600, 65536 colors",
	"800x600, 16M colors",
	"1024x768, 32768 colors",
	"1024x768, 65536 colors",
	"1024x768, 16M colors",
	"1280x1024, 256 colors ",
	"1280x1024, 32768 colors",
	"1280x1024, 65536 colors",
	"1280x1024, 16M colors",
	"720x350, 16 colors (4 bitplanes, standard VGA)",
	"720x480, 16 colors"
};

main()
{
	int mode;
	int i;

	vga_hasmode(TEXT); 	/* force driver message */
	
	mode = vga_getdefaultmode();
	if (mode == -1) {
		printf("Choose from one of the following video modes: \n");

			for (i = 1; i <= GLASTMODE; i++)
				if (vga_hasmode(i))
			    		printf("%5d: %s\n", i, modename[i]);

		printf("Enter mode number (1-19): ");
		scanf("%d", &mode);
		getchar();
		printf("\n");

		if (mode < 1 || mode > GLASTMODE) {
			printf("Error: Mode number out of range \n");
			exit(-1);
		}
    	}
    
	if (vga_hasmode(mode))
		testmode(mode);
	else {
		printf("Error: Video mode not supported by driver\n");
		exit(-1);
	}
}
