/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */

#include <stdio.h>
#include "vga.h"
#include "vgamacros.h"
#include "chipsets.h"


int vga_drawpixel(int x, int y)
{
    unsigned long offset;

    /* First non paged modes */
    switch (__vga_cur_mode) {
	case G640x480x2 :
	case G320x200x16:
	case G640x200x16:
	case G640x350x16:
	case G640x480x16:
/*	case G720x350x16:
	case G720x480x16:
	case G800x600x16: */
	    /* select bit */
	    port_out(8, GRA_I);
	    port_out(0x80 >> (x & 7), GRA_D);   

            /* read into latch and write dummy back */
	    offset = y*__vga_cur_info.xbytes + (x>>3);
	    graph_mem[offset] = graph_mem[offset];   
       	    return 0;
	case G320x200x256:
            /* write color to pixel */
	    graph_mem[y*320 + x] = __vga_cur_color;  
            return 0;
	case G320x240x256:
	case G320x400x256:
	case G360x480x256:
	    /* select plane */ 
	    port_out(0x02, SEQ_I); 
    	    port_out(1 << (x & 3), SEQ_D);   

            /* write color to pixel */
	    graph_mem[y*__vga_cur_info.xbytes + (x>>2)] = __vga_cur_color;  
            return 0;
    }
    /* Big modes, calculate VGA page every time */
    switch (__vga_cur_info.colors) {
	case     2:
	case    16:
	    /* select bit */
	    port_out(8, GRA_I);
	    port_out(0x80 >> (x & 7), GRA_D);   

            /* read into latch and write dummy back */
	    offset = y*__vga_cur_info.xbytes + (x>>3);
            vga_setpage(offset>>16);
	    offset &= 0xffff;
	    graph_mem[offset] = graph_mem[offset];   
            break;
	case   256:
	    offset = y*__vga_cur_info.xbytes+x; 

	    /* select segment */
	    vga_setpage(offset >> 16);

            /* write color to pixel */
	    graph_mem[offset & 0xFFFF] = __vga_cur_color;  
            break;
        case 32768:
        case 65536:
            offset = y * __vga_cur_info.xbytes + x * 2;
            vga_setpage(offset >> 16);
            *(unsigned short *)(graph_mem + (offset & 0xffff)) =
            	__vga_cur_color;
            break;
        case 1<<24 :
        	offset = y * __vga_cur_info.xbytes + x * 3;
        	vga_setpage(offset >> 16);
        	switch (offset & 0xffff) {
        		case 0xfffe :
        			*(unsigned short *)(graph_mem + 0xfffe)
        				= __vga_cur_color;
        			vga_setpage((offset >> 16) + 1);
        			graph_mem[0] = __vga_cur_color >> 16;
        			break; 
        		case 0xffff :
        			graph_mem[0xffff] = __vga_cur_color;
        			vga_setpage((offset >> 16) + 1);
        			*(unsigned short *)(graph_mem)
        				= __vga_cur_color >> 8;
        			break;
        		default :
        			*(unsigned short *)(graph_mem +
        				(offset & 0xffff)) = __vga_cur_color;
        			graph_mem[(offset & 0xffff) + 2] =
        				__vga_cur_color >> 16;
        			break;
        	}
        	break;
    }
        
    return 0;
}



