/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */

#include <stdio.h>
#include "vga.h"
#include "vgamacros.h"
#include "chipsets.h"

static void DELAY() {
	int i;
	for (i = 0; i < 10; i++);
}

int vga_setpalette(int index, int red, int green, int blue)
{
    /* select palette register */
    port_out(index, PEL_IW); 

    /* write RGB components */
    DELAY(); /* delay (minimum 240ns) */ 
    port_out(red, PEL_D);
    DELAY(); /* delay (minimum 240ns) */ 
    port_out(green, PEL_D);
    DELAY(); /* delay (minimum 240ns) */ 
    port_out(blue, PEL_D);

    return 0;
}


int vga_getpalette(int index, int *red, int *green, int *blue)
{
    /* select palette register */
    port_out(index, PEL_IR);

    /* read RGB components */
    DELAY(); /* delay (minimum 240ns) */ 
    *red = (int) port_in(PEL_D);
    DELAY(); /* delay (minimum 240ns) */ 
    *green = (int) port_in(PEL_D);
    DELAY(); /* delay (minimum 240ns) */ 
    *blue = (int) port_in(PEL_D);

    return 0;
}


int vga_setpalvec(int start, int num, int *pal)
{
    int j;

    /* select palette register */
    port_out(start, PEL_IW);

    for(j = 0; j < num; j++) {
        DELAY(); /* delay (minimum 240ns) */ 
        port_out(*(pal++), PEL_D);
        DELAY(); /* delay (minimum 240ns) */ 
        port_out(*(pal++), PEL_D);
        DELAY(); /* delay (minimum 240ns) */ 
        port_out(*(pal++), PEL_D);
    }

    return j;
}


int vga_getpalvec(int start, int num, int *pal)
{
    int j;

    /* select palette register */
    port_out(start, PEL_IR);

    for(j = 0; j < num; j++) {
        DELAY(); /* delay (minimum 240ns) */ 
        *(pal++) = (int) port_in(PEL_D);
        DELAY(); /* delay (minimum 240ns) */ 
        *(pal++) = (int) port_in(PEL_D);
        DELAY(); /* delay (minimum 240ns) */ 
        *(pal++) = (int) port_in(PEL_D);
    }

    return j;
}

