/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */
/* TVGA 8900c code taken from tvgalib by Toomas Losin */


#include <stdio.h>
#include "vga.h"
#include "vgamacros.h"
#include "chipsets.h"


#define REGCOUNT 72

/* Trident SVGA mode 5d - 640x480x256 1M NI */
static unsigned char tvga8900_g640x480x256_regs[REGCOUNT] = {
  /* CRTC */
  0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Sequencer */
  0x01,0x01,0x0f,0x00,0x0e,
  /* Misc. output */
  0x63,
  /* 7 extra CRT registers */
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  /* Extra Sequencer old and new mode registers 13 and 14 */
  0x30,0xa8, 0x00,0x42,
  0x00
};

/* Trident SVGA mode 5d - 640x480x256 512k + 1M I */
static unsigned char tvga8900_g640x480x256i_regs[REGCOUNT] = {
  0xc3,0x9f,0xa1,0x84,0xa6,0x00,0x0b,0x3e,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0xea,0x8c,0xdf,0x50,0x40,0xe7,0x04,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Seq. */
  0x01,0x01,0x0f,0x00,0x0e,
  /* Misc. output */
  0xeb,
  /* extra CRT regs */
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  /* Extra seq. regs */
  0x00,0xa8, 0x01,0x02,
  0x00
};

/* Trident SVGA mode 5e - 800x600x256 1M NI */
static unsigned char tvga8900_g800x600x256_regs[REGCOUNT] = {
  /* CRTC */
  0x7e,0x63,0x64,0x81,0x6b,0x18,0x99,0xf0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x6e,0x84,0x57,0x32,0x40,0x5e,0x93,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Sequencer */
  0x01,0x01,0x0f,0x00,0x0e,
  /* Misc. output */
  0x2b,
  /* Extra CRT registers */
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  /* Seq. old and new mode registers */
  0x10,0xa8, 0x01,0x02,
  0x00
};


/* Trident SVGA mode 5e - 800x600x256 512k */
static unsigned char tvga8900_g800x600x256i1_regs[REGCOUNT] = {
  /* CRTC */
  0xeb,0xc7,0xc9,0x8d,0xcb,0x86,0x4a,0x1f,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x2f,0x81,0x2b,0xc8,0x40,0x2f,0x47,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Sequencer */
  0x01,0x01,0x0f,0x00,0x0e,
  /* Misc. output */
  0xa3,
  /* extra CRTC */
  0xff,0x00,0x00,0x00,0x00,0x00,0x84,
  /* extra Seq. */
  0x00,0xa8, 0x01,0x02,
  0x00
  };

/* Trident SVGA mode 5e - 800x600x256 1M I */
static unsigned char tvga8900_g800x600x256i_regs[REGCOUNT] = {
  /* CRTC */
  0x7b,0x63,0x64,0x9e,0x69,0x92,0x6f,0xf0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x58,0x8a,0x57,0x32,0x40,0x58,0x6f,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Seq. */
  0x01,0x01,0x0f,0x00,0x0e,
  0xef,
  /* extra CRTC */
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x30,0xa8, 0x00,0x42,
  0x00
};


/* Trident SVGA mode 62 - 1024x768x256 1M I */
static unsigned char tvga8900_g1024x768x256i_regs[REGCOUNT] = {
  /* CRTC */
  0x99,0x7f,0x81,0x1b,0x83,0x19,0x98,0x1f,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x81,0x0f,0x7f,0x80,0x40,0x83,0x95,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Sequencer */
  0x01,0x01,0x0f,0x00,0x0e,
  /* Misc. output */
  0x2b,
  /* Extra CRTC regs */
  0xff,0x00,0x00,0x00,0x00,0x00,0x84,
  /* Ext. sequencer */
  0x10,0xa8, 0x00,0x02,
  0x00
};

/* Trident SVGA mode 62 - 1024x768x256 1M NI */
static unsigned char tvga8900_g1024x768x256_regs[REGCOUNT] = {
  /* CRTC */
  0xa2,0x7f,0x80,0x85,0x87,0x90,0x2c,0xfd,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x0f,0x81,0xff,0x40,0x40,0x07,0x26,0xa3,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  /* Sequencer */
  0x01,0x01,0x0f,0x00,0x0e,
  /* Misc. output */
  0x27,
  /* Extended CRTC regs */
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  /* Ext. seq. */
  0x10,0xa8, 0x01,0x02,
  0x00
};


static int tvga_chiptype;
static int tvga8900_memory;	/* amount of video memory in K */
static int tvga8900_nonint;	/* nonzero if non-interlaced jumper set */

static int tvga8900_init(int, int, int);

static int reg_0c = 0xad;	/* value for 256k cards */


/* Mode table */

static unsigned char *tvga8900_moderegs_1024[] = { /* 1Mb, non-interlace */
	tvga8900_g640x480x256_regs, 		   /* jumper set */
	tvga8900_g800x600x256_regs,
	tvga8900_g1024x768x256_regs
};

static unsigned char *tvga8900_moderegs_1024i[] = { /* 1Mb, jumper set to */
	tvga8900_g640x480x256i_regs,		    /* interlaced */
	tvga8900_g800x600x256i_regs,
	tvga8900_g1024x768x256i_regs
};

static unsigned char *tvga8900_moderegs_512[] = {	/* 512K */
	tvga8900_g640x480x256i_regs,
	tvga8900_g800x600x256i1_regs,
	NULL
};

 
/* Fill in chipset specific mode information */

static int tvga8900_getmodeinfo( int mode, vga_modeinfo *modeinfo ) {
	modeinfo->maxpixels = tvga8900_memory * 1024 / modeinfo->bytesperpixel;
	modeinfo->maxlogicalwidth = 2040;
	modeinfo->startaddressrange = 0xfffff;
	modeinfo->haveblit = 0;
}


/* Read and store chipset-specific registers */

static int tvga8900_saveregs(unsigned char regs[])
{
    int i;

    /* save extended CRT registers */
    for (i = 0; i < 7; i++) {
	 port_out(0x18 + i, CRT_I); 
	 regs[EXT + i] = port_in(CRT_D); 
    }

    /* now do the sequencer mode regs */
    port_out(0x0b, SEQ_I);		/* force old mode regs */
    port_out(port_in(SEQ_D), SEQ_D);	/* by writing */

	/* outw(0x3C4, 0x820E); */		/* unlock conf. reg */
	/* port_out(0x0c, SEQ_I); */		/* save conf. reg */
	/* regs[EXT + 11] = port_in(SEQ_D); */

    port_out(0x0d, SEQ_I);		/* old reg 13 */
    regs[EXT + 7] = port_in(SEQ_D);
    port_out(0x0e, SEQ_I);		/* old reg 14 */
    regs[EXT + 8] = port_in(SEQ_D);

    port_out(0x0b, SEQ_I);		/* now use new regs */
    port_in(SEQ_D);
    port_out(0x0d, SEQ_I);		/* new reg 13 */
    regs[EXT + 9] = port_in(SEQ_D);
    port_out(0x0e, SEQ_I);		/* new reg 14 */
    regs[EXT + 10] = port_in(SEQ_D) ^ 0x02;

	/* we do the ^ 0x02 so that when the regs are restored */
	/* later we don't have a special case; see trident.doc */
}


/* Set chipset-specific registers */

static int tvga8900_setregs(unsigned char regs[])
{
    int i, crtc31;
    
    /* 7 extended CRT registers */
    /* 4 extended Sequencer registers (old and new) */
    /* CRTC reg 0x1f is apparently dependent */
    /* on the amount of memory installed. */
  	
  	switch (tvga8900_memory >> 8) {
 		case 1 : crtc31 = 0x94; reg_0c = 0xad; break;	/* 256K */
  		case 2 :
 		case 3 : crtc31 = 0x98; reg_0c = 0xcd; break;	/* 512/768K */
  		case 4 : 					/* 1024K */
  			crtc31 = 0x18;
 			reg_0c = 0xcd;
  			if (regs == tvga8900_g1024x768x256_regs ||
 			regs == tvga8900_g1024x768x256i_regs) {
 				reg_0c = 0xed;
  				crtc31 = 0x98;
 			}
 			else if (regs == tvga8900_g640x480x256_regs ||
 			regs == tvga8900_g640x480x256i_regs || 
 			regs == tvga8900_g800x600x256_regs ||
 			regs == tvga8900_g800x600x256i_regs ||
 			regs == tvga8900_g800x600x256i1_regs)
 				reg_0c = 0xed;
  			break;
  	}

	#ifdef REG_DEBUG
	printf("Setting extended registers\n");
	#endif

    /* write extended CRT registers */
    for (i = 0; i < 7; i++) {
	 port_out(0x18 + i, CRT_I); 
	 port_out(regs[EXT + i], CRT_D); 
    }

    /* update sequencer mode regs */
    port_out(0x0b, SEQ_I);		/* select old regs */
    port_out(port_in(SEQ_D), SEQ_D);
    port_out(0x0d, SEQ_I);		/* old reg 13 */
    port_out(regs[EXT + 7], SEQ_D);
    port_out(0x0e, SEQ_I);		/* old reg 14 */
    port_out(regs[EXT + 8], SEQ_D);

    port_out(0x0b, SEQ_I);
    port_in(SEQ_D);			/* select new regs */
 
    	if (tvga8900_memory > 512) {
		port_out(0x0e, SEQ_I);            /* set bit 7 of reg 14  */
		port_out(0x80, SEQ_D);            /* to enable writing to */
		port_out(0x0c, SEQ_I);            /* reg 12               */
		port_out(reg_0c, SEQ_D);
	}

/*	outw(0x3c4, 0x820e); */		/* unlock conf. reg */
/* 	port_out(0x0c, SEQ_I); */	/* reg 12 */

    port_out(0x0d, SEQ_I);		/* new reg 13 */
    port_out(regs[EXT + 9], SEQ_D);
    port_out(0x0e, SEQ_I);		/* new reg 14 */
    port_out(regs[EXT + 10], SEQ_D);

	#ifdef REG_DEBUG
	printf("Now setting last two extended registers.\n");
	#endif

    /* update CRTC reg 1f */
    port_out(0x1f, CRT_I);
    port_out((port_in(CRT_D) & 0x03) | crtc31, CRT_D);
}


/* Return nonzero if mode is available */

static int tvga8900_modeavailable( int mode ) {
	if (STDVGAMODE(mode))
		return 1;		/* always available */
	switch (mode) {
		case G640x480x256 :
		case G800x600x256 :
			return (tvga8900_memory >= 512);
		case G1024x768x256 :
			return (tvga8900_memory == 1024);
		default :
			return 0;
	}
}


/* Set a mode */

static int tvga8900_setmode( int mode ) {
	void *regs;
	if (!tvga8900_modeavailable(mode))
		return 1;	/* mode not available */
	if (SVGAMODE(mode)) {
		int svgamode = mode - G640x480x256;

		if (tvga8900_memory < 1024) {				
			vga_setregs(tvga8900_moderegs_512[svgamode]);
			tvga8900_setregs(tvga8900_moderegs_512[
				svgamode]);	/* 512K */
		}
		else
		if (tvga8900_nonint) {
			vga_setregs(tvga8900_moderegs_1024[svgamode]);
			tvga8900_setregs(tvga8900_moderegs_1024[
				svgamode]);	/* 1M NI */
		}
		else {
			vga_setregs(tvga8900_moderegs_1024i[svgamode]);
			tvga8900_setregs(tvga8900_moderegs_1024i[
				svgamode]);	/* 1M I */
		}
	}
	else
		vga_chipsetfunctions[CHIPSET_SETMODE](mode);
	return 0;
}


/* Unlock chipset-specific registers */

static int tvga8900_unlock() {
}


/* Relock chipset-specific registers */

static int tvga8900_lock() {
}


/* Indentify chipset; return non-zero if detected */

int tvga8900_test()
{
	int origVal, newVal;
	int save0b;
	/* 
       	 * Check first that we have a Trident card.
       	 */
       	outb(0x3c4, 0x0b);
       	save0b = inb(0x3c5);
	outw(0x3C4, 0x000B);	/* Switch to Old Mode */
	inb(0x3C5);		/* Now to New Mode */
      	outb(0x3C4, 0x0E);
      	origVal = inb(0x3C5);
      	outb(0x3C5, 0x00);
      	newVal = inb(0x3C5) & 0x0F;
      	outb(0x3C5, (origVal ^ 0x02));
 
      	if (newVal != 2) {
      		outb(0x3c5, origVal);
      		outb(0x3c4, 0x0b);
      		outb(0x3c5, save0b);
      		return 0;
      	}

	/* check version */
	outw(0x3c4, 0x000b);
	switch (inb(0x3c5)) {
	case 0x02 :	/* 8800cs */
	case 0x03 :	/* 8900b */
	case 0x04 :	/* 8900c */
	case 0x13 :
	case 0x33 :	/* 8900cl */
	case 0x23 :	/* 9000 */
		break;
	default :
		return 0;
	}

	tvga8900_init(0, 0, 0);
	return 1;
}


/* Bank switching function - set 64K bank number */

int tvga8900_setpage( int page ) {
	port_out(0x0b, SEQ_I);
	port_out(port_in(SEQ_D), SEQ_D);
	port_in(SEQ_D);			/* select new mode regs */

	port_out(0x0e, SEQ_I);
	port_out(page ^ 0x02, SEQ_D);	/* select the page */
}


/* Set display start address (not for 16 color modes) */
/* Trident supports any address in video memory (up to 1Mb) */

static int tvga8900_setdisplaystart( int address ) {
	if (tvga8900_memory == 1024) {
		outw(0x3d4, 0x0d + ((address >> 3) & 0x00ff) * 256);	/* sa2-sa9 */
		outw(0x3d4, 0x0c + ((address >> 3) & 0xff00));		/* sa10-sa17 */
	}
	else {
		outw(0x3d4, 0x0d + ((address >> 2) & 0x00ff) * 256);	/* sa2-sa9 */
		outw(0x3d4, 0x0c + ((address >> 2) & 0xff00));		/* sa10-sa17 */
	}
	inb(0x3da);			/* set ATC to addressing mode */
	outb(0x3c0, 0x13 + 0x20);	/* select ATC reg 0x13 */
	if (tvga8900_memory == 1024) {
		outb(0x3c0, (inb(0x3c1) & 0xf0) | (address & 7));
			/* write sa0-2 to bits 0-2 */
		address >>= 1;
	}
	else
		outb(0x3c0, (inb(0x3c1) & 0xf0) | ((address & 3) << 1));
			/* write sa0-1 to bits 1-2 */

	outb(0x3d4, 0x1e);
	outb(0x3d5, (inb(0x3d5) & 0x5f) | 0x80	/* set bit 7 */
		| ((address & 0x40000) >> 13));	/* sa18: write to bit 5 */
	outb(0x3c4, 0x0b); outb(0x3c5, 0);	/* select 'old mode' */
	outb(0x3c4, 0x0e);
	outb(0x3c5, (inb(0x3c5) & 0xfe)
		| ((address & 0x80000) >> 19));	/* sa19: write to bit 0 */
	outb(0x3c4, 0x0b);
	inb(0x3c5);				/* return to 'new mode' */
}


/* Set logical scanline length (usually multiple of 8) */
/* Trident supports multiples of 8 to 2040 */

static int tvga8900_setlogicalwidth( int width ) { 
	outw(0x3d4, 0x13 + (width >> 3) * 256);	/* lw3-lw11 */
}


/* Function table */

int (*tvga8900_chipsetfunctions[])() = {
	tvga8900_saveregs,
	tvga8900_setregs,
	tvga8900_unlock,
	tvga8900_lock,
	tvga8900_test,
	tvga8900_init,
	tvga8900_setpage,
	tvga8900_setmode,
	tvga8900_modeavailable,
	tvga8900_setdisplaystart,
	tvga8900_setlogicalwidth,
	tvga8900_getmodeinfo
};


/* Initialize chipset (called after detection) */

static int tvga8900_init( int force, int par1, int par2) {
	if (force) {
		#ifdef DEBUG
		printf("Forcing memory to %dK\n", par1);
		#endif
		tvga8900_memory = par1;
		tvga8900_nonint = par2;
	}
	else {
	   	port_out(0x1f, CRT_I);
    		tvga8900_memory = (port_in(CRT_D) & 0x03) * 256 + 256;

    		/* Now is the card running in interlace mode? */
    		port_out(0x0f, SEQ_I);
   		tvga8900_nonint = port_in(SEQ_D) & 0x04;
	}

	if (__driver_report) {
		printf("Using Trident 8900/9000 driver (%dK, %sinterlaced).\n", 
			tvga8900_memory, (tvga8900_nonint) ? "non-" : "");
	}

	chipsetfunctions = tvga8900_chipsetfunctions;
}
