#pragma inline 
#include <stdio.h> 
#include <string.h> 
#include <stdlib.h> 
#include <dos.h> 
 
/* VGA index register ports */ 
#define CRT_I   0x3D4   /* CRT Controller Index (mono: 0x3B4) */ 
#define ATT_IW  0x3C0   /* Attribute Controller Index & Data Write Register */ 
#define GRA_I   0x3CE   /* Graphics Controller Index */ 
#define SEQ_I   0x3C4   /* Sequencer Index */ 
#define PEL_IW  0x3C8   /* PEL Write Index */ 
 
/* VGA data register ports */ 
#define CRT_D   0x3D5   /* CRT Controller Data Register (mono: 0x3B5) */ 
#define ATT_R   0x3C1   /* Attribute Controller Data Read Register */ 
#define GRA_D   0x3CF   /* Graphics Controller Data Register */ 
#define SEQ_D   0x3C5   /* Sequencer Data Register */ 
#define MIS_R   0x3CC   /* Misc Output Read Register */ 
#define MIS_W   0x3C2   /* Misc Output Write Register */ 
#define IS1_R   0x3DA   /* Input Status Register 1 (mono: 0x3BA) */ 
#define PEL_D   0x3C9   /* PEL Data Register */ 
 
/* VGA indexes max counts */ 
#define CRT_C   24      	/* 24 CRT Controller Registers */ 
#define ATT_C   21      	/* 21 Attribute Controller Registers */ 
#define GRA_C   9       	/* 9  Graphics Controller Registers */ 
#define SEQ_C   5       	/* 5  Sequencer Registers */ 
#define MIS_C   1       	/* 1  Misc Output Register */ 
#define EXT_C   11       	/* 11 SVGA Extended Registers */ 
 
/* VGA registers saving indexes */ 
#define CRT     0               /* CRT Controller Registers start */ 
#define ATT     CRT+CRT_C       /* Attribute Controller Registers start */ 
#define GRA     ATT+ATT_C       /* Graphics Controller Registers start */ 
#define SEQ     GRA+GRA_C       /* Sequencer Registers */ 
#define MIS     SEQ+SEQ_C       /* General Registers */ 
#define EXT     MIS+MIS_C       /* SVGA Extended Registers */ 
 
 
unsigned char vga_regs[71]; 
 
void port_out(unsigned char value, unsigned short port) 
{ 
	asm mov dx,port 
	asm mov al,value 
	asm out dx,al 
} 
 
 
unsigned char port_in(unsigned short port) 
{ 
	asm mov dx,port 
	asm in al,dx 
    return (_AL); 
} 
int dactype(void) 
{ 
	union REGS cpu_regs; 
 
	cpu_regs.x.ax=0x10F1; 
	cpu_regs.x.bx=0x2EFF; 
 
	int86(0x10, &cpu_regs, &cpu_regs); 
	if (cpu_regs.x.ax != 0x0010) 
		return (-1); 
	else 
		return (cpu_regs.h.bl); 
} 
 
void usage(char *c) 
{ 
	printf("Usage: getregs mode [<0|15|24> [SS24|G7900]\n"); 
	printf("%s", c); 
	exit(-1); 
} 
 
void main(int argc, char* argv[]) 
{ 
    union REGS cpu_regs; 
    int i, dac, bioserr=0; 
    unsigned char mode, hico, funny_card; 
 
    if ( (argc <2) || (argc >4) )  
	usage(""); 
 
    if (!sscanf(argv[1],"%x",&mode)) 
 	usage("\tmode is a hexadecimal integer < FF\n"); 
    if ((argc >2) && (!sscanf(argv[2], "%d", &hico)) ) 
	usage("\tFor cards with hicolor modes - 0 is normal, 15 and 24\n\t are 32k and 16M colors respectively\n"); 
    if ( (hico != 15) && (hico!=24) && (hico != 0) ) 
	usage("\tFor cards with hicolor modes - 0 is normal, 15 and 24\n\t are 32k and 16M colors respectively\n"); 
    if ( (argc == 4) && ( (strcmp("SS24", argv[3]) != 0) && (strcmp("G7900", argv[3]) != 0) ) ) 
	usage("\tFor odd cards with hicolor modes - SS24 is for Diamond Speedstar 24\n\t G7900 is for Genoa 7900\n"); 
 
    if (argc==4) 
	funny_card = (strcmp("SS24", argv[3]) == 0) ? 1 : 2; 
    else 
	funny_card = 0; 
 
    dac = dactype(); 
 
    switch (hico) 
    { 
	case 15: 
	    cpu_regs.x.ax=0x10F0; 
	    cpu_regs.h.bl=mode; 
	    break; 
	case 24: 
	    switch (funny_card) 
	    { 
		case 1: 
		    cpu_regs.x.ax=0x10E0; 
		    cpu_regs.h.bl=0x2e; 
		    break; 
		case 2: 
		    cpu_regs.x.ax=0x10f0; 
		    cpu_regs.h.bl=0x3e; 
		    break; 
		case 0: 
		default: 
		    cpu_regs.x.ax=0x10F0; 
		    cpu_regs.h.bh=mode; 
		    cpu_regs.h.bl=0xFF; 
		    break; 
	    } 
	    break; 
	case 0: 
	default: 
	    cpu_regs.h.ah = 0x00; 
	    cpu_regs.h.al = mode; 
	    break; 
	} 
 
	int86(0x10, &cpu_regs, &cpu_regs); 
	bioserr = cpu_regs.x.ax; 
 
    /* get VGA register values */ 
    for (i = 0; i < CRT_C; i++) { 
        port_out(i, CRT_I); 
        vga_regs[CRT+i] = port_in(CRT_D); 
    } 
    for (i = 0; i < ATT_C; i++) { 
      	port_in(IS1_R); 
       	port_out(i, ATT_IW);  
       	vga_regs[ATT+i] = port_in(ATT_R);  
    } 
    for (i = 0; i < GRA_C; i++) { 
       	port_out(i, GRA_I);  
       	vga_regs[GRA+i] = port_in(GRA_D);  
    } 
    for (i = 0; i < SEQ_C; i++) { 
       	port_out(i, SEQ_I);  
       	vga_regs[SEQ+i] = port_in(SEQ_D);  
    } 
    vga_regs[MIS] = port_in(MIS_R);  
 
    /* get extended CRT registers */ 
    for (i = 0; i < 6; i++) { 
	 port_out(0x32+i, CRT_I);  
	 vga_regs[EXT+i] = port_in(CRT_D);  
    } 
    port_out(0x3f, CRT_I);  
    vga_regs[EXT+6] = port_in(CRT_D);  
 
    /* get extended sequencer register */ 
    port_out(7, SEQ_I);  
    vga_regs[EXT+7] = port_in(SEQ_D);  
 
    /* get some other ET4000 specific registers */ 
    vga_regs[EXT+8] = port_in(0x3c3);  
    vga_regs[EXT+9] = port_in(0x3cd);  
 
    /* get extended attribute register */ 
    port_in(IS1_R);   /* reset flip flop */ 
    port_out(0x16, ATT_IW); 
    vga_regs[EXT+10] = port_in(ATT_R); 
 
    cpu_regs.h.ah = 0x00; 
    cpu_regs.h.al = 0x03; 
    int86(0x10, &cpu_regs, &cpu_regs); 
 
    switch (dac) 
    { 
	case -1: 
		printf ("/*Dac detection BIOS call returned an error*/\n"); 
		break; 
	case 0: 
		printf ("/*Standard VGA dac detected*/\n"); 
		break; 
	case 1: 
		printf ("/*Sierra SC1148x HiColor dac detected*/\n"); 
		break; 
	case 2: 
		printf ("/*Diamond Speedstar 24 24bit dac or Sierra Mark2/Mark3 dac detected*/\n"); 
		break; 
	case 3: 
		printf ("/*AT&T ATT20c491/2 15/16/24 bit dac detected*/\n"); 
		break; 
	case 4: 
		printf ("/*AcuMos ADAC1 15/16/24 bit dac detected*/\n"); 
		break; 
	default: 
		printf ("/*Unknown HiColor dac detected*/\n"); 
		break; 
	}	 
 
    if ( hico && (bioserr != 0x0010) ) 
	printf("\n/* BIOS returned error code %X - video mode probably invalid */\n", bioserr); 
 
    printf("\n/* BIOS mode 0x%02X */\n", mode); 
    printf("static char regs[71] = {\n  "); 
    for (i = 0; i < 12; i++)  
        printf("0x%02X,",vga_regs[CRT+i]); 
    printf("\n  ");  
    for (i = 12; i < CRT_C; i++)  
        printf("0x%02X,",vga_regs[CRT+i]); 
    printf("\n  ");  
    for (i = 0; i < 12; i++)  
        printf("0x%02X,",vga_regs[ATT+i]); 
    printf("\n  ");  
    for (i = 12; i < ATT_C; i++)  
        printf("0x%02X,",vga_regs[ATT+i]); 
    printf("\n  ");  
    for (i = 0; i < GRA_C; i++)  
        printf("0x%02X,",vga_regs[GRA+i]); 
    printf("\n  ");  
    for (i = 0; i < SEQ_C; i++)  
        printf("0x%02X,",vga_regs[SEQ+i]); 
    printf("\n  ");  
    printf("0x%02X,",vga_regs[MIS]); 
    printf("\n  ");  
    for (i = 0; i < EXT_C-1; i++)  
        printf("0x%02X,",vga_regs[EXT+i]); 
    printf("0x%02X",vga_regs[EXT+EXT_C-1]); 
    printf("\n};\n");  
 
} 
