/*
 
  This program sets the 'memory clock' of Cirrus 542x cards.
  The first three values could be set by utility programs that
  came with my card (AVGA3), but much higher values seem to work (on my card
  at least). It may be that better and more recent Cirrus cards use a higher
  value as boot-up default.

  Using a high memory clock gives a very significant performance improvement;
  with high dot clock modes (like 640x480x16M or 1150x900x256) performance can
  be more than twice that of the standard 50 MHz clock. This goes for both
  framebuffer access and accelerated features (bitblt).
  Use at your own risk!

  Note that the 'dot clock' is something entirely different. There does not
  seem to be much correlation between the two.
*/

#include <stdlib.h>
#include "vgamacros.h"

main() {
	iopl(3);
	outb(0x3c4, 0x1f);

	/*
		0x1c		50M (boot-up default)
		0x21		59M
		0x22		62M
		0x23 OK
		0x24 OK
		0x25 OK
		0x26 OK
		0x27 occasional loose pixels
		0x28 occasional problems
		0x29 some problems
		0x2A 16M/textmode problems
		0x2c 256/32k color problems
	*/
	outb(0x3c5, 0x26);

	exit(0);
}
