/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */
/* Oak support (does not work) */
/* Basically ET4000 timings, with Oak bank switching */
/* Maybe 0x3de, regs 0x09 and 0x0a do something. */   

#include <stdio.h>
#include "vga.h"
#include "vgamacros.h"
#include "chipsets.h"


static char oak_g640x480x256_regs[61] = {
  /* CRTC */
  0x5F,0x4F,0x50,0x82,0x54,0x80,0x0B,0x3E,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0xEA,0x8C,0xDF,0x50,0x60,0xE7,0x04,0xAB,
  /* ATC */
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
  0x0C,0x0D,0x0E,0x0F,0x01,0x00,0x0F,0x00,0x00,
  /* Graphics */
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF,
  /* Sequencer */
  0x03,0x01,0x0F,0x00,0x0E,
  /* Misc. Output */
  0xE3,
  /* Extended registers */
  0x00	/* banking register */
};

static char oak_g800x600x256_regs[61] = {
  /* CRTC */
  0x7A,0x63,0x64,0x1D,0x68,0x9A,0x78,0xF0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x5C,0x8E,0x57,0x64,0x60,0x5B,0x75,0xAB,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
  0x0C,0x0D,0x0E,0x0F,0x01,0x00,0x0F,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF,
  0x03,0x01,0x0F,0x00,0x0E,
  0xEF,
  /* Extended registers */
  0x00
};

static char oak_g1024x768x256_regs[61] = {
  0x99,0x7F,0x7F,0x1D,0x83,0x17,0x2F,0xF5,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x08,0x80,0xFF,0x80,0x60,0xFF,0x30,0xAB,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
  0x0C,0x0D,0x0E,0x0F,0x01,0x00,0x0F,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF,
  0x03,0x01,0x0F,0x00,0x0E,
  0x27,
  /* Extended registers */
  0x00
};


static int oak_chiptype;
static int oak_memory;

static int oak_init(int, int, int);


/* Mode table */

static char *oak_moderegs[] = {
	oak_g640x480x256_regs, oak_g800x600x256_regs,		/* SVGA */
	oak_g1024x768x256_regs,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL
};

 
/* Fill in chipset specific mode information */

static int oak_getmodeinfo( vga_modeinfo *modeinfo ) {
	modeinfo->maxpixels = oak_memory * 1024 / modeinfo->bytesperpixel;
	modeinfo->maxlogicalwidth = 2040;
	modeinfo->startaddressrange = 0x3ffff;
}


/* Read and store chipset-specific registers */

static int oak_saveregs(char regs[])
{
	outb(0x3de,0x11);	/* save bank register */
	regs[EXT] = inb(0x3df);
}


/* Set chipset-specific registers */

static int oak_setregs(char regs[])
{
	outw(0x3de, 0x11 + regs[EXT] * 256);
}


/* Return non-zero if mode is available */

static int oak_modeavailable( int mode ) {
	if (STDVGAMODE(mode))
		return 1;		/* always available */
	if (oak_moderegs[mode] == NULL)
		return 0;
	switch (mode) {
		case G640x480x256 :
		case G800x600x256 :
			return (oak_memory >= 512);
		case G1024x768x256 :
			return (oak_memory == 1024);
		default :
			return 1;
	}
}


/* Set a mode */

static int oak_setmode( int mode ) {
	if (!oak_modeavailable(mode))
		return 1;	/* mode not available */
	if (STDVGAMODE(mode))
		/* Use VGA driver to set mode */
		vga_chipsetfunctions[CHIPSET_SETMODE](mode);
	else {
		char *regs = oak_moderegs[mode - G640x480x256];
		vga_setregs(regs);
		oak_setregs(regs);
	}
}


/* Unlock chipset-specific registers */

static int oak_unlock() {
}


/* Relock chipset-specific registers */

static int oak_lock() {
}


/* Indentify chipset; return non-zero if detected */
/* Taken from vgadoc2 */

static int testindex( int port, int reg, int mask ) {
	int old, nw1, nw2;
	outb(port, reg);
	old = inb(port + 1);
	outb(port + 1, old & (~mask));
	nw1 = inb(port + 1) & mask;
	outb(port + 1, old | mask);
	nw2 = inb(port + 1) & mask;
	outb(port + 1, old);
	return (nw1 == 0) && (nw2 == mask);
}

static int oak_test()
{
	if (!testindex(0x3de, 0x0d, 0x38))
		return 0;

	oak_init(0, 0, 0);	
    	return 1;
}


/* Bank switching function - set 64K bank number */

static int oak_setpage( int page ) {
	outw(0x3de, 0x11 + (page << 8) + (page << 12));
}


/* Set display start address (not for 16 color modes) */
/* I don't know of any Oak register for extended bits */
/* Consequently this works only up to 256K */

static int oak_setdisplaystart( int address ) {
	outw(0x3d4, 0x0d + ((address >> 2) & 0x00ff) * 256);	/* sa2-sa9 */
	outw(0x3d4, 0x0c + ((address >> 2) & 0xff00));		/* sa10-sa17 */
	inb(0x3da);			/* set ATC to addressing mode */
	outb(0x3c0, 0x13 + 0x20);	/* select ATC reg 0x13 */
	outb(0x3c0, (inb(0x3c1) & 0xf0) | ((address & 3) << 1));
		/* write sa0-1 to bits 1-2 */
}


/* Set logical scanline length (usually multiple of 8) */
/* Multiples of 8 to 2040 */

static int oak_setlogicalwidth( int width ) { 
	outw(0x3d4, 0x13 + (width >> 3) * 256);	/* lw3-lw11 */
}


/* Function table (exported) */

int (*oak_chipsetfunctions[])() = {
	oak_saveregs,
	oak_setregs,
	oak_unlock,
	oak_lock,
	oak_test,
	oak_init,
	oak_setpage,
	oak_setmode,
	oak_modeavailable,
	oak_setdisplaystart,
	oak_setlogicalwidth,
	oak_getmodeinfo
};


/* Initialize chipset (called after detection) */

static int oak_init( int force, int par1, int par2) {
	int v;
	if (force) {
		oak_memory = par1;
		oak_chiptype = par2;
	}
	else {

		if (testindex(0x3de, 0x11, 0xff)) {
			outb(0x3de, 0x0b);
			if (inb(0x3df) == 5)
				oak_chiptype = 77;
			else
				oak_chiptype = 67;
		}
		else
			oak_chiptype = 37;


		outb(0x3de, 0x0d);	/* bit 6 & 7 indicate memory */
		v = inb(0x3df);
		if (v & 0x40)
			oak_memory = 1024;
		else
			if (v & 0x80)
				oak_memory = 512;
			else
				oak_memory = 256; 
	}
	
	if (__driver_report) {
		printf("Using Oak driver (0%d, %dK).\n", oak_chiptype, 
			oak_memory);
	}
	chipsetfunctions = oak_chipsetfunctions;
}
