/*
 * bitops.h		- Bit operations for e2fsck and mke2fs
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file is based on the minix file system programs fsck and mkfs
 * written and copyrighted by Linus Torvalds <Linus.Torvalds@cs.helsinki.fi>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from e2fsck and mke2fs
 */

#ifndef __GNUC__
#error "needs gcc for the bitop-__asm__'s"
#endif

#define bitop(name,op) \
static inline int name (char * addr, unsigned int nr) \
{ \
	int __res; \
	__asm__ __volatile__("bt" op "l %1,%2; adcl $0,%0" \
			     :"=g" (__res) \
			     :"r" (nr),"m" (*(addr)),"0" (0)); \
	return __res; \
}

bitop (testbit, "")
bitop (setbit, "s")
bitop (clrbit, "r")

#define inode_in_use(x)	(testbit (inode_map, (x) - 1))
#define block_in_use(x)	(testbit (block_map, (x) - FIRSTBLOCK))
#define block_is_bad(x)	(testbit (bad_map, (x) - FIRSTBLOCK))

#define mark_inode(x)	(setbit (inode_map, (x) - 1), changed = 1)
#define unmark_inode(x)	(clrbit (inode_map, (x) - 1), changed = 1)

#define mark_block(x)	(setbit (block_map, (x) - FIRSTBLOCK), changed = 1)
#define unmark_block(x)	(clrbit (block_map, (x) - FIRSTBLOCK), changed = 1)

#define mark_bad(x)	(setbit (bad_map, (x) - FIRSTBLOCK), badblocks++)
