#ifndef   MNTENT_H
#define   MNTENT_H

#include <features.h>

/*
 * File system table, see fstab (5)
 *
 * Used by dump, mount, umount, swapon, fsck, df, ...
 */

#define FSTAB   "/etc/fstab"
#define MOUNTED "/etc/mtab"

#define MNTMAXSTR 128

#define MNTTYPE_MINIX   "minix"    /* Minix Filesystem */
#define MNTTYPE_EXT     "ext"      /* Extended Filesystem */
#define MNTTYPE_EXT2    "ext2"     /* Extended 2 Filesystems */
#define MNTTYPE_XIAFS   "xiafs"    /* Xiafs filesystem */
#define MNTTYPE_NFS     "nfs"      /* Nfs mounted filesystem */
#define MNTTYPE_PC      "msdos"    /* IBM PC filesystem */
#define MNTTYPE_PROC    "proc"     /* Proc filesystem */
#define MNTTYPE_SWAP    "swap"     /* Swap file system */
#define MNTTYPE_IGNORE  "ignore"   /* Ignore this entry */

#define MNTOPT_DEFAULTS "defaults" /* use all default opts */
#define MNTOPT_RO       "ro"       /* read only */
#define MNTOPT_RW       "rw"       /* read/write */
#define MNTOPT_SUID     "suid"     /* set-uid execution allowed */
#define MNTOPT_NOSUID   "nosuid"   /* set-uid execution not allowed */
#define MNTOPT_EXEC     "exec"     /* allow execution of binaries */
#define MNTOPT_NOEXEC   "noexec"   /* don't execute binaries */
#define MNTOPT_DEV      "dev"      /* interpret device files */
#define MNTOPT_NODEV    "nodev"    /* don't interpret devices */
#define MNTOPT_SYNC     "sync"     /* synchronous I/O */
#define MNTOPT_ASYNC    "async"    /* asynchronous I/O */
#define MNTOPT_SUB      "sub"      /* allow submounts */
#define MNTOPT_NOSUB    "nosub"    /* don't allow submounts */
#define MNTOPT_USRQUOTA "usrquota" /* userquotas */
#define MNTOPT_GRPQUOTA "grpquota" /* groupquotas */
#define MNTOPT_NOQUOTA  "noquota"  /* no quotas */
#define MNTOPT_NOAUTO   "noauto"   /* hide entry from mount -a */
#define MNTOPT_SWAP     "swap"     /* swap option */
#define MNTOPT_DUMP     "dump"     /* dump option */
#define MNTOPT_BG       "bg"       /* retry in background (NFS) */
#define MNTOPT_FG       "fg"       /* retry in foreground (NFS) */
#define MNTOPT_INTR     "intr"     /* allow interrupts when mounting (NFS) */
#define MNTOPT_SECURE   "secure"   /* only allow secure nfs mounts (NFS) */
#define MNTOPT_POSIX    "posix"    /* use posix standard on nfs mount (NFS) */
#define MNTOPT_AC       "ac"       /* use attribute caching (NFS) */
#define MNTOPT_NOAC     "noac"     /* don't use attribute caching (NFS) */
#define MNTOPT_RETRY    "retry"    /* number of retries (NFS) */
#define MNTOPT_TIMEOUT  "timeo"    /* NFS timeout in thenths seconds */
#define MNTOPT_RETRANS  "retrans"  /* number of retransmissions (NFS) */
#define MNTOPT_PORT     "port"     /* port used (NFS) */
#define MNTOPT_SOFT     "soft"     /* error when no response (NFS) */
#define MNTOPT_HARD     "hard"     /* retry until server responds (NFS) */

__BEGIN_DECLS

struct   mntent{
   char   *mnt_fsname; /* name of mounted file system */
   char   *mnt_dir;    /* file system path prefix */
   char   *mnt_type;   /* MNTTYPE_* */
   char   *mnt_opts;   /* MNTOPT_* */
   int   mnt_freq;     /* dump frequency, in days */
   int   mnt_passno;   /* pass number on parallel fsck */
};

__END_DECLS

#define __need_file
#include <stdio.h>

__BEGIN_DECLS

extern FILE    *setmntent __P ((const char *__filep,
         const char *__type));
extern struct mntent
      *getmntent __P ((FILE *__filep));
extern int   addmntent __P ((FILE *__filep,
         const struct mntent *__mnt));
extern char   *hasmntopt __P ((const struct mntent *__mnt,
         const char *__opt));
extern int   endmntent __P ((FILE *__filep));

__END_DECLS

#endif   /* MNTENT_H */
