#ifndef _M68K_SYSCALL_H
#define _M68K_SYSCALL_H

#define _syscall0(type,name) \
type name(void) \
{ \
register long __res __asm__ ("d0"); \
__asm__ __volatile__ ("movel %0,d0\n\t" \
		      "trap  #0\n\t" \
		      "bcc   1f\n\t" \
		      "movel d0,_errno\n\t" \
		      "moveq #-1,d0\n\t" \
		      "1:" \
		      :: "i" (SYS_##name) : "d0" ); \
return (type) __res; \
}

#define _syscall1(type,name,atype,a) \
type name(atype a) \
{ \
register long __res __asm__ ("d0"); \
__asm__ __volatile__ ("movel %1,d1\n\t" \
		      "movel %0,d0\n\t" \
		      "trap  #0\n\t" \
		      "bcc   1f\n\t" \
		      "movel d0,_errno\n\t" \
		      "moveq #-1,d0\n\t" \
		      "1:" \
		      :: "i" (SYS_##name), "g" ((long)(a)) : "d0", "d1" ); \
return (type) __res; \
}

#define _syscall2(type,name,atype,a,btype,b) \
type name(atype a,btype b) \
{ \
register long __res __asm__ ("d0"); \
__asm__ __volatile__ ("movel %1,d1\n\t" \
		      "movel %2,d2\n\t" \
		      "movel %0,d0\n\t" \
		      "trap  #0\n\t" \
		      "bcc   1f\n\t" \
		      "movel d0,_errno\n\t" \
		      "moveq #-1,d0\n\t" \
		      "1:" \
		      :: "i" (SYS_##name), "g" ((long)(a)), \
					    "g" ((long)(b)) \
		      : "d0", "d1", "d2" ); \
return (type) __res; \
}

#define _syscall3(type,name,atype,a,btype,b,ctype,c) \
type name(atype a,btype b,ctype c) \
{ \
register long __res __asm__ ("d0"); \
__asm__ __volatile__ ("movel %1,d1\n\t" \
		      "movel %2,d2\n\t" \
		      "movel %3,d3\n\t" \
		      "movel %0,d0\n\t" \
		      "trap  #0\n\t" \
		      "bcc   1f\n\t" \
		      "movel d0,_errno\n\t" \
		      "moveq #-1,d0\n\t" \
		      "1:" \
		      :: "i" (SYS_##name), "g" ((long)(a)), \
					    "g" ((long)(b)), \
					    "g" ((long)(c))  \
		      : "d0", "d1", "d2", "d3" ); \
return (type) __res; \
}

#define _syscall4(type,name,atype,a,btype,b,ctype,c,dtype,d) \
type name (atype a, btype b, ctype c, dtype d) \
{ \
register long __res __asm__ ("d0"); \
__asm__ __volatile__ ("movel %1,d1\n\t" \
		      "movel %2,d2\n\t" \
		      "movel %3,d3\n\t" \
		      "movel %4,d4\n\t" \
		      "movel %0,d0\n\t" \
		      "trap  #0\n\t" \
		      "bcc   1f\n\t" \
		      "movel d0,_errno\n\t" \
		      "moveq #-1,d0\n\t" \
		      "1:" \
		      :: "i" (SYS_##name), "g" ((long)(a)), \
					    "g" ((long)(b)), \
					    "g" ((long)(c)), \
					    "g" ((long)(d))  \
		      : "d0", "d1", "d2", "d3", "d4" ); \
return (type)__res; \
}

#define _syscall5(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e) \
type name (atype a,btype b,ctype c,dtype d,etype e) \
{ \
register long __res __asm__ ("d0"); \
__asm__ __volatile__ ("movel %1,d1\n\t" \
		      "movel %2,d2\n\t" \
		      "movel %3,d3\n\t" \
		      "movel %4,d4\n\t" \
		      "movel %5,d5\n\t" \
		      "movel %0,d0\n\t" \
		      "trap #0\n\t" \
		      "bcc   1f\n\t" \
		      "movel d0,_errno\n\t" \
		      "moveq #-1,d0\n\t" \
		      "1:" \
		      :: "i" (SYS_##name), "g" ((long)(a)), \
					    "g" ((long)(b)), \
					    "g" ((long)(c)), \
					    "g" ((long)(d)), \
					    "g" ((long)(e))  \
		      : "d0", "d1", "d2", "d3", "d4", "d5" ); \
return (type) __res; \
}

#endif /* _M68K_SYSCALL_H */
