#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ax25.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

void main(int argc, char *argv[])
{
	struct sockaddr_ax25 dest;
	struct sockaddr_ax25 src;
	int s;
	
	if(config_load_ports()==-1)
	{
		fprintf(stderr,"%s: No ports defined.\n",argv[0]);
		exit(1);
	}
	
	if(argc!=2)
	{
		fprintf(stderr,"%s \"banner text\"\n",argv[0]);
		exit(1);
	}
	
	s=socket(AF_AX25,SOCK_DGRAM,PF_AX25);
	if(s==-1)
	{
		perror("socket");
		exit(1);
	}
	
	convert_call("IDENT",&dest);
		
	while(1)
	{
		int n=0;
		while(n<config_num_ports())
		{
			convert_call(config_get_addr(n),&src);
			if(bind(s,(struct sockaddr *)&src,sizeof(src))==-1)
			{
				perror("bind");
				exit(1);
			}
		
			if(sendto(s,argv[1],strlen(argv[1]),0,(struct sockaddr *)&dest,sizeof(dest))==-1)
				perror("send");
			n++;
		}
		sleep(30*60);
	}
}
