#include <stdio.h>
#include <syslog.h>
#include <sys/ioctl.h>
#include <rpc/rpc.h>
#ifdef DEBUG
#include <signal.h>
#endif /* DEBUG */

#include "hnfsd.h"
#include "libc.h"
#include "fh.h"			/* Just for fh_init() */

extern char *optarg;
extern int optind;
extern void toggle_logging(void);
extern void nfs_dispatch( struct svc_req *rqstp, SVCXPRT *transp);
void init_auth(char *filename);


/* No prototypes. */
extern int pmap_unset();


int	promiscuous = 0;
char	*log_file = NULL;

static int makesock(int port, int socksz);

void
main(argc, argv)
int	argc;
char	**argv;
{
    int c;
    int log_flag = 0;
    
    SVCXPRT *transp;
    int nfs_socket;
    char *auth_file = NULL;

#ifdef LOG_DAEMON
    openlog("hnfsd", LOG_PID, LOG_DAEMON);
#else
    openlog("hnfsd", LOG_PID|LOG_TIME);
#define LOG_DAEMON 0		/* Ignore it if it's not there */
#endif /* LOG_DAEMON */

    /* This code uses the RPC library functions in exactly the same way
       a regular RPC application would. */
    pmap_unset(NFS_PROGRAM, NFS_VERSION);
    
    if ((nfs_socket = makesock(NFS_PORT, NFS_MAXDATA)) < 0) {
	fprintf(stderr, "Could not make a socket.\n");
	exit(1);
    }
    transp = svcudp_create(nfs_socket);
    if (transp == NULL) {
	fprintf(stderr, "Cannot create UDP service.\n");
	exit(1);
    }
    if (!svc_register(transp, NFS_PROGRAM, NFS_VERSION, nfs_dispatch,
		      IPPROTO_UDP)) {
	fprintf(stderr,
		"unable to register (NFS_PROGRAM, NFS_VERSION, udp).\n");
	exit(1);
    }

    /* How can something as ugly as getopt() be considered good coding
       style?  Now if we had an option-getter that included option
       documentation that could be passed to a shell, that would be
       something... */
    while ((c = getopt(argc, argv, "df:l:p")) != EOF)
	switch (c) {
	case 'd':
	    log_flag++;
	    break;
	case 'f':
	    auth_file = optarg;
	    break;
	case 'l':
	    log_file = optarg;
	    break;
	case 'p':
	    promiscuous = 1;
	    break;
	case '?':
	    syslog(LOG_DAEMON|LOG_ERR, "Unknown option '-%c'", c);
	}
    if (argv[optind] != NULL)
	    syslog(LOG_DAEMON|LOG_ERR, "Bad argument -- %s", argv[optind]);
    /* We have to deal with the grunge of real/effective/saved uid.
       First we make both both the real and effective uid to root.  We shouldn't
       really need to change the real uid, but it occasionally has problems with
       losing root permissions if we don't.  ( ??? yeah -- I should track it down) */
    if (setreuid(0, 0) < 0) {
	fprintf(stderr, "%s:Unable to reset my reuids to root: %s.\n", argv[0],
		sys_errlist[errno]);
	exit(1);
    }

    if (log_flag)
	toggle_logging();

#ifndef NO_FORK
    {
	int fd;
	
	if (fork())
	    exit(0);
	close(0);
	close(1);
	close(2);
	if ((fd = open("/dev/tty", 2, 0)) >= 0) {
	    ioctl(fd, TIOCNOTTY, (char *)0);
	    (void) close(fd);
	}
    }
#endif /* NO_FORK */

    fh_init();
    init_auth(auth_file);
#ifdef DEBUG
    signal(SIGUSR1, toggle_logging);
#endif /* DEBUG */

    svc_run();
    syslog(LOG_DAEMON|LOG_ERR, "Oh no Mr. Bill... svc_run returned!\n");
    exit(1);
}


static int makesock(int port, int socksz)
{
    struct sockaddr_in	sin;
    int			s;
    
    s = socket(AF_INET, SOCK_DGRAM, 0);
    if (s < 0) {
	syslog(LOG_DAEMON|LOG_ERR, "Could not make a socket: %m");
	return -1;
    }
    bzero((char *)&sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = htons(port);
    
#ifdef SO_SNDBUF
    {
	int	sblen, rblen;

	sblen = rblen = socksz + 1024;
	/* 1024 for rpc & transport overheads */
	if ( setsockopt(s, SOL_SOCKET, SO_SNDBUF, &sblen, sizeof sblen) < 0
	    || setsockopt(s, SOL_SOCKET, SO_RCVBUF, &rblen, sizeof rblen) < 0)
	    syslog(LOG_DAEMON|LOG_ERR, "setsockopt failed: %m");
    }
#endif /* SO_SNDBUF */
    
    if (bind(s, &sin, sizeof(sin)) == -1) {
	syslog(LOG_DAEMON|LOG_ERR, "Could not bind name to socket: %m");
	return -1;
    }
    
    return s;
}

