/*****************************************************************************\
*									      *
*	File:     auth_clnt.c						      *
*	Author:   Don Becker						      *
*	Created:  Fri Jun  9 17:31:20 1989				      *
*	Contents: Client authentication routines for the NFS server	      *
*		Someday this should be update to encompass explicit Kerberos  *
*		authentication, in addition to the currently implemented      *
*		RPC-level scheme and the new "secure RPC" authentication.     *
*									      *
******************************************************************************/

/* #include <sys/socket.h>*/
#include <netdb.h>
#include <syslog.h>
#include "hnfsd.h"
#include "libc.h"

extern clnt_param *clients, *unknown_clients, *default_client;

clnt_param *
auth_clnt(rqstp)
	struct svc_req *rqstp;
{
    clnt_param	**cpp, *cp;
    
    /* find host parameter struct */
    for (cpp = &clients; *cpp != NULL; cpp = &((*cpp)->next)) {
	if ((*cpp)->clnt_addr.s_addr ==
	    svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr) {
	    cp = *cpp;
	    if (cp != clients) {
		/* Move to front */
		*cpp = cp->next;
		cp->next = clients;
		clients = cp;
	    }
	    goto found_it;
	}
    }
    
    /* Check the list of clients we didn't know at start-up. */
    for (cpp = &unknown_clients; (cp = *cpp) != NULL; ) {
	struct hostent	*hent;
	if ((hent = gethostbyname(cp->clnt_name)) != NULL) {
	    syslog(LOG_DAEMON|LOG_WARNING,
		   "Found previously unknown host %s.", cp->clnt_name);
	    cp->clnt_addr = *((struct in_addr *)hent->h_addr);

	    *cpp = cp->next;		/* Remove from unknown_clients list. */
	    cp->next = clients;		/* Add to the front of client list. */
	    clients = cp;
		
	    if (cp->clnt_addr.s_addr ==
		svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr)
		goto found_it;
	} else
	    cpp = &(cp->next);		/* The normal iteration. */
    }
    
    if (default_client != NULL)
	cp = default_client;
    else {
	syslog(LOG_DAEMON|LOG_CRIT, "Access attempt by unknown client %08X",
	       ntohl(svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr));
	return NULL;
    }
 found_it:
    /* check request originated on a privileged port */
    if (cp->o.secure_port  &&
	ntohs(svc_getcaller(rqstp->rq_xprt)->sin_port) >= IPPORT_RESERVED) {
	syslog(LOG_DAEMON|LOG_CRIT,
	       "NFS request from %08X originated on insecure port, psychoanalysis suggested",
	       ntohl(svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr));
	return NULL;
    }
    return cp;
}
