


GETTY(1m)                                               GETTY(1m)


NNAAMMEE
       getty - sets terminal mode, speed, and line discipline

SSYYNNOOPPSSIISS
       //eettcc//ggeettttyy  [-d  _d_e_f_a_u_l_t_s___f_i_l_e_]  [-a]  [-h] [-r _d_e_l_a_y_] [-t
       _t_i_m_e_o_u_t_] [-w _w_a_i_t_f_o_r_] lliinnee _[_s_p_e_e_d _[_t_y_p_e _[_l_i_n_e_d_]_]_]
       //eettcc//ggeettttyy --cc _g_e_t_t_y_d_e_f_s___f_i_l_e

DDEESSCCRRIIPPTTIIOONN
       _G_e_t_t_y is the  second  of  the  three  programs  _(_i_n_i_t(1m),
       _g_e_t_t_y(1m),  and  _l_o_g_i_n(1m)),  used  by the system to allow
       users to login.  _G_e_t_t_y is invoked by _i_n_i_t(1m) to:

       1. Open tty lines and set their modes.

       2. Print the login prompt, and get the user's name.

       3. Initiate a login process for the user.

       The actual  procedure  that  _g_e_t_t_y  follows  is  described
       below:   Initially,  _g_e_t_t_y parses its command line.  If no
       errors are found, _g_e_t_t_y scans the defaults file  (normally
       //eettcc//ddeeffaauulltt//ggeettttyy)  to  determine certain runtime values.
       The values in the defaults file  (whose  compiled-in  name
       can  be  altered  with the optional --dd _d_e_f_a_u_l_t_s___f_i_l_e argu-
       ment) take precedence to those on the command line.  _G_e_t_t_y
       then  opens the _l_i_n_e for reading and writing, and disables
       stdio buffering.  If an initialization was  specified,  it
       is performed (see LINE INITIALIZATION).

       Next, _g_e_t_t_y types the issue (or login banner, usually from
       //eettcc//iissssuuee) and login prompt.  Finally,  _g_e_t_t_y  reads  the
       user's  login  name  and invokes _l_o_g_i_n(1m) with the user's
       name as  an  argument.   While  reading  the  name,  _g_e_t_t_y
       attempts  to adapt the system to the speed of the terminal
       being used, and also sets certain terminal parameters (see
       _t_e_r_m_i_o(7)) to conform with the user's login procedure.

       The  tty  device  used  by _g_e_t_t_y is determined by the _l_i_n_e
       argument.  _G_e_t_t_y uses the string //ddeevv//_l_i_n_e as the name  of
       the  device  to attach itself to.  Unless _g_e_t_t_y is invoked
       with the  --hh  flag  (or  HHAANNGGUUPP==NNOO  is  specified  in  the
       defaults file), it will force a hangup on the line by set-
       ting the speed to zero.  Giving --rr _d_e_l_a_y  on  the  command
       line   (or  using  WWAAIITTCCHHAARR==YYEESS  and  DDEELLAAYY==_d_e_l_a_y  in  the
       defaults file) will cause _g_e_t_t_y to wait for a single char-
       acter from the line, and then to wait _d_e_l_a_y seconds before
       continuing.  If no delay is desired, use --rr00.   Giving  --ww
       _w_a_i_t_f_o_r  on  the command line (or using WWAAIITTFFOORR==_w_a_i_t_f_o_r in
       the defaults file) will cause _g_e_t_t_y to wait for the speci-
       fied string of characters from the line before continuing.
       Giving --tt _t_i_m_e_o_u_t on the  command  line  (or  using  TTIIMMEE--
       OOUUTT==timeout in the defaults file) will cause _g_e_t_t_y to exit
       if no user name is accepted within _t_i_m_e_o_u_t  seconds  after



Release 2.0                 19-Sep-90                           1





GETTY(1m)                                               GETTY(1m)


       the login prompt is typed.

       The   _s_p_e_e_d  argument  is  a  label  to  a  entry  in  the
       //eettcc//ggeettttyyddeeffss  file  (see  _g_e_t_t_y_d_e_f_s(4)).    This   entry
       defines  to  _g_e_t_t_y  the  initial speed (baud rate) and tty
       settings, the login prompt to be used, the final speed and
       tty settings, and a pointer to another entry to try should
       the user indicate that the speed is not correct.  This  is
       done  by  sending a _<_b_r_e_a_k_> character (actually sequence).
       Under certain conditions, a carriage-return  will  perform
       the same function.  This is usually the case when getty is
       set to a higher speed than the modem or  terminal.   _G_e_t_t_y
       scans the gettydefs file sequentially looking for a match-
       ing entry.  If no _s_p_e_e_d was given or the entry  cannot  be
       found,  the first entry in the //eettcc//ggeettttyyddeeffss file is used
       as a default.  In the event that the gettydefs file cannot
       be  accessed, there is a compiled-in default entry that is
       used.

       The _t_y_p_e argument is a string which names the type of ter-
       minal  attached  to  the line.  The _t_y_p_e should be a valid
       terminal name listed in the tteerrmmiinnffoo(7)  database.   _G_e_t_t_y
       uses  this  value to determine how to clear the video dis-
       play.

       The _l_i_n_e_d argument is a string describing the line  disci-
       pline to use on the line.  The default is LLDDIISSCC00.

       As  mentioned, _g_e_t_t_y types the login prompt and then reads
       the user's login name.  If a null character  is  received,
       it  is  assumed  to be the result of the user pressing the
       _<_b_r_e_a_k_> key or the carriage-return  key  to  indicate  the
       speed  is  wrong.   This  causes  _g_e_t_t_y to locate the next
       _s_p_e_e_d in the series (defined in /etc/gettydefs).

       The user's name  is  terminated  by  a  new-line  or  car-
       riage-return  character.  A carriage-return results in the
       system being set to map those to new-lines (see _i_o_c_t_l(2)).

       The  user's  name  is  scanned  to see if it contains only
       upper-case characters.  If so, the system is  set  to  map
       any future upper-case characters into lower-case.

       A check option is provided for testing the gettydefs file.
       When _g_e_t_t_y is invoked  with  the  --cc_g_e_t_t_y_d_e_f_s  option,  it
       scans  the  named  _g_e_t_t_y_d_e_f_s  file  and prints out (to the
       standard output) the  values  it  sees.   If  any  parsing
       errors occur (due to errors in the syntax of the gettydefs
       file), they are reported.

DDEEFFAAUULLTTSS FFIILLEE
       During   its   startup,   _g_e_t_t_y   looks   for   the   file
       //eettcc//ddeeffaauulltt//ggeettttyy_._l_i_n_e_, (or, if it cannot find that file,
       then //eettcc//ddeeffaauulltt//ggeettttyy), and if found, reads the contents



Release 2.0                 19-Sep-90                           2





GETTY(1m)                                               GETTY(1m)


       for lines of the form

            NAME=_v_a_l_u_e

       This allows getty to have certain features configurable at
       runtime,  without  recompiling.    The   recognized   NAME
       strings, and their corresponding values, follows:

       SYSTEM=_n_a_m_e
             Sets  the  nodename  value  (displayed  by @@SS -- see
             PROMPT SUBSTITUTIONS) to _n_a_m_e.  The default  is  the
             _n_o_d_e_n_a_m_e  value  returned  by the _u_n_a_m_e(3) call.  On
             XENIX  systems,  if  the  value  of  nodename  is  a
             zero-length  string, the file //eettcc//ssyysstteemmiidd is exam-
             ined to get the nodename.  Note that some sites  may
             have  elected  to  compile  the  nodename value into
             _g_e_t_t_y.

       VERSION=_s_t_r_i_n_g
             Sets the value that is displayed by the @@VV parameter
             (see  PROMPT  SUBSTITUTIONS) to _s_t_r_i_n_g_.  There is no
             default value.  If _s_t_r_i_n_g begins with a '/'  charac-
             ter,  it  is  assumed  to  be the full pathname of a
             file, and @@VV is set to be the contents of that file.

       LOGIN=_n_a_m_e
             Sets  the  name  of  the login program to _n_a_m_e_.  The
             default is //bbiinn//llooggiinn  (see  _l_o_g_i_n(1m)).   If  used,
             _n_a_m_e  must  be the full pathname of the program that
             _g_e_t_t_y will execute instead of //bbiinn//llooggiinn.  Note that
             this  program  is called, as is //bbiinn//llooggiinn, the with
             the user's name as its only argument.

       INIT=_s_t_r_i_n_g
             If defined, _s_t_r_i_n_g is an expect/send  sequence  that
             is used to initialize the line before _g_e_t_t_y attempts
             to use it.  This string is in a form resembling that
             used  in  the  _L_._s_y_s  file  of  _u_u_c_p(1).   For  more
             details, see LINE INITIALIZATION.   By  default,  no
             initialization is done.

       ISSUE=_s_t_r_i_n_g
             During  startup, _g_e_t_t_y defaults to displaying, as an
             issue  or  login  banner,  the   contents   of   the
             //eettcc//iissssuuee  file.   If ISSUE is defined to a _s_t_r_i_n_g_,
             that string is typed instead.  If _s_t_r_i_n_g begins with
             a  '/' character, it is assumed to be the full path-
             name of a file, and that file  is  used  instead  of
             //eettcc//iissssuuee.

       CLEAR=_v_a_l_u_e
             If _v_a_l_u_e is NNOO, then _g_e_t_t_y will not attempt to clear
             the video screen before typing the  issue  or  login
             prompts.  The default is to clear the screen.



Release 2.0                 19-Sep-90                           3





GETTY(1m)                                               GETTY(1m)


       HANGUP=_v_a_l_u_e
             If  _v_a_l_u_e is NNOO, then _g_e_t_t_y will NOT hangup the line
             during its startup.  This is analogus to giving  the
             --hh argument on the command line.

       WAITCHAR=_v_a_l_u_e
             If  _v_a_l_u_e  is YYEESS, then _g_e_t_t_y will wait for a single
             character from it's line before continuing.  This is
             useful  for modem connections where the modem has CD
             forced high at all times, to keep  getty  from  end-
             lessly chatting with the modem.

       DELAY=_s_e_c_o_n_d_s
             Used  in conjunction with WWAAIITTCCHHAARR, this adds a time
             delay of _s_e_c_o_n_d_s after  the  character  is  accepted
             before  allowing  _g_e_t_t_y  to continue.  Both WWAAIITTCCHHAARR
             and DDEELLAAYY have the same effect as specifying --rr_d_e_l_a_y
             on the command line.  If WWAAIITTCCHHAARR is given without a
             DDEELLAAYY, the result is equal to having said --rr00 on the
             command  line.   The  default  is  to not wait for a
             character.

       TIMEOUT=_n_u_m_b_e_r
             As with the --tt _t_i_m_e_o_u_t command line argument,  tells
             _g_e_t_t_y to exit if no user name is accepted before the
             _n_u_m_b_e_r of seconds elapse after the login  prompt  is
             typed.   The  default is to wait indefinetly for the
             user name.

       CONNECT=_s_t_r_i_n_g
             If defined, _s_t_r_i_n_g should be an expect/send sequence
             (like that for INIT) to direct _g_e_t_t_y in establishing
             the connection.  _S_t_r_i_n_g may be defined  as  DDEEFFAAUULLTT,
             which will substitute the built-in string:

                  CONNECT\s\A\r\n

             The \A escape marks the place where the digits show-
             ing the speed will  be  seen.   See  CONNECTION  AND
             AUTOBAUDING for more details.  The default is to not
             perform a connection chat sequence.

       WAITFOR=_s_t_r_i_n_g
             This parameter is similar to WAITCHAR, but defines a
             string  of  characters to be waited for.  _G_e_t_t_y will
             wait until _s_t_r_i_n_g is  received  before  issuing  the
             login prompt.  This parameter is best used when com-
             bined with CONNECT, as in this example:

                  WAITFOR=RING
                  CONNECT="" ATA\r CONNECT\s\A

             This would cause _g_e_t_t_y to wait for the string  RRIINNGG,
             then   expect   nothing,  send  AATTAA  followed  by  a



Release 2.0                 19-Sep-90                           4





GETTY(1m)                                               GETTY(1m)


             carriage-return, and then wait for a string such  as
             CCOONNNNEECCTT  22440000, in which case, _g_e_t_t_y would set itself
             to 2400 baud.  The default is not to  wait  for  any
             string of characters.

       ALTLOCK=_l_i_n_e
             _U_u_g_e_t_t_y  uses  this  parameter  to lock an alternate
             device, in addition to the one it  is  attached  to.
             This  is  for  those systems that have two different
             device names that refer to the same  physical  port;
             e.g.   /dev/tty1A  vs.  /dev/tty1a,  where  one uses
             modem control and the other doesn't.  See  the  sec-
             tion on UUGETTY for more details.  The default is to
             have no alternate lockfile.

       The name of the defaults file can be changed by specifying
       --dd  _d_e_f_a_u_l_t_s___f_i_l_e  on  the command line.  If _d_e_f_a_u_l_t_s___f_i_l_e
       begins with a slash, it is assumed to be a complete  path-
       name  of  the  defaults file to be used.  Otherwise, it is
       assumed to be a regular filename, causing _g_e_t_t_y to use the
       pathname //eettcc//ddeeffaauulltt_/_d_e_f_a_u_l_t_s___f_i_l_e_.

PPRROOMMPPTT SSUUBBSSTTIITTUUTTIIOONNSS
       When  _g_e_t_t_y  is typing the issue or login banner (ususally
       //eettcc//iissssuuee), or the _l_o_g_i_n_-_p_r_o_m_p_t_,  it  recognizes  several
       escape  (quoted)  characters.   When  one  of these quoted
       characters is found, its value is substituted in the  out-
       put produced by _g_e_t_t_y_.  Recognized escape characters are:

       \\\\\\\\
             Backslash (\).

       \\\\b Backspace (^H).

       \\\\c Placed  at  the  end  of  a  string, this prevents a
             new-line from being typed after the string.

       \\\\f Formfeed (^L).

       \\\\n New-line (^J).

       \\\\r Carriage-return (^M).

       \\\\s A single space (' ').

       \\\\t Horizontal tab (^I).

       \\\\_n_n_n
             Outputs the ASCII character whose decimal  value  is
             _n_n_n.  If _n_n_n begins with 0, the value is taken to be
             in octal.  If it begins with 0x, the value is  taken
             to be in hexidecimal.

       In  addition,  a  single  backslash  at  the end of a line



Release 2.0                 19-Sep-90                           5





GETTY(1m)                                               GETTY(1m)


       causes the immediately following new-line to  be  ignored,
       allowing continuation lines.

       Also,  certain  @@_c_h_a_r  parameters  are  recognized.  Those
       parameters, and the value that  is  substituted  for  them
       are:

       @B    The  current  (evaluated at the time the @@BB is seen)
             baud rate.

       @D    The current date, in MM/DD/YY .

       @L    The _l_i_n_e to which _g_e_t_t_y is attached.

       @S    The system node name.

       @T    The current time, in HH:MM:SS (24-hour) .

       @U    The number of currently signed-on users.  This is  a
             count of the number of entries in the _/_e_t_c_/_u_t_m_p file
             that have a non-null ut_name field.

       @V    The value of VVEERRSSIIOONN, as given in the defaults file.

       To  display  a  single  '@'  character, use either '\@' or
       '@@'.

LLIINNEE IINNIITTIIAALLIIZZAATTIIOONN
       One of the greatest benefits (in the author's opinion,  at
       least)  is  the  ability  of  _g_e_t_t_y to initialize its line
       before use.  This will most likely be done on  lines  with
       modems,  not terminals, although initializing terminals is
       not out of the question.

       Line initialization is performed just after  the  _l_i_n_e  is
       opened  and  prior to handling the WAITCHAR and/or WAITFOR
       options.  Initialization is accomplished by placing an

            INIT=_s_t_r_i_n_g

       line in the defaults file.  _S_t_r_i_n_g is a series of  one  or
       more fields in the form

            expect [ send [ expect [ send ] ] ... ]

       This  resembles the expect/send sequences used in the UUCP
       _L_._s_y_s file,  with  the  following  exception:  A  carriage
       return is NOT appended automatically to sequences that are
       'sent.'  If you want  a  carriage-return  sent,  you  must
       explicitly show it, with '\r'.

       _G_e_t_t_y supports subfields in the expect field of the form

            expect[-send-expect]...



Release 2.0                 19-Sep-90                           6





GETTY(1m)                                               GETTY(1m)


       as  with UUCP.  All the escape characters (those beginning
       with a '\' character) listed in the  PROMPT  SUBSTITUTIONS
       section are valid in the send and expect fields.  In addi-
       tion, the following escape characters are recognized:

       \\\\p Inserts a 1-second delay.

       \\\\d Inserts a 2-second delay.

       \\\\K Sends a .25-second Break.

       \\\\T_n_n_n
             Modifies the default timeout (usually 30 seconds) to
             the  value  indicated  by _n_n_n.  The value _n_n_n may be
             decimal, octal, or hexidecimal;  see  the  usage  of
             \\_n_n_n in PROMPT SUBSTITUTIONS.

       Note  that  for  these  additional  escape  characters, no
       actual character is sent.

CCOONNNNEECCTTIIOONN AANNDD AAUUTTOOBBAAUUDDIINNGG
       _G_e_t_t_y will perform a chat sequence establish a proper con-
       nection.   The best use of this feature is to look for the
       CCOONNNNEECCTT message sent by a modem and set the line speed  to
       the number given in that message (e.g. CONNECT 2400).

       The   for  the  connect chat script is exactly the same as
       that for the INIT script (see LINE  INITIALIZATION),  with
       the following addition:

       \\\\A Marks  the  spot  where  the baud rate will be seen.
             This mark will match any and all digits 0-9 at  that
             location  in  the script, and set it's speed to that
             value, if possible.

       Autobauding, therefore, is enabled by placing the \\AA  mark
       in the chat script.  For example, the definition:

       CONNECT=CONNECT\s\A

       would match the string CCOONNNNEECCTT 11220000 and cause _g_e_t_t_y to set
       it's baud rate to 1200, using the following steps:

       1. Having matched the value 1200, _g_e_t_t_y  will  attempt  to
          find  an  entry  with  the  label 11220000 in the ggeettttyyddeeffss
          file.  If a matching gettydefs entry  is  found,  those
          values are used.  If there is no match, then

       2. The  gettydefs  values currently in use are modified to
          use the matched speed (e.g.  1200).   However,  if  the
          matched speed is invalid, then

       3. _G_e_t_t_y  logs a warning message and resumes normal opera-
          tion.  This allows the  practice  of  toggling  through



Release 2.0                 19-Sep-90                           7





GETTY(1m)                                               GETTY(1m)


          linked  entries  in  the  gettydefs  file  to behave as
          expected.


UUUUGGEETTTTYY
       _U_u_g_e_t_t_y has  identical  behavior  to  _g_e_t_t_y_,  except  that
       _u_u_g_e_t_t_y is designed to create and use the lock files main-
       tained by the UUCP family  _(_u_u_c_p(1),  _c_u(1)  and  others).
       This prevents two or more processes from having conficting
       use of a tty line.

       When _u_u_g_e_t_t_y starts up, if it sees a lock file on the line
       it intends to use, it will use the pid in the lock file to
       see if there is an active process holding  the  lock.   If
       not, _u_u_g_e_t_t_y will remove the lock file and continue.  If a
       valid process is found, _u_u_g_e_t_t_y will sleep until that pro-
       cess  releases  the  lock  and  then it will exit, forcing
       _i_n_i_t(1m) to spawn a new _u_u_g_e_t_t_y_.  Once no conflicting pro-
       cess is found, _u_u_g_e_t_t_y grabs the _l_i_n_e by creating the lock
       file itself before issuing the login  prompt.   This  pre-
       vents other processes from using the line.

       _U_u_g_e_t_t_y will normally only lock the name of the line it is
       running on.  On systems where there are two  device  names
       referring  to  the  same  port  (as  is the case where one
       device uses modem control while the other doesn't),  place
       a line of the form

            ALTLOCK=_l_i_n_e

       line in the defaults file.  For instance, if _u_u_g_e_t_t_y is on
       _/_d_e_v_/_t_t_y_1_a_, and you want to have it lock _/_d_e_v_/_t_t_y_1_A  also,
       use the line AALLTTLLOOCCKK==ttttyy11AA in the defaults file.

FFIILLEESS
       /dev/console    The device to which errors are reported.

       /etc/default/getty[_._l_i_n_e]
                       Contains  the runtime configuration.  Note
                       that             _u_u_g_e_t_t_y              uses
                       /etc/default/uugetty[_._l_i_n_e].

       /etc/gettydefs  Contains speed and tty settings to be used
                       by _g_e_t_t_y_.

       /etc/issue      The default issue (or login banner).

       /bin/login      The default login program called after the
                       user's name is entered.


SSEEEE AALLSSOO
       init(1m),  login(1m),  uucp(1), ioctl(2), uname(3), getty-
       defs(4), utmp(4), termio(7)



Release 2.0                 19-Sep-90                           8





GETTY(1m)                                               GETTY(1m)


AAUUTTHHOORR
       Paul Sutcliffe, Jr.  <paul@devon.lns.pa.us>
       UUCP: ...!rutgers!devon!paul

       Autobauding routines adapted from code submitted by
       Mark Keating <...!utzoo!censor!markk>



















































Release 2.0                 19-Sep-90                           9


