/*
 * Implement the hello, world system call.
 */

#include <linux/unistd.h>

#define SYSCALL_NUM __NR_mod_nosys2

typedef int (*fn_ptr)();

extern fn_ptr sys_call_table[];
extern int NR_syscalls;
extern int no_sys();

int sys_hello(void);

int
init() {
	printk("installing system call\n");
	if (NR_syscalls <= SYSCALL_NUM) {
		printk("No space in system call table\n");
		return -1;
	}
	if (sys_call_table[SYSCALL_NUM] != no_sys) {
		printk("System call number %d is already in use\n", SYSCALL_NUM);
		return -1;
	}
	sys_call_table[SYSCALL_NUM] = sys_hello;
	printk("Hello world system call loaded\n");
	return 0;
}

void
cleanup() {
	printk("hello.c:  cleanup called\n");
	sys_call_table[SYSCALL_NUM] = no_sys;
}

int
sys_hello() {
	printk("Hello, world!\n");
	return 0;
}
