# This program will construct ksyms.s.  Ksyms.s contains a symbol table
# for all the kernel symbols included in the file ksyms.lst.  The following
# variables are defined in ksym.s:
#
#	int symbol_table_size;		/* number of symbols */
#	struct {
#		void *value;		/* value of symbol */
#		char *name;		/* name of symbol */
#	} symbol_table[];

sed -e '/^#/d' -e '/^$/d' ksyms.lst | sort > ksyms.tmp

echo '.data
.globl _symbol_table_size, _symbol_table

_symbol_table_size:'
echo "	.long" `wc -l < ksyms.tmp`
echo '
_symbol_table:'
awk 'BEGIN {stringloc = 0}
{print "	.long " $0; print "	.long strings+" stringloc; stringloc += length($0) + 1;}' ksyms.tmp
echo '
strings:'
awk '{print "	.ascii \"" $0 "\\0\""}' ksyms.tmp
rm ksyms.tmp
