/* linux/kernel/chr_drv/sound/midibuf.c

Device file manager for /dev/midi

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/ctype.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <sys/kd.h>
#include <linux/wait.h>
#include <linux/soundcard.h>
#include "sound_calls.h"
#include "sound_config.h"

#ifdef CONFIGURE_SOUNDCARD

#include "dev_table.h"

#define OUTB outb
#define DEB(WHAT)		/* (WHAT) */
#define DEB1(WHAT)		/* (WHAT) */


int
MIDIbuf_open (struct inode *inode, struct file *filp)
{
  int dev;
  int mode;

  dev = inode->i_rdev;
  dev = MINOR (dev) >> 4;
  mode = filp->f_flags & O_ACCMODE;

  return -ENODEV;
}

void
MIDIbuf_release (struct inode *inode, struct file *filp)
{
  int dev;
  int mode;

  dev = inode->i_rdev;
  dev = MINOR (dev) >> 4;
  mode = filp->f_flags & O_ACCMODE;

}


int
MIDIbuf_write (struct inode *inode, struct file *file, char *buf, int count)
{
  int dev;

  dev = inode->i_rdev;
  dev = MINOR (dev) >> 4;

  return count;
}


int
MIDIbuf_read (struct inode *inode, struct file *file, char *buf, int count)
{
  int dev;

  dev = inode->i_rdev;
  dev = MINOR (dev) >> 4;

  return -EIO;
}

int
MIDIbuf_ioctl (struct inode *inode, struct file *file,
	       unsigned int cmd, unsigned int arg)
{
  int dev;

  dev = inode->i_rdev;
  dev = MINOR (dev) >> 4;

  switch (cmd)
    {

    default:
      return midi_devs[0]->ioctl (dev, cmd, arg);
    }
}

void
MIDIbuf_bytes_received (int dev, unsigned char *buf, int count)
{
}

long
MIDIbuf_init (long mem_start)
{
  return mem_start;
}

#endif
