/*
	linux/kernel/chr_drv/sound/dev_table.h

	Global definitions for device call tables

	(C) Hannu Savolainen 1992

*/

#ifndef _DEV_TABLE_H_
#define _DEV_TABLE_H_

/*
 *	NOTE! 	NOTE!	NOTE!	NOTE!
 *
 *	If you modify this file, please check the dev_table.c also.
 *
 *	NOTE! 	NOTE!	NOTE!	NOTE!
 */

struct card_info {
	int card_type;	/*	From soundcard.c	*/
	char *name;
	long (*detect) (long mem_start);
};

struct audio_operations {
	int (*open) (int dev, int mode);
	void (*close) (int dev);
	void (*output_block) (int dev, char *buf, int count);
	void (*start_input) (int dev, char *buf, int count);
	int (*ioctl) (int dev, unsigned int cmd, unsigned int arg);
	int (*prepare_for_input) (void);
	int (*prepare_for_output) (void);
	void (*reset) (int dev);
	int (*sync) (int dev);
};

struct mixer_operations {
	int (*ioctl) (int dev, unsigned int cmd, unsigned int arg);
};

struct synth_operations {
	int (*open) (int dev, int mode);
	void (*close) (int dev);
	int (*ioctl) (int dev, unsigned int cmd, unsigned int arg);
	int (*kill_note) (int dev, int voice);
	int (*start_note) (int dev, int voice, int note, int velocity);
	int (*set_instr) (int dev, int voice, int instr);
	void (*reset) (int dev);
	int (*kill_drum) (int dev, int voice);
	int (*start_drum) (int dev, int voice, int note, int velocity);
};

struct midi_operations {
	int (*open) (int dev, int mode);
	void (*close) (int dev);
	int (*ioctl) (int dev, unsigned int cmd, unsigned int arg);
	int (*putc) (int dev, unsigned char data);
	int (*start_read) (int dev);
	int (*end_read) (int dev);
};

#ifdef _DEV_TABLE_C_
	struct audio_operations * dsp_devs[MAX_DSP_DEV] = {NULL}; int num_dspdevs = 0;
	struct mixer_operations * mixer_devs[MAX_MIXER_DEV] = {NULL}; int num_mixers = 0;
	struct synth_operations * synth_devs[MAX_SYNTH_DEV] = {NULL}; int num_synths = 0;
	struct midi_operations * midi_devs[MAX_MIDI_DEV] = {NULL}; int num_midis = 0;

/*
 *	Note! The detection order is significant. Don't change it.
 */

	struct card_info supported_drivers[] = {
#ifndef EXCLUDE_PAS
		{SNDCARD_PAS,	"ProAudioSpectrum",	detect_pas_card},
#endif

#ifndef EXCLUDE_SB
		{SNDCARD_SB,	"SoundBlaster",		detect_sb_card},
#endif

#ifndef EXCLUDE_ADLIB
		{SNDCARD_ADLIB,	"AdLib",		detect_adlib_card},
#endif
		{0,		"*?*",			NULL}
	};
#else
	extern struct audio_operations * dsp_devs[MAX_DSP_DEV]; int num_dspdevs;
	extern struct mixer_operations * mixer_devs[MAX_MIXER_DEV]; extern int num_mixers;
	extern struct synth_operations * synth_devs[MAX_SYNTH_DEV]; extern int num_synths;
	extern struct midi_operations * midi_devs[MAX_MIDI_DEV]; extern int num_midis;
#endif

long sndtable_init(long mem_start);
int sndtable_get_cardcount (void);
int sndtable_config (struct soundcard_config *conf);

#endif
