/*
 * Dynamic loading of modules into the kernel.
 */

#ifndef _LINUX_MODULE_H
#define _LINUX_MODULE_H

#include <linux/sched.h>

/* values of module.state */
#define MOD_UNINITIALIZED 0
#define MOD_RUNNING 1
#define MOD_DELETED 2
#define MOD_INST_ALLOW suser()  /* change to 1 to allow anyone to install devices */

/* maximum length of module name */
#define MOD_MAX_NAME 64


struct module {
	struct module *next;
	char *name;
	int size;			/* size of module in pages */
	unsigned long addr;		/* address of module */
	int state;
	void (*cleanup)(void);		/* cleanup routine */
};


struct mod_routines {
	int (*init)(void);		/* initialization routine */
	void (*cleanup)(void);		/* cleanup routine */
};


struct kernel_sym {
	unsigned long value;		/* value of symbol */
	char name[28];			/* name of symbol */
};


/*
 * The first word of the module contains the use count.
 */
#define GET_USE_COUNT(module)	(* (int *) (module)->addr)

extern struct module *module_list;

#endif
