.\"@(#)nfsv4.exportd.8"
.\"
.\" Copyright (C) 2021 Red Hat <nfs@redhat.com>
.\"
.TH nfsv4.exportd 8 "02 Feb 2021"
.SH NAME
nfsv4.exportd \- NFSv4 Server Mount Daemon
.SH SYNOPSIS
.BI "/usr/sbin/nfsv4.exportd [" options "]"
.SH DESCRIPTION
The
.B nfsv4.exportd
is used to manage NFSv4 exports. The NFSv4 server
receives a mount request from a client and pass it up to 
.B nfsv4.exportd. 
.B nfsv4.exportd 
then uses the exports(5) export
table to verify the validity of the mount request.
.PP
An NFS server maintains a table of local physical file systems
that are accessible to NFS clients.
Each file system in this table is referred to as an
.IR "exported file system" ,
or
.IR export ,
for short.
.PP
Each file system in the export table has an access control list.
.B nfsv4.exportd
uses these access control lists to determine
whether an NFS client is permitted to access a given file system.
For details on how to manage your NFS server's export table, see the
.BR exports (5)
and
.BR exportfs (8)
man pages.
.SH OPTIONS
.TP
.B \-d kind " or " \-\-debug kind
Turn on debugging. Valid kinds are: all, auth, call, general and parse.
.TP
.B \-F " or " \-\-foreground
Run in foreground (do not daemonize)
.TP
.B \-h " or " \-\-help
Display usage message.
.TP
.BR "\-t N" " or " "\-\-num\-threads=N " or  " \-\-num\-threads N "
This option specifies the number of worker threads that rpc.mountd
spawns.  The default is 1 thread, which is probably enough.  More
threads are usually only needed for NFS servers which need to handle
mount storms of hundreds of NFS mounts in a few seconds, or when
your DNS server is slow or unreliable.
.SH CONFIGURATION FILE
Many of the options that can be set on the command line can also be
controlled through values set in the
.B [exportd]
or, in some cases, the
.B [nfsd]
sections of the
.I /etc/nfs.conf
configuration file.
Values recognized in the
.B [exportd]
section include 
.B debug 
which each have the same effect as the option with the same name.
.SH FILES
.TP 2.5i
.I /etc/exports
input file for
.BR exportfs ,
listing exports, export options, and access control lists
.SH SEE ALSO
.BR exportfs (8),
.BR exports (5),
.BR showmount (8),
.BR nfs.conf (5),
.BR firwall-cmd (1),
.sp
RFC 3530 - "Network File System (NFS) version 4 Protocol"
