#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.samba.new
config etc/samba/lmhosts.new
# This won't be needed.  The point here is to preserve the permissions of the existing
# file, if there is one.  I don't see major new development happening in rc.samba...  ;-)
rm -f etc/rc.d/rc.samba.new
( cd usr/include ; rm -rf pytalloc.h )
( cd usr/include ; ln -sf samba-4.0/pytalloc.h pytalloc.h )
( cd usr/lib ; rm -rf libdcerpc-binding.so )
( cd usr/lib ; ln -sf libdcerpc-binding.so.0.0.1 libdcerpc-binding.so )
( cd usr/lib ; rm -rf libgssapi-samba4.so.2 )
( cd usr/lib ; ln -sf libgssapi-samba4.so.2.0.0 libgssapi-samba4.so.2 )
( cd usr/lib ; rm -rf libsamba-hostconfig.so )
( cd usr/lib ; ln -sf libsamba-hostconfig.so.0.0.1 libsamba-hostconfig.so )
( cd usr/lib ; rm -rf libndr-nbt.so.0 )
( cd usr/lib ; ln -sf libndr-nbt.so.0.0.1 libndr-nbt.so.0 )
( cd usr/lib ; rm -rf libtorture.so )
( cd usr/lib ; ln -sf libtorture.so.0.0.1 libtorture.so )
( cd usr/lib ; rm -rf libwind-samba4.so.0 )
( cd usr/lib ; ln -sf libwind-samba4.so.0.0.0 libwind-samba4.so.0 )
( cd usr/lib ; rm -rf libsmbsharemodes.so )
( cd usr/lib ; ln -sf libsmbsharemodes.so.0 libsmbsharemodes.so )
( cd usr/lib ; rm -rf libpytalloc-util.so )
( cd usr/lib ; ln -sf libpytalloc-util.so.2 libpytalloc-util.so )
( cd usr/lib ; rm -rf libsamba-policy.so.0 )
( cd usr/lib ; ln -sf libsamba-policy.so.0.0.1 libsamba-policy.so.0 )
( cd usr/lib ; rm -rf libdcerpc-server.so.0 )
( cd usr/lib ; ln -sf libdcerpc-server.so.0.0.1 libdcerpc-server.so.0 )
( cd usr/lib ; rm -rf libtorture.so.0 )
( cd usr/lib ; ln -sf libtorture.so.0.0.1 libtorture.so.0 )
( cd usr/lib ; rm -rf libndr-standard.so.0 )
( cd usr/lib ; ln -sf libndr-standard.so.0.0.1 libndr-standard.so.0 )
( cd usr/lib ; rm -rf libsamba-util.so )
( cd usr/lib ; ln -sf libsamba-util.so.0.0.1 libsamba-util.so )
( cd usr/lib ; rm -rf libpyldb-util.so.1 )
( cd usr/lib ; ln -sf libpyldb-util.so.1.1.16 libpyldb-util.so.1 )
( cd usr/lib ; rm -rf libheimbase-samba4.so.1 )
( cd usr/lib ; ln -sf libheimbase-samba4.so.1.0.0 libheimbase-samba4.so.1 )
( cd usr/lib ; rm -rf libregistry.so )
( cd usr/lib ; ln -sf libregistry.so.0.0.1 libregistry.so )
( cd usr/lib ; rm -rf libwbclient.so.0 )
( cd usr/lib ; ln -sf libwbclient.so.0.11 libwbclient.so.0 )
( cd usr/lib ; rm -rf libsamba-hostconfig.so.0 )
( cd usr/lib ; ln -sf libsamba-hostconfig.so.0.0.1 libsamba-hostconfig.so.0 )
( cd usr/lib ; rm -rf libkrb5-samba4.so.26 )
( cd usr/lib ; ln -sf libkrb5-samba4.so.26.0.0 libkrb5-samba4.so.26 )
( cd usr/lib ; rm -rf libndr-krb5pac.so.0 )
( cd usr/lib ; ln -sf libndr-krb5pac.so.0.0.1 libndr-krb5pac.so.0 )
( cd usr/lib ; rm -rf libroken-samba4.so.19 )
( cd usr/lib ; ln -sf libroken-samba4.so.19.0.1 libroken-samba4.so.19 )
( cd usr/lib ; rm -rf libkdc-samba4.so.2 )
( cd usr/lib ; ln -sf libkdc-samba4.so.2.0.0 libkdc-samba4.so.2 )
( cd usr/lib ; rm -rf libpytalloc-util.so.2 )
( cd usr/lib ; ln -sf libpytalloc-util.so.2.0.8 libpytalloc-util.so.2 )
( cd usr/lib ; rm -rf libsamdb.so )
( cd usr/lib ; ln -sf libsamdb.so.0.0.1 libsamdb.so )
( cd usr/lib ; rm -rf libdcerpc-binding.so.0 )
( cd usr/lib ; ln -sf libdcerpc-binding.so.0.0.1 libdcerpc-binding.so.0 )
( cd usr/lib ; rm -rf libregistry.so.0 )
( cd usr/lib ; ln -sf libregistry.so.0.0.1 libregistry.so.0 )
( cd usr/lib ; rm -rf libndr.so )
( cd usr/lib ; ln -sf libndr.so.0.0.2 libndr.so )
( cd usr/lib ; rm -rf libdcerpc.so.0 )
( cd usr/lib ; ln -sf libdcerpc.so.0.0.1 libdcerpc.so.0 )
( cd usr/lib ; rm -rf libndr-standard.so )
( cd usr/lib ; ln -sf libndr-standard.so.0.0.1 libndr-standard.so )
( cd usr/lib ; rm -rf libtalloc.so )
( cd usr/lib ; ln -sf libtalloc.so.2 libtalloc.so )
( cd usr/lib ; rm -rf libndr-nbt.so )
( cd usr/lib ; ln -sf libndr-nbt.so.0.0.1 libndr-nbt.so )
( cd usr/lib ; rm -rf libgensec.so )
( cd usr/lib ; ln -sf libgensec.so.0.0.1 libgensec.so )
( cd usr/lib ; rm -rf libdcerpc-server.so )
( cd usr/lib ; ln -sf libdcerpc-server.so.0.0.1 libdcerpc-server.so )
( cd usr/lib ; rm -rf libldb.so.1 )
( cd usr/lib ; ln -sf libldb.so.1.1.16 libldb.so.1 )
( cd usr/lib ; rm -rf libsmbldap.so )
( cd usr/lib ; ln -sf libsmbldap.so.0 libsmbldap.so )
( cd usr/lib ; rm -rf libhcrypto-samba4.so.5 )
( cd usr/lib ; ln -sf libhcrypto-samba4.so.5.0.1 libhcrypto-samba4.so.5 )
( cd usr/lib ; rm -rf libsamba-credentials.so )
( cd usr/lib ; ln -sf libsamba-credentials.so.0.0.1 libsamba-credentials.so )
( cd usr/lib ; rm -rf libsamba-credentials.so.0 )
( cd usr/lib ; ln -sf libsamba-credentials.so.0.0.1 libsamba-credentials.so.0 )
( cd usr/lib ; rm -rf libtevent-util.so )
( cd usr/lib ; ln -sf libtevent-util.so.0.0.1 libtevent-util.so )
( cd usr/lib ; rm -rf libdcerpc.so )
( cd usr/lib ; ln -sf libdcerpc.so.0.0.1 libdcerpc.so )
( cd usr/lib ; rm -rf libtdb.so.1 )
( cd usr/lib ; ln -sf libtdb.so.1.2.12 libtdb.so.1 )
( cd usr/lib ; rm -rf libdcerpc-samr.so )
( cd usr/lib ; ln -sf libdcerpc-samr.so.0.0.1 libdcerpc-samr.so )
( cd usr/lib ; rm -rf libhx509-samba4.so.5 )
( cd usr/lib ; ln -sf libhx509-samba4.so.5.0.0 libhx509-samba4.so.5 )
( cd usr/lib ; rm -rf libtevent-util.so.0 )
( cd usr/lib ; ln -sf libtevent-util.so.0.0.1 libtevent-util.so.0 )
( cd usr/lib ; rm -rf libdcerpc-atsvc.so )
( cd usr/lib ; ln -sf libdcerpc-atsvc.so.0.0.1 libdcerpc-atsvc.so )
( cd usr/lib ; rm -rf libsmbclient.so )
( cd usr/lib ; ln -sf libsmbclient.so.0.2.1 libsmbclient.so )
( cd usr/lib ; rm -rf libhdb-samba4.so.11 )
( cd usr/lib ; ln -sf libhdb-samba4.so.11.0.2 libhdb-samba4.so.11 )
( cd usr/lib ; rm -rf libnss_wins.so )
( cd usr/lib ; ln -sf libnss_wins.so.2 libnss_wins.so )
( cd usr/lib ; rm -rf libdcerpc-atsvc.so.0 )
( cd usr/lib ; ln -sf libdcerpc-atsvc.so.0.0.1 libdcerpc-atsvc.so.0 )
( cd usr/lib ; rm -rf libsmbclient-raw.so.0 )
( cd usr/lib ; ln -sf libsmbclient-raw.so.0.0.1 libsmbclient-raw.so.0 )
( cd usr/lib ; rm -rf libntdb.so.0 )
( cd usr/lib ; ln -sf libntdb.so.0.9 libntdb.so.0 )
( cd usr/lib ; rm -rf libheimntlm-samba4.so.1 )
( cd usr/lib ; ln -sf libheimntlm-samba4.so.1.0.1 libheimntlm-samba4.so.1 )
( cd usr/lib ; rm -rf libsamdb.so.0 )
( cd usr/lib ; ln -sf libsamdb.so.0.0.1 libsamdb.so.0 )
( cd usr/lib ; rm -rf libsamba-util.so.0 )
( cd usr/lib ; ln -sf libsamba-util.so.0.0.1 libsamba-util.so.0 )
( cd usr/lib ; rm -rf libsmbconf.so )
( cd usr/lib ; ln -sf libsmbconf.so.0 libsmbconf.so )
( cd usr/lib ; rm -rf libtevent.so.0 )
( cd usr/lib ; ln -sf libtevent.so.0.9.18 libtevent.so.0 )
( cd usr/lib ; rm -rf libndr.so.0 )
( cd usr/lib ; ln -sf libndr.so.0.0.2 libndr.so.0 )
( cd usr/lib ; rm -rf libnss_winbind.so )
( cd usr/lib ; ln -sf libnss_winbind.so.2 libnss_winbind.so )
( cd usr/lib ; rm -rf libsmbclient.so.0 )
( cd usr/lib ; ln -sf libsmbclient.so.0.2.1 libsmbclient.so.0 )
( cd usr/lib ; rm -rf libsmbclient-raw.so )
( cd usr/lib ; ln -sf libsmbclient-raw.so.0.0.1 libsmbclient-raw.so )
( cd usr/lib ; rm -rf libasn1-samba4.so.8 )
( cd usr/lib ; ln -sf libasn1-samba4.so.8.0.0 libasn1-samba4.so.8 )
( cd usr/lib ; rm -rf libsamba-policy.so )
( cd usr/lib ; ln -sf libsamba-policy.so.0.0.1 libsamba-policy.so )
( cd usr/lib ; rm -rf libpdb.so )
( cd usr/lib ; ln -sf libpdb.so.0 libpdb.so )
( cd usr/lib ; rm -rf libwbclient.so )
( cd usr/lib ; ln -sf libwbclient.so.0.11 libwbclient.so )
( cd usr/lib ; rm -rf libdcerpc-samr.so.0 )
( cd usr/lib ; ln -sf libdcerpc-samr.so.0.0.1 libdcerpc-samr.so.0 )
( cd usr/lib ; rm -rf libgensec.so.0 )
( cd usr/lib ; ln -sf libgensec.so.0.0.1 libgensec.so.0 )
( cd usr/lib ; rm -rf libtalloc.so.2 )
( cd usr/lib ; ln -sf libtalloc.so.2.0.8 libtalloc.so.2 )
( cd usr/lib ; rm -rf libnetapi.so )
( cd usr/lib ; ln -sf libnetapi.so.0 libnetapi.so )
( cd usr/lib ; rm -rf libndr-krb5pac.so )
( cd usr/lib ; ln -sf libndr-krb5pac.so.0.0.1 libndr-krb5pac.so )
