#!/bin/sh

config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/kde/kdm/backgroundrc.new
config etc/kde/kdm/kdmrc.new

if [ -x usr/bin/update-desktop-database ]; then
  usr/bin/update-desktop-database usr/share/applications >/dev/null 2>&1
fi

if [ -x usr/bin/update-mime-database ]; then
  usr/bin/update-mime-database usr/share/mime >/dev/null 2>&1
fi

( cd usr/lib ; rm -rf libplasmaclock.so.4 )
( cd usr/lib ; ln -sf libplasmaclock.so.4.10.5 libplasmaclock.so.4 )
( cd usr/lib ; rm -rf liblsofui.so )
( cd usr/lib ; ln -sf liblsofui.so.4 liblsofui.so )
( cd usr/lib ; rm -rf libsolidcontrolifaces.so )
( cd usr/lib ; ln -sf libsolidcontrolifaces.so.4 libsolidcontrolifaces.so )
( cd usr/lib ; rm -rf libkfontinstui.so )
( cd usr/lib ; ln -sf libkfontinstui.so.4 libkfontinstui.so )
( cd usr/lib ; rm -rf liboxygenstyle.so.4 )
( cd usr/lib ; ln -sf liboxygenstyle.so.4.10.5 liboxygenstyle.so.4 )
( cd usr/lib ; rm -rf libkdecorations.so )
( cd usr/lib ; ln -sf libkdecorations.so.4 libkdecorations.so )
( cd usr/lib ; rm -rf libtaskmanager.so.4 )
( cd usr/lib ; ln -sf libtaskmanager.so.4.10.5 libtaskmanager.so.4 )
( cd usr/lib ; rm -rf libksignalplotter.so.4 )
( cd usr/lib ; ln -sf libksignalplotter.so.4.10.5 libksignalplotter.so.4 )
( cd usr/lib ; rm -rf libkephal.so.4 )
( cd usr/lib ; ln -sf libkephal.so.4.10.5 libkephal.so.4 )
( cd usr/lib ; rm -rf libkfontinst.so )
( cd usr/lib ; ln -sf libkfontinst.so.4 libkfontinst.so )
( cd usr/lib ; rm -rf libplasmaclock.so )
( cd usr/lib ; ln -sf libplasmaclock.so.4 libplasmaclock.so )
( cd usr/lib ; rm -rf liblsofui.so.4 )
( cd usr/lib ; ln -sf liblsofui.so.4.10.5 liblsofui.so.4 )
( cd usr/lib ; rm -rf libkwineffects.so )
( cd usr/lib ; ln -sf libkwineffects.so.1 libkwineffects.so )
( cd usr/lib ; rm -rf libsolidcontrol.so )
( cd usr/lib ; ln -sf libsolidcontrol.so.4 libsolidcontrol.so )
( cd usr/lib ; rm -rf libkscreensaver.so.5 )
( cd usr/lib ; ln -sf libkscreensaver.so.5.0.0 libkscreensaver.so.5 )
( cd usr/lib ; rm -rf libplasma_applet-system-monitor.so.4 )
( cd usr/lib ; ln -sf libplasma_applet-system-monitor.so.4.10.5 libplasma_applet-system-monitor.so.4 )
( cd usr/lib ; rm -rf libkscreensaver.so )
( cd usr/lib ; ln -sf libkscreensaver.so.5 libkscreensaver.so )
( cd usr/lib ; rm -rf libweather_ion.so.6 )
( cd usr/lib ; ln -sf libweather_ion.so.6.0.0 libweather_ion.so.6 )
( cd usr/lib ; rm -rf libksgrd.so.4 )
( cd usr/lib ; ln -sf libksgrd.so.4.10.5 libksgrd.so.4 )
( cd usr/lib ; rm -rf libkworkspace.so.4 )
( cd usr/lib ; ln -sf libkworkspace.so.4.10.5 libkworkspace.so.4 )
( cd usr/lib ; rm -rf libplasmagenericshell.so )
( cd usr/lib ; ln -sf libplasmagenericshell.so.4 libplasmagenericshell.so )
( cd usr/lib ; rm -rf libplasma_applet-system-monitor.so )
( cd usr/lib ; ln -sf libplasma_applet-system-monitor.so.4 libplasma_applet-system-monitor.so )
( cd usr/lib ; rm -rf libsystemsettingsview.so )
( cd usr/lib ; ln -sf libsystemsettingsview.so.2 libsystemsettingsview.so )
( cd usr/lib ; rm -rf libksignalplotter.so )
( cd usr/lib ; ln -sf libksignalplotter.so.4 libksignalplotter.so )
( cd usr/lib ; rm -rf libprocessui.so )
( cd usr/lib ; ln -sf libprocessui.so.4 libprocessui.so )
( cd usr/lib ; rm -rf libkdecorations.so.4 )
( cd usr/lib ; ln -sf libkdecorations.so.4.10.5 libkdecorations.so.4 )
( cd usr/lib ; rm -rf libpowerdevilconfigcommonprivate.so )
( cd usr/lib ; ln -sf libpowerdevilconfigcommonprivate.so.4 libpowerdevilconfigcommonprivate.so )
( cd usr/lib ; rm -rf libkwinglesutils.so.1 )
( cd usr/lib ; ln -sf libkwinglesutils.so.1.0.0 libkwinglesutils.so.1 )
( cd usr/lib ; rm -rf libprocesscore.so )
( cd usr/lib ; ln -sf libprocesscore.so.4 libprocesscore.so )
( cd usr/lib ; rm -rf libplasma-geolocation-interface.so.4 )
( cd usr/lib ; ln -sf libplasma-geolocation-interface.so.4.10.5 libplasma-geolocation-interface.so.4 )
( cd usr/lib ; rm -rf liboxygenstyle.so )
( cd usr/lib ; ln -sf liboxygenstyle.so.4 liboxygenstyle.so )
( cd usr/lib ; rm -rf libprocesscore.so.4 )
( cd usr/lib ; ln -sf libprocesscore.so.4.10.5 libprocesscore.so.4 )
( cd usr/lib ; rm -rf libtaskmanager.so )
( cd usr/lib ; ln -sf libtaskmanager.so.4 libtaskmanager.so )
( cd usr/lib ; rm -rf libkworkspace.so )
( cd usr/lib ; ln -sf libkworkspace.so.4 libkworkspace.so )
( cd usr/lib ; rm -rf libpowerdevilconfigcommonprivate.so.4 )
( cd usr/lib ; ln -sf libpowerdevilconfigcommonprivate.so.4.10.5 libpowerdevilconfigcommonprivate.so.4 )
( cd usr/lib ; rm -rf liboxygenstyleconfig.so.4 )
( cd usr/lib ; ln -sf liboxygenstyleconfig.so.4.10.5 liboxygenstyleconfig.so.4 )
( cd usr/lib ; rm -rf libpowerdevilui.so.4 )
( cd usr/lib ; ln -sf libpowerdevilui.so.4.10.5 libpowerdevilui.so.4 )
( cd usr/lib ; rm -rf libplasma-geolocation-interface.so )
( cd usr/lib ; ln -sf libplasma-geolocation-interface.so.4 libplasma-geolocation-interface.so )
( cd usr/lib ; rm -rf libkwinglesutils.so )
( cd usr/lib ; ln -sf libkwinglesutils.so.1 libkwinglesutils.so )
( cd usr/lib ; rm -rf liboxygenstyleconfig.so )
( cd usr/lib ; ln -sf liboxygenstyleconfig.so.4 liboxygenstyleconfig.so )
( cd usr/lib ; rm -rf libpowerdevilcore.so.0 )
( cd usr/lib ; ln -sf libpowerdevilcore.so.0.1.0 libpowerdevilcore.so.0 )
( cd usr/lib ; rm -rf libprocessui.so.4 )
( cd usr/lib ; ln -sf libprocessui.so.4.10.5 libprocessui.so.4 )
( cd usr/lib ; rm -rf libpowerdevilui.so )
( cd usr/lib ; ln -sf libpowerdevilui.so.4 libpowerdevilui.so )
( cd usr/lib ; rm -rf libksgrd.so )
( cd usr/lib ; ln -sf libksgrd.so.4 libksgrd.so )
( cd usr/lib ; rm -rf libkfontinst.so.4 )
( cd usr/lib ; ln -sf libkfontinst.so.4.10.5 libkfontinst.so.4 )
( cd usr/lib ; rm -rf libkwinnvidiahack.so.4 )
( cd usr/lib ; ln -sf libkwinnvidiahack.so.4.10.5 libkwinnvidiahack.so.4 )
( cd usr/lib ; rm -rf libkephal.so )
( cd usr/lib ; ln -sf libkephal.so.4 libkephal.so )
( cd usr/lib ; rm -rf libweather_ion.so )
( cd usr/lib ; ln -sf libweather_ion.so.6 libweather_ion.so )
( cd usr/lib ; rm -rf libkhotkeysprivate.so.4 )
( cd usr/lib ; ln -sf libkhotkeysprivate.so.4.10.5 libkhotkeysprivate.so.4 )
( cd usr/lib ; rm -rf libsolidcontrolifaces.so.4 )
( cd usr/lib ; ln -sf libsolidcontrolifaces.so.4.10.5 libsolidcontrolifaces.so.4 )
( cd usr/lib ; rm -rf libkfontinstui.so.4 )
( cd usr/lib ; ln -sf libkfontinstui.so.4.10.5 libkfontinstui.so.4 )
( cd usr/lib ; rm -rf libkwineffects.so.1 )
( cd usr/lib ; ln -sf libkwineffects.so.1.0.0 libkwineffects.so.1 )
( cd usr/lib ; rm -rf libkwinglutils.so.1 )
( cd usr/lib ; ln -sf libkwinglutils.so.1.0.0 libkwinglutils.so.1 )
( cd usr/lib ; rm -rf libsolidcontrol.so.4 )
( cd usr/lib ; ln -sf libsolidcontrol.so.4.10.5 libsolidcontrol.so.4 )
( cd usr/lib ; rm -rf libpowerdevilcore.so )
( cd usr/lib ; ln -sf libpowerdevilcore.so.0 libpowerdevilcore.so )
( cd usr/lib ; rm -rf libkwinglutils.so )
( cd usr/lib ; ln -sf libkwinglutils.so.1 libkwinglutils.so )
( cd usr/lib ; rm -rf libplasmagenericshell.so.4 )
( cd usr/lib ; ln -sf libplasmagenericshell.so.4.10.5 libplasmagenericshell.so.4 )
( cd usr/share/config ; rm -rf kdm )
( cd usr/share/config ; ln -sf ../../../etc/kde/kdm kdm )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf alias )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf link alias )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf row-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf split_h row-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf watch )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf wait watch )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf pointing_hand e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf help d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf copy b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf help 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf v_double_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_ver v_double_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf link 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf move )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf closedhand move )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf question_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf help question_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf col-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf split_v col-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_ver 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf hand2 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf pointing_hand hand2 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf ibeam )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf xterm ibeam )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf whats_this )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf help whats_this )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf pointer )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf pointing_hand pointer )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf e-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_hor e-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf closedhand fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf s-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_ver s-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf link a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf hand1 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf pointing_hand hand1 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf dnd-none )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf closedhand dnd-none )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf half-busy 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf crossed_circle )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf circle crossed_circle )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf copy 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf pointing_hand 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf size_all )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf fleur size_all )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_hor sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf dnd-copy )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf copy dnd-copy )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf all-scroll )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf fleur all-scroll )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf left_ptr_watch )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf half-busy left_ptr_watch )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf link 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf progress )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf half-busy progress )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf w-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_hor w-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf text )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf xterm text )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf n-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_ver n-resize )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf copy 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf size_ver sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf half-busy 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf dnd-move )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf closedhand dnd-move )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf dnd-link )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf link dnd-link )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf dnd-no-drop )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf forbidden dnd-no-drop )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf not-allowed )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf forbidden not-allowed )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf circle 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf closedhand 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf half-busy 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Zion/cursors ; rm -rf 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Zion/cursors ; ln -sf closedhand 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf alias )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf link alias )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf row-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf split_h row-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf watch )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf wait watch )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf pointing_hand e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf help d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf copy b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf help 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf v_double_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_ver v_double_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf link 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf move )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf closedhand move )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf question_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf help question_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf col-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf split_v col-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_ver 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf hand2 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf pointing_hand hand2 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf ibeam )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf xterm ibeam )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf whats_this )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf help whats_this )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf pointer )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf pointing_hand pointer )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf e-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_hor e-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf closedhand fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf s-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_ver s-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf link a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf hand1 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf pointing_hand hand1 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf dnd-none )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf closedhand dnd-none )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf half-busy 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf crossed_circle )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf circle crossed_circle )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf copy 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf pointing_hand 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf size_all )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf fleur size_all )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_hor sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf dnd-copy )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf copy dnd-copy )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf all-scroll )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf fleur all-scroll )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf left_ptr_watch )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf half-busy left_ptr_watch )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf link 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf progress )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf half-busy progress )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf w-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_hor w-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf text )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf xterm text )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf n-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_ver n-resize )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf copy 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf size_ver sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf half-busy 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf dnd-move )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf closedhand dnd-move )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf dnd-link )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf link dnd-link )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf dnd-no-drop )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf forbidden dnd-no-drop )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf not-allowed )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf forbidden not-allowed )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf circle 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf closedhand 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf half-busy 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Black/cursors ; rm -rf 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Black/cursors ; ln -sf closedhand 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf alias )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf link alias )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf row-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf split_h row-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf watch )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf wait watch )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf pointing_hand e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf help d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf copy b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf help 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf v_double_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_ver v_double_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf link 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf move )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf closedhand move )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf question_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf help question_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf col-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf split_v col-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_ver 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf hand2 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf pointing_hand hand2 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf ibeam )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf xterm ibeam )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf whats_this )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf help whats_this )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf pointer )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf pointing_hand pointer )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf e-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_hor e-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf closedhand fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf s-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_ver s-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf link a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf hand1 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf pointing_hand hand1 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf dnd-none )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf closedhand dnd-none )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf half-busy 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf crossed_circle )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf circle crossed_circle )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf copy 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf pointing_hand 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf size_all )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf fleur size_all )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_hor sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf dnd-copy )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf copy dnd-copy )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf all-scroll )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf fleur all-scroll )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf left_ptr_watch )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf half-busy left_ptr_watch )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf link 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf progress )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf half-busy progress )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf w-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_hor w-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf text )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf xterm text )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf n-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_ver n-resize )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf copy 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf size_ver sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf half-busy 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf dnd-move )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf closedhand dnd-move )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf dnd-link )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf link dnd-link )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf dnd-no-drop )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf forbidden dnd-no-drop )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf not-allowed )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf forbidden not-allowed )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf circle 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf closedhand 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf half-busy 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Blue/cursors ; rm -rf 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Blue/cursors ; ln -sf closedhand 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf alias )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf link alias )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf row-resize )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf split_h row-resize )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf watch )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf wait watch )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf pointing_hand e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf help d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf copy b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf help 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf v_double_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_ver v_double_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf link 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf move )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf closedhand move )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf question_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf help question_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf col-resize )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf split_v col-resize )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_ver 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf hand2 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf pointing_hand hand2 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf ibeam )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf xterm ibeam )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf whats_this )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf help whats_this )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf pointer )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf pointing_hand pointer )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf e-resize )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_hor e-resize )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf closedhand fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf s-resize )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_ver s-resize )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf link a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf hand1 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf pointing_hand hand1 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf dnd-none )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf closedhand dnd-none )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf half-busy 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf crossed_circle )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf circle crossed_circle )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf copy 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf pointing_hand 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf size_all )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf fleur size_all )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf sb_h_double_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_hor sb_h_double_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf dnd-copy )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf copy dnd-copy )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf all-scroll )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf fleur all-scroll )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf left_ptr_watch )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf half-busy left_ptr_watch )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf link 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf progress )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf half-busy progress )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf w-resize )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_hor w-resize )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf text )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf xterm text )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf n-resize )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_ver n-resize )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf copy 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf sb_v_double_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf size_ver sb_v_double_arrow )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf half-busy 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf dnd-move )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf closedhand dnd-move )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf dnd-link )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf link dnd-link )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf dnd-no-drop )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf forbidden dnd-no-drop )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf not-allowed )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf forbidden not-allowed )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf circle 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf closedhand 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf half-busy 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_White/cursors ; rm -rf 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_White/cursors ; ln -sf closedhand 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf alias )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf link alias )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf row-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf split_h row-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf watch )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf wait watch )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf pointing_hand e29285e634086352946a0e7090d73106 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf help d9ce0ab605698f320427677b458ad60b )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf copy b66166c04f8c3109214a4fbd64a50fc8 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf help 5c6cd98b3f3ebcb1f9c7f1c204630408 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf v_double_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_ver v_double_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf link 3085a0e285430894940527032f8b26df )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf move )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf closedhand move )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf question_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf help question_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf col-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf split_v col-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_ver 00008160000006810000408080010102 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf hand2 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf pointing_hand hand2 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf ibeam )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf xterm ibeam )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf whats_this )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf help whats_this )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf pointer )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf pointing_hand pointer )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf e-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_hor e-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf closedhand fcf21c00b30f7e3f83fe0dfd12e71cff )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf s-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_ver s-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf link a2a266d0498c3104214a47bd64ab0fc8 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf hand1 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf pointing_hand hand1 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf dnd-none )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf closedhand dnd-none )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf half-busy 00000000000000020006000e7e9ffc3f )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf crossed_circle )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf circle crossed_circle )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf copy 1081e37283d90000800003c07f3ef6bf )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf pointing_hand 9d800788f1b08800ae810202380a0822 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf size_all )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf fleur size_all )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_hor sb_h_double_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf dnd-copy )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf copy dnd-copy )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf all-scroll )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf fleur all-scroll )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf left_ptr_watch )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf half-busy left_ptr_watch )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf link 640fb0e74195791501fd1ed57b41487f )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf progress )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf half-busy progress )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf w-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_hor w-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf text )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf xterm text )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf n-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_ver n-resize )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf copy 6407b0e94181790501fd1e167b474872 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf size_ver sb_v_double_arrow )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf half-busy 3ecb610c1bf2410f44200f48c40d3599 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf dnd-move )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf closedhand dnd-move )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf dnd-link )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf link dnd-link )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf dnd-no-drop )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf forbidden dnd-no-drop )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf not-allowed )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf forbidden not-allowed )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf circle 03b6e0fcb3499374a867c041f52298f0 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf closedhand 4498f0e0c1937ffe01fd06f973665830 )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf half-busy 08e8e1c95fe2fc01f976f1e063a24ccd )
( cd usr/share/icons/Oxygen_Yellow/cursors ; rm -rf 9081237383d90e509aa00f00170e968f )
( cd usr/share/icons/Oxygen_Yellow/cursors ; ln -sf closedhand 9081237383d90e509aa00f00170e968f )
( cd usr/doc/HTML/en/kmenuedit ; rm -rf common )
( cd usr/doc/HTML/en/kmenuedit ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kfontview ; rm -rf common )
( cd usr/doc/HTML/en/kfontview ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/plasma-desktop ; rm -rf common )
( cd usr/doc/HTML/en/plasma-desktop ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kdm ; rm -rf common )
( cd usr/doc/HTML/en/kdm ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/systemsettings ; rm -rf common )
( cd usr/doc/HTML/en/systemsettings ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kinfocenter ; rm -rf common )
( cd usr/doc/HTML/en/kinfocenter ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/klipper ; rm -rf common )
( cd usr/doc/HTML/en/klipper ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/khotkeys ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/khotkeys ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/workspaceoptions ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/workspaceoptions ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/desktop ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/desktop ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/desktopthemedetails ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/desktopthemedetails ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/splashscreen ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/splashscreen ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/autostart ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/autostart ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/mouse ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/mouse ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/windowbehaviour ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/windowbehaviour ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kwincompositing ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kwincompositing ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/joystick ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/joystick ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/fontinst ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/fontinst ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/solid-hardware ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/solid-hardware ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/fonts ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/fonts ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/colors ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/colors ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/powerdevil ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/powerdevil ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/solid-actions ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/solid-actions ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kwintabbox ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kwintabbox ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kcmaccess ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kcmaccess ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/windowspecific ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/windowspecific ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kcmsmserver ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kcmsmserver ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/screensaver ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/screensaver ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/bell ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/bell ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/keys ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/keys ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kwindecoration ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kwindecoration ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/clock ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/clock ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/paths ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/paths ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kcmstyle ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kcmstyle ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/kwinscreenedges ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/kwinscreenedges ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/keyboard ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/keyboard ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/kcontrol/cursortheme ; rm -rf common )
( cd usr/doc/HTML/en/kcontrol/cursortheme ; ln -sf /usr/share/doc/HTML/en/common common )
( cd usr/doc/HTML/en/ksysguard ; rm -rf common )
( cd usr/doc/HTML/en/ksysguard ; ln -sf /usr/share/doc/HTML/en/common common )
