/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class JToolBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = -1269915519555129643L;
    private transient boolean paintBorder = true;
    private transient Insets margin;
    private transient boolean floatable = true;
    private transient boolean rollover;
    private int orientation = 0;

    public JToolBar() {
        this(null, 0);
    }

    public JToolBar(int orientation) {
        this(null, orientation);
    }

    public JToolBar(String name) {
        this(name, 0);
    }

    public JToolBar(String name, int orientation) {
        this.setName(name);
        this.setOrientation(orientation);
        this.setLayout(new DefaultToolBarLayout());
        this.revalidate();
        this.setOpaque(true);
        this.updateUI();
    }

    public JButton add(Action action) {
        JButton b = this.createActionComponent(action);
        this.add(b);
        return b;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.paintBorder && this.isFloatable()) {
            super.paintBorder(graphics);
        }
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public void setUI(ToolBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ToolBarUI";
    }

    public void setRollover(boolean b) {
        if (b != this.rollover) {
            this.rollover = b;
            this.firePropertyChange("rollover", !this.rollover, this.rollover);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public int getComponentIndex(Component component) {
        Component[] components = this.getComponents();
        if (components == null) {
            return -1;
        }
        int i = 0;
        while (i < components.length) {
            if (components[i] == component) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Component getComponentAtIndex(int index) {
        return this.getComponent(index);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        if (this.margin != null && margin == null || this.margin == null && margin != null || margin != null && this.margin != null && (margin.left != this.margin.left || margin.right != this.margin.right || margin.top != this.margin.top || margin.bottom != this.margin.bottom)) {
            Insets oldMargin = this.margin;
            this.margin = margin;
            this.firePropertyChange("margin", oldMargin, this.margin);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean painted) {
        if (painted != this.paintBorder) {
            this.paintBorder = painted;
            this.firePropertyChange("borderPainted", !this.paintBorder, this.paintBorder);
            this.repaint();
        }
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public void setFloatable(boolean floatable) {
        if (floatable != this.floatable) {
            this.floatable = floatable;
            this.firePropertyChange("floatable", !floatable, floatable);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setLayout(LayoutManager mgr) {
        super.setLayout(mgr);
        this.revalidate();
        this.repaint();
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(String.valueOf(orientation) + " is not a legal orientation");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
            this.revalidate();
            this.repaint();
        }
    }

    public void addSeparator() {
        this.add(new Separator());
    }

    public void addSeparator(Dimension size) {
        this.add(new Separator(size));
    }

    protected JButton createActionComponent(Action action) {
        return new JButton(action);
    }

    protected PropertyChangeListener createActionChangeListener(JButton button) {
        return null;
    }

    protected void addImpl(Component component, Object constraints, int index) {
        super.addImpl(component, constraints, index);
        if (component instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)component;
            b.setRolloverEnabled(this.rollover);
        }
    }

    protected String paramString() {
        CPStringBuilder sb = new CPStringBuilder(super.paramString());
        sb.append(",floatable=").append(this.floatable);
        sb.append(",margin=");
        if (this.margin != null) {
            sb.append(this.margin);
        }
        sb.append(",orientation=");
        if (this.orientation == 0) {
            sb.append("HORIZONTAL");
        } else {
            sb.append(1);
        }
        sb.append(",paintBorder=").append(this.paintBorder);
        return sb.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = -5516888265903814215L;

        protected AccessibleJToolBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }
    }

    private class DefaultToolBarLayout
    implements LayoutManager {
        private DefaultToolBarLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container c) {
            if (!(c instanceof JToolBar)) {
                throw new Error("DefaultToolBarLayout can only be used on JToolBars.");
            }
            Insets insets = JToolBar.this.getInsets();
            Insets margin = JToolBar.this.getMargin();
            if (margin != null) {
                insets.left += margin.left;
                insets.top += margin.top;
                insets.bottom += margin.bottom;
                insets.right += margin.right;
            }
            Component[] components = c.getComponents();
            Dimension tdims = c.getSize();
            int start = 0;
            if (JToolBar.this.getOrientation() == 0) {
                start += insets.left;
                int i = 0;
                while (i < components.length) {
                    Dimension pref;
                    if (components[i] != null && components[i].isVisible() && (pref = components[i].getPreferredSize()) != null) {
                        int middle = (tdims.height - pref.height) / 2;
                        components[i].setBounds(start, middle, pref.width, pref.height);
                        start += pref.width;
                    }
                    ++i;
                }
            } else {
                start += insets.top;
                int i = 0;
                while (i < components.length) {
                    Dimension pref;
                    if (components[i] != null && components[i].isVisible() && (pref = components[i].getPreferredSize()) != null) {
                        int middle = (tdims.width - pref.width) / 2;
                        components[i].setBounds(middle, start, pref.width, pref.height);
                        start += pref.height;
                    }
                    ++i;
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            int i;
            int orientation = JToolBar.this.getOrientation();
            Component[] components = JToolBar.this.getComponents();
            int limit = 0;
            int total = 0;
            int w = 0;
            int h = 0;
            if (orientation == 0) {
                i = 0;
                while (i < components.length) {
                    Dimension dims = components[i].getPreferredSize();
                    if (dims != null) {
                        if (dims.height > limit) {
                            limit = dims.height;
                        }
                        total += dims.width;
                    }
                    ++i;
                }
                w = total;
                h = limit;
            } else {
                i = 0;
                while (i < components.length) {
                    Dimension dims = components[i].getPreferredSize();
                    if (dims != null) {
                        if (dims.width > limit) {
                            limit = dims.width;
                        }
                        total += dims.height;
                    }
                    ++i;
                }
                w = limit;
                h = total;
            }
            Insets insets = JToolBar.this.getInsets();
            w += insets.left + insets.right;
            h += insets.top + insets.bottom;
            Insets margin = JToolBar.this.getMargin();
            if (margin != null) {
                w += margin.left + margin.right;
                h += margin.top + margin.bottom;
            }
            return new Dimension(w, h);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class Separator
    extends JSeparator {
        private static final long serialVersionUID = -1656745644823105219L;

        public Separator() {
        }

        public Separator(Dimension size) {
            this.setPreferredSize(size);
        }

        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }

        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }

        public Dimension getSeparatorSize() {
            return super.getPreferredSize();
        }

        public void setSeparatorSize(Dimension size) {
            this.setPreferredSize(size);
        }
    }
}

