/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.VMConsole;

public final class Console
implements Flushable {
    private static Console console = new Console();

    public static Console console() {
        return console;
    }

    private Console() {
    }

    public PrintWriter writer() {
        return new PrintWriter(new OutputStreamWriter(System.out));
    }

    public Reader reader() {
        return new InputStreamReader(System.in);
    }

    public Console format(String fmt, Object ... args) {
        System.out.printf(fmt, args);
        return this;
    }

    public Console printf(String fmt, Object ... args) {
        return this.format(fmt, args);
    }

    public String readLine(String fmt, Object ... args) {
        this.format(fmt, args);
        return this.readLine();
    }

    public String readLine() {
        String result = null;
        try {
            result = new BufferedReader(this.reader()).readLine();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return result;
    }

    public char[] readPassword(String fmt, Object ... args) {
        this.format(fmt, args);
        return this.readPassword();
    }

    public char[] readPassword() {
        String s = VMConsole.readPassword(this);
        System.out.println();
        if (s == null) {
            return null;
        }
        return s.toCharArray();
    }

    public void flush() throws IOException {
        System.out.flush();
    }
}

