/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.Segment;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public class QuadSegment
extends Segment {
    public Point2D cp;

    public QuadSegment(double x1, double y1, double cx, double cy, double x2, double y2) {
        this.P1 = new Point2D.Double(x1, y1);
        this.P2 = new Point2D.Double(x2, y2);
        this.cp = new Point2D.Double(cx, cy);
    }

    public QuadSegment(Point2D p1, Point2D cp, Point2D p2) {
        this.P1 = p1;
        this.P2 = p2;
        this.cp = cp;
    }

    public QuadSegment(QuadCurve2D curve) {
        this.P1 = curve.getP1();
        this.P2 = curve.getP2();
        this.cp = curve.getCtrlPt();
    }

    public Object clone() {
        QuadSegment segment = null;
        try {
            segment = (QuadSegment)super.clone();
            segment.P1 = (Point2D)this.P1.clone();
            segment.P2 = (Point2D)this.P2.clone();
            segment.cp = (Point2D)this.cp.clone();
        }
        catch (CloneNotSupportedException cnse) {
            InternalError ie = new InternalError();
            ie.initCause(cnse);
            throw ie;
        }
        return segment;
    }

    public Segment[] getDisplacedSegments(double radius) {
        this.radius = radius;
        double x0 = this.P1.getX();
        double y0 = this.P1.getY();
        double x1 = this.cp.getX();
        double y1 = this.cp.getY();
        double x2 = this.P2.getX();
        double y2 = this.P2.getY();
        QuadCurve2D.Double left = new QuadCurve2D.Double();
        QuadCurve2D.Double right = new QuadCurve2D.Double();
        QuadCurve2D.Double orig = new QuadCurve2D.Double(x0, y0, x1, y1, x2, y2);
        orig.subdivide(left, right);
        QuadSegment s1 = this.offsetSubdivided(left, true);
        QuadSegment s2 = this.offsetSubdivided(left, false);
        s1.add(this.offsetSubdivided(right, true));
        s2.add(this.offsetSubdivided(right, false));
        return new Segment[]{s1, s2};
    }

    private QuadSegment offsetSubdivided(QuadCurve2D curve, boolean plus) {
        Point2D cp;
        double[] n1 = this.normal(curve.getX1(), curve.getY1(), curve.getCtrlX(), curve.getCtrlY());
        double[] n2 = this.normal(curve.getCtrlX(), curve.getCtrlY(), curve.getX2(), curve.getY2());
        if (!plus) {
            n1[0] = -n1[0];
            n1[1] = -n1[1];
            n2[0] = -n2[0];
            n2[1] = -n2[1];
        }
        if (curve.getP1().equals(curve.getCtrlPt())) {
            cp = curve.getCtrlPt();
            cp.setLocation(cp.getX() + n2[0], cp.getY() + n2[1]);
            n1[0] = n2[0];
            n1[1] = n2[1];
        } else if (curve.getP2().equals(curve.getCtrlPt())) {
            cp = curve.getCtrlPt();
            cp.setLocation(cp.getX() + n1[0], cp.getY() + n1[1]);
            n2[0] = n1[0];
            n2[1] = n1[1];
        } else if (curve.getP1().equals(curve.getP2())) {
            cp = curve.getCtrlPt();
            double deltaX = curve.getX1() - curve.getCtrlX();
            double deltaY = curve.getY1() - curve.getCtrlY();
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            double ratio = this.radius / length;
            deltaX *= ratio;
            deltaY *= ratio;
            if (plus) {
                cp.setLocation(cp.getX() + deltaX, cp.getY() + deltaY);
            } else {
                cp.setLocation(cp.getX() - deltaX, cp.getY() - deltaY);
            }
        } else if (n1[0] == n2[0] && n1[1] == n2[1]) {
            cp = curve.getCtrlPt();
            cp.setLocation(cp.getX() + n1[0], cp.getY() + n1[1]);
        } else {
            cp = this.lineIntersection(curve.getX1() + n1[0], curve.getY1() + n1[1], curve.getCtrlX() + n1[0], curve.getCtrlY() + n1[1], curve.getCtrlX() + n2[0], curve.getCtrlY() + n2[1], curve.getX2() + n2[0], curve.getY2() + n2[1], true);
        }
        QuadSegment s = new QuadSegment(curve.getX1() + n1[0], curve.getY1() + n1[1], cp.getX(), cp.getY(), curve.getX2() + n2[0], curve.getY2() + n2[1]);
        return s;
    }

    private Point2D lineIntersection(double X1, double Y1, double X2, double Y2, double X3, double Y3, double X4, double Y4, boolean infinite) {
        double x1 = X1;
        double y1 = Y1;
        double rx = X2 - x1;
        double ry = Y2 - y1;
        double x2 = X3;
        double y2 = Y3;
        double sx = X4 - x2;
        double sy = Y4 - y2;
        double determinant = sx * ry - sy * rx;
        double nom = sx * (y2 - y1) + sy * (x1 - x2);
        if (Math.abs(determinant) < 1.0E-6) {
            return null;
        }
        nom /= determinant;
        if (!infinite && (nom > 1.0 || nom < 0.0)) {
            return null;
        }
        return new Point2D.Double(x1 + nom * rx, y1 + nom * ry);
    }

    public void reverse() {
        Point2D p = this.P1;
        this.P1 = this.P2;
        this.P2 = p;
    }

    public double[] cp1() {
        return new double[]{this.cp.getX(), this.cp.getY()};
    }

    public double[] cp2() {
        return new double[]{this.cp.getX(), this.cp.getY()};
    }
}

