/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

class Messages {
    private static final Logger log = Logger.getLogger(Messages.class.getName());
    private static final String BUNDLE_NAME = "gnu.classpath.tools.jarsigner.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("gnu.classpath.tools.jarsigner.messages");
    private static final Map<String, MessageFormat> CACHED_FORMATS = new HashMap<String, MessageFormat>(5);

    private Messages() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return Messages.constructMessage(key, null);
        }
    }

    public static String getFormattedString(String key, Object args) {
        MessageFormat mf = CACHED_FORMATS.get(key);
        if (mf == null) {
            String formatString = Messages.getString(key);
            if (formatString.startsWith("!")) {
                return Messages.constructMessage(key, args);
            }
            mf = new MessageFormat(formatString);
            CACHED_FORMATS.put(key, mf);
        }
        try {
            if (args instanceof Object[]) {
                return mf.format(args);
            }
            return mf.format(new Object[]{args});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (Configuration.DEBUG) {
                log.fine("Exception while rendering a message format keyed by [" + key + "]: " + mf.toPattern());
            }
            return Messages.constructMessage(mf.toPattern(), args);
        }
    }

    private static final String constructMessage(String m, Object args) {
        if (args == null) {
            return String.valueOf('!') + m + '!';
        }
        return String.valueOf('!') + m + '!' + String.valueOf(args) + '!';
    }
}

