/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.java.security.hash.Sha160;
import gnu.java.util.Base64;
import gnu.java.util.jar.JarUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

class HashUtils {
    private static final Logger log = Logger.getLogger(HashUtils.class.getName());
    private Sha160 sha = new Sha160();

    HashUtils() {
    }

    String hashStream(InputStream stream) throws IOException {
        int n;
        BufferedInputStream bis = new BufferedInputStream(stream, 4096);
        byte[] buffer = new byte[4096];
        int count = 0;
        while ((n = bis.read(buffer)) != -1) {
            if (n <= 0) continue;
            this.sha.update(buffer, 0, n);
            count += n;
        }
        byte[] hash = this.sha.digest();
        if (Configuration.DEBUG) {
            log.finest("Hashed " + count + " byte(s)");
        }
        String result = Base64.encode((byte[])hash);
        return result;
    }

    String hashByteArray(byte[] ba) throws IOException {
        this.sha.update(ba);
        byte[] hash = this.sha.digest();
        if (Configuration.DEBUG) {
            log.finest("Hashed " + ba.length + " byte(s)");
        }
        String result = Base64.encode((byte[])hash);
        return result;
    }

    String hashManifestEntry(String name, String entryHash) throws UnsupportedEncodingException {
        this.sha.update(("Name: " + name).getBytes("UTF-8"));
        this.sha.update(JarUtils.CRLF);
        this.sha.update(("SHA1-Digest: " + entryHash).getBytes("UTF-8"));
        this.sha.update(JarUtils.CRLF);
        this.sha.update(JarUtils.CRLF);
        byte[] sfHash = this.sha.digest();
        String result = Base64.encode((byte[])sfHash);
        return result;
    }
}

