config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.serial.new:
if [ -e etc/rc.d/rc.serial ]; then
  cp -a etc/rc.d/rc.serial etc/rc.d/rc.serial.new.incoming
  cat etc/rc.d/rc.serial.new > etc/rc.d/rc.serial.new.incoming
  mv etc/rc.d/rc.serial.new.incoming etc/rc.d/rc.serial.new
fi

config etc/rc.d/rc.serial.new
config etc/serial.conf.new

( cd bin ; rm -rf ypdomainname )
( cd bin ; ln -sf hostname ypdomainname )
( cd bin ; rm -rf nisdomainname )
( cd bin ; ln -sf hostname nisdomainname )
( cd bin ; rm -rf domainname )
( cd bin ; ln -sf hostname domainname )
( cd bin ; rm -rf dnsdomainname )
( cd bin ; ln -sf hostname dnsdomainname )
( cd sbin ; rm -rf clock )
( cd sbin ; ln -sf hwclock clock )
( cd sbin ; rm -rf mount )
( cd sbin ; ln -sf ../bin/mount mount )
( cd sbin ; rm -rf umount )
( cd sbin ; ln -sf ../bin/umount umount )
( cd sbin ; rm -rf swapoff )
( cd sbin ; ln -sf swapon swapoff )
( cd lib ; rm -rf libblkid.so.1 )
( cd lib ; ln -sf libblkid.so.1.1.0 libblkid.so.1 )
( cd lib ; rm -rf libmount.so.1 )
( cd lib ; ln -sf libmount.so.1.1.0 libmount.so.1 )
( cd lib ; rm -rf libuuid.so.1 )
( cd lib ; ln -sf libuuid.so.1.3.0 libuuid.so.1 )
( cd usr/bin ; rm -rf getopt )
( cd usr/bin ; ln -sf ../../bin/getopt getopt )
( cd usr/bin ; rm -rf raw )
( cd usr/bin ; ln -sf ../../sbin/raw raw )
( cd usr/bin ; rm -rf linux32 )
( cd usr/bin ; ln -sf setarch linux32 )
( cd usr/bin ; rm -rf readprofile )
( cd usr/bin ; ln -sf ../sbin/readprofile readprofile )
( cd usr/bin ; rm -rf setterm )
( cd usr/bin ; ln -sf ../../bin/setterm setterm )
( cd usr/bin ; rm -rf tunelp )
( cd usr/bin ; ln -sf ../sbin/tunelp tunelp )
( cd usr/bin ; rm -rf more )
( cd usr/bin ; ln -sf ../../bin/more more )
( cd usr/bin ; rm -rf linux64 )
( cd usr/bin ; ln -sf setarch linux64 )
( cd usr/sbin ; rm -rf fdformat )
( cd usr/sbin ; ln -sf ../bin/fdformat fdformat )
( cd usr/sbin ; rm -rf sfdisk )
( cd usr/sbin ; ln -sf ../../sbin/sfdisk sfdisk )
( cd usr/sbin ; rm -rf cfdisk )
( cd usr/sbin ; ln -sf ../../sbin/cfdisk cfdisk )
( cd usr/sbin ; rm -rf ctrlaltdel )
( cd usr/sbin ; ln -sf ../../sbin/ctrlaltdel ctrlaltdel )
( cd usr/man/man8 ; rm -rf clock.8.gz )
( cd usr/man/man8 ; ln -sf hwclock.8.gz clock.8.gz )
( cd usr/lib ; rm -rf libblkid.so )
( cd usr/lib ; ln -sf ../../lib/libblkid.so.1 libblkid.so )
( cd usr/lib ; rm -rf libmount.so )
( cd usr/lib ; ln -sf ../../lib/libmount.so.1 libmount.so )
( cd usr/lib ; rm -rf libuuid.so )
( cd usr/lib ; ln -sf ../../lib/libuuid.so.1 libuuid.so )
