/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;

class MethodFinder {
    private static HashMap typeMapping = new HashMap();

    static {
        typeMapping.put(Byte.class, Byte.TYPE);
        typeMapping.put(Short.class, Short.TYPE);
        typeMapping.put(Integer.class, Integer.TYPE);
        typeMapping.put(Long.class, Long.TYPE);
        typeMapping.put(Float.class, Float.TYPE);
        typeMapping.put(Double.class, Double.TYPE);
        typeMapping.put(Character.class, Character.TYPE);
        typeMapping.put(Boolean.class, Boolean.TYPE);
    }

    private MethodFinder() {
    }

    static Method getMethod(Class klass, String name, Object[] arguments) throws NoSuchMethodException {
        Class[] argumentTypes = MethodFinder.getArgumentTypes(arguments);
        Method[] methods = klass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name) && MethodFinder.matchingArgumentTypes(methods[i].getParameterTypes(), argumentTypes)) {
                return methods[i];
            }
            ++i;
        }
        throw new NoSuchMethodException("Could not find a matching method named " + name + "() in class " + klass);
    }

    static Constructor getConstructor(Class klass, Object[] arguments) throws NoSuchMethodException {
        Class[] argumentTypes = MethodFinder.getArgumentTypes(arguments);
        Constructor<?>[] constructors = klass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (MethodFinder.matchingArgumentTypes(constructors[i].getParameterTypes(), argumentTypes)) {
                return constructors[i];
            }
            ++i;
        }
        throw new NoSuchMethodException("Could not find a matching constructor in class " + klass);
    }

    private static Class[] getArgumentTypes(Object[] arguments) {
        if (arguments == null) {
            return new Class[0];
        }
        Class[] argumentTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentTypes[i] = arguments[i] == null ? null : arguments[i].getClass();
            ++i;
        }
        return argumentTypes;
    }

    private static boolean matchingArgumentTypes(Class[] methodArgTypes, Class[] suppliedArgTypes) {
        if (methodArgTypes.length != suppliedArgTypes.length) {
            return false;
        }
        int i = 0;
        while (i < methodArgTypes.length) {
            if (suppliedArgTypes[i] != null) {
                if (typeMapping.containsKey(suppliedArgTypes[i])) {
                    Class primitiveType = (Class)typeMapping.get(suppliedArgTypes[i]);
                    if (!methodArgTypes[i].isAssignableFrom(suppliedArgTypes[i]) && !methodArgTypes[i].isAssignableFrom(primitiveType)) {
                        return false;
                    }
                } else if (!methodArgTypes[i].isAssignableFrom(suppliedArgTypes[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

