/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LabelPeer;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SwingLabelPeer
extends SwingComponentPeer
implements LabelPeer {
    public SwingLabelPeer(Label label) {
        SwingLabel swingLabel = new SwingLabel(label);
        swingLabel.setText(label.getText());
        swingLabel.setOpaque(true);
        this.init(label, swingLabel);
        this.setAlignment(label.getAlignment());
    }

    public void setText(String text) {
        ((JLabel)this.swingComponent.getJComponent()).setText(text);
    }

    public void setAlignment(int alignment) {
        JLabel swingLabel = (JLabel)this.swingComponent.getJComponent();
        switch (alignment) {
            case 2: {
                swingLabel.setHorizontalAlignment(4);
                break;
            }
            case 1: {
                swingLabel.setHorizontalAlignment(0);
                break;
            }
            default: {
                swingLabel.setHorizontalAlignment(2);
            }
        }
    }

    private class SwingLabel
    extends JLabel
    implements SwingComponent {
        Label label;

        SwingLabel(Label label) {
            this.label = label;
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent ev) {
            this.processMouseEvent(ev);
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            this.processMouseMotionEvent(ev);
        }

        public void handleKeyEvent(KeyEvent ev) {
            this.processKeyEvent(ev);
        }

        public void handleFocusEvent(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        public Point getLocationOnScreen() {
            return SwingLabelPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean retVal = false;
            if (this.label != null) {
                retVal = this.label.isShowing();
            }
            return retVal;
        }

        public Image createImage(int w, int h) {
            return SwingLabelPeer.this.createImage(w, h);
        }

        public Graphics getGraphics() {
            return SwingLabelPeer.this.getGraphics();
        }

        public Container getParent() {
            Container par = null;
            if (this.label != null) {
                par = this.label.getParent();
            }
            return par;
        }
    }
}

