/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.gcj.tools.gc_analyze.BytePtr;
import gnu.gcj.tools.gc_analyze.MemoryMap;
import java.io.BufferedReader;
import java.io.IOException;

class SymbolLookup {
    MemoryMap memoryMap;

    public SymbolLookup(BufferedReader reader, String rawFileName) throws IOException {
        this.memoryMap = new MemoryMap(reader, rawFileName);
    }

    public String decodeUTF8(long address) throws IOException {
        return this.decodeUTF8(address, -1);
    }

    public String decodeUTF8(long address, int limit) throws IOException {
        String rv;
        if (address == 0L) {
            return null;
        }
        BytePtr utf8 = this.memoryMap.getBytePtr(address, 64);
        if (utf8 == null) {
            return null;
        }
        int len = utf8.getShort(1);
        int hash16 = utf8.getShort(0) & 0xFFFF;
        if (len <= 0 || limit > 0 && len > limit - 4) {
            return null;
        }
        if (len > utf8.getsize() + 4) {
            utf8 = this.memoryMap.getBytePtr(address, len + 4);
        }
        if (utf8 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        int pos = 4;
        len += 4;
        while (pos < len) {
            int s;
            int f;
            if (((f = utf8.getByte(pos++)) & 0x80) == 0) {
                sb.append((char)f);
                continue;
            }
            if ((f & 0xE0) == 192) {
                s = utf8.getByte(pos++);
                char c = (char)((f & 0x1F) << 6 | s & 0x80);
                sb.append(c);
                continue;
            }
            if ((f & 0xE0) != 224) break;
            s = utf8.getByte(pos++);
            int t = utf8.getByte(pos++);
            char c = (char)((f & 0xF) << 12 | (s & 0x80) << 6 | t & 0x80);
            sb.append(c);
        }
        if (hash16 == ((rv = sb.toString()).hashCode() & 0xFFFF)) {
            return rv;
        }
        return null;
    }

    public String getSymbolViaVtable(long address) throws IOException {
        return this.memoryMap.getSymbol(address);
    }

    public String getSymbol(long address) throws IOException {
        String symbol = this.memoryMap.getSymbol(address);
        if (symbol != null) {
            return symbol;
        }
        BytePtr klass = this.memoryMap.getBytePtr(address, 3 * this.memoryMap.wordSize);
        if (klass == null) {
            return null;
        }
        long nameUTF8p = klass.getWord(2);
        return this.decodeUTF8(nameUTF8p);
    }

    BytePtr getBytePtr(long addr, int length) throws IOException {
        return this.memoryMap.getBytePtr(addr, length);
    }
}

