/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.gcj.tools.gc_analyze.ItemList;
import gnu.gcj.tools.gc_analyze.MemoryMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectMap
implements Iterable<Map.Entry<Long, ObjectItem>> {
    private TreeMap<Long, ObjectItem> map = new TreeMap();

    @Override
    public Iterator<Map.Entry<Long, ObjectItem>> iterator() {
        return this.map.entrySet().iterator();
    }

    public ObjectItem get(long ptr) {
        ObjectItem item = this.map.get(ptr);
        return item;
    }

    public ObjectMap(BufferedReader reader) throws IOException {
        ObjectItem item;
        String s;
        while ((s = reader.readLine()) != null) {
            if (s.indexOf("Begin object map") < 0) continue;
            while ((s = reader.readLine()).indexOf("End object map") < 0) {
                String[] items = s.split(",");
                item = new ObjectItem();
                long ptr = 0L;
                int i = 0;
                while (i < items.length) {
                    String[] x = items[i].split(" ");
                    String last = x[x.length - 1];
                    switch (i) {
                        case 0: {
                            item.used = Integer.parseInt(last);
                            break;
                        }
                        case 1: {
                            ptr = MemoryMap.parseHexLong(last.substring(2));
                            break;
                        }
                        case 2: {
                            item.size = Integer.parseInt(last);
                            break;
                        }
                        case 3: {
                            item.kind = Integer.parseInt(last);
                            break;
                        }
                        case 4: {
                            if (last.length() > 1) {
                                item.klass = MemoryMap.parseHexLong(last.substring(2));
                                break;
                            }
                            item.klass = Integer.parseInt(last, 16);
                            break;
                        }
                        case 5: {
                            try {
                                item.data = Integer.parseInt(last.substring(2), 16);
                                break;
                            }
                            catch (Exception exception) {
                                item.data = 0L;
                            }
                        }
                    }
                    ++i;
                }
                item.ptr = ptr;
                this.map.put(ptr, item);
            }
            break block10;
        }
        for (Map.Entry<Long, ObjectItem> me : this) {
            ObjectItem referenced;
            item = me.getValue();
            if (item.data == 0L || (referenced = this.map.get(item.data)) == null) continue;
            referenced.reference = item;
        }
    }

    public void dump() {
        for (Map.Entry<Long, ObjectItem> me : this) {
            long ptr = me.getKey();
            ObjectItem item = me.getValue();
            System.out.println("ptr = " + Long.toHexString(ptr) + ", size = " + item.size + ", klass = " + Long.toHexString(item.klass) + ", kind = " + item.kind + ", data = " + item.data);
        }
    }

    class ObjectItem {
        int used;
        int size;
        int kind;
        long klass;
        long data;
        long ptr;
        String typeName;
        String string;
        boolean stringData;
        ObjectItem reference;
        ItemList points_to = new ItemList();
        ItemList pointed_by = new ItemList();

        ObjectItem() {
        }
    }
}

