config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname ${NEW})/$(basename ${NEW} .new)"
  if [ -e ${OLD} ]; then
    cp -a ${OLD} ${NEW}.incoming
    cat ${NEW} > ${NEW}.incoming
    mv ${NEW}.incoming ${NEW}
  fi
  config ${NEW}
}

if [ -e etc/HOSTNAME ]; then
  sed -i "s,yourhostname,$(cat etc/HOSTNAME | cut -f1 -d .)," \
    etc/NetworkManager/NetworkManager.conf.new
fi

preserve_perms etc/rc.d/rc.networkmanager.new
config etc/NetworkManager/NetworkManager.conf.new

( cd usr/lib ; rm -rf libnm-util.so.2 )
( cd usr/lib ; ln -sf libnm-util.so.2.3.0 libnm-util.so.2 )
( cd usr/lib ; rm -rf libnm-glib.so.4 )
( cd usr/lib ; ln -sf libnm-glib.so.4.3.0 libnm-glib.so.4 )
( cd usr/lib ; rm -rf libnm-glib.so )
( cd usr/lib ; ln -sf libnm-glib.so.4.3.0 libnm-glib.so )
( cd usr/lib ; rm -rf libnm-glib-vpn.so )
( cd usr/lib ; ln -sf libnm-glib-vpn.so.1.1.0 libnm-glib-vpn.so )
( cd usr/lib ; rm -rf libnm-glib-vpn.so.1 )
( cd usr/lib ; ln -sf libnm-glib-vpn.so.1.1.0 libnm-glib-vpn.so.1 )
( cd usr/lib ; rm -rf libnm-util.so )
( cd usr/lib ; ln -sf libnm-util.so.2.3.0 libnm-util.so )
