/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NMM_H_
#define _SOPRANO_NMM_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk {
    namespace Vocabulary {
        namespace NMM {
            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#
             */
            NEPOMUK_EXPORT QUrl nmmNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#Movie 
             * 
             * A Movie 
             */
            NEPOMUK_EXPORT QUrl Movie();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicAlbum 
             * 
             * The music album as provided by the publisher. Not to be confused 
             * with media lists or collections. 
             */
            NEPOMUK_EXPORT QUrl MusicAlbum();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicPiece 
             * 
             * Used to assign music-specific properties such a BPM to video 
             * and audio 
             */
            NEPOMUK_EXPORT QUrl MusicPiece();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVSeries 
             * 
             * A TV Series has multiple seasons and episodes 
             */
            NEPOMUK_EXPORT QUrl TVSeries();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVShow 
             * 
             * A TV Show 
             */
            NEPOMUK_EXPORT QUrl TVShow();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#actor 
             * 
             * Actor 
             */
            NEPOMUK_EXPORT QUrl actor();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#albumGain 
             * 
             * ReplayGain album(audiophile) gain 
             */
            NEPOMUK_EXPORT QUrl albumGain();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#albumPeakGain 
             * 
             * ReplayGain album(audiophile) peak gain 
             */
            NEPOMUK_EXPORT QUrl albumPeakGain();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#albumTrackCount 
             * 
             * The number of tracks in a music album. 
             */
            NEPOMUK_EXPORT QUrl albumTrackCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#artwork 
             * 
             * Associated Artwork 
             */
            NEPOMUK_EXPORT QUrl artwork();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#assistantDirector 
             */
            NEPOMUK_EXPORT QUrl assistantDirector();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#audienceRating 
             * 
             * Rating used to identify appropriate audience for video (MPAA 
             * rating, BBFC, FSK, TV content rating, etc.) 
             */
            NEPOMUK_EXPORT QUrl audienceRating();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#beatsPerMinute 
             * 
             * beats per minute 
             */
            NEPOMUK_EXPORT QUrl beatsPerMinute();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#cinematographer 
             */
            NEPOMUK_EXPORT QUrl cinematographer();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#composer 
             * 
             * Composer 
             */
            NEPOMUK_EXPORT QUrl composer();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#director 
             * 
             * Director 
             */
            NEPOMUK_EXPORT QUrl director();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#episodeNumber 
             */
            NEPOMUK_EXPORT QUrl episodeNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#genre 
             * 
             * Genre 
             */
            NEPOMUK_EXPORT QUrl genre();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#hasEpisode 
             * 
             * A TVSeries has many episodes 
             */
            NEPOMUK_EXPORT QUrl hasEpisode();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#internationalStandardRecordingCode 
             * 
             * ISRC ID. Format: 'CC-XXX-YY-NNNNN' 
             */
            NEPOMUK_EXPORT QUrl internationalStandardRecordingCode();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#lyricist 
             * 
             * Lyricist 
             */
            NEPOMUK_EXPORT QUrl lyricist();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#musicAlbum 
             * 
             * Album the music belongs to 
             */
            NEPOMUK_EXPORT QUrl musicAlbum();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#musicBrainzAlbumID 
             * 
             * MusicBrainz album ID 
             */
            NEPOMUK_EXPORT QUrl musicBrainzAlbumID();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#musicBrainzTrackID 
             * 
             * MusicBrainz track ID 
             */
            NEPOMUK_EXPORT QUrl musicBrainzTrackID();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#musicCDIdentifier 
             * 
             * Music CD identifier to for databases like FreeDB.org. This 
             * property is intended for music that comes from a CD, so that the 
             * CD can be identified in external databases. 
             */
            NEPOMUK_EXPORT QUrl musicCDIdentifier();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#performer 
             * 
             * Performer 
             */
            NEPOMUK_EXPORT QUrl performer();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#producer 
             * 
             * Producer 
             */
            NEPOMUK_EXPORT QUrl producer();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#releaseDate 
             * 
             * The date the media was released. 
             */
            NEPOMUK_EXPORT QUrl releaseDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#season 
             */
            NEPOMUK_EXPORT QUrl season();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#series 
             * 
             * series 
             */
            NEPOMUK_EXPORT QUrl series();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#setNumber 
             * 
             * The part of a set the audio came from. 
             */
            NEPOMUK_EXPORT QUrl setNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#setSize 
             * 
             * The number of parts in the set. 
             */
            NEPOMUK_EXPORT QUrl setSize();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#synopsis 
             * 
             * Long form description of video content (plot, premise, etc.) 
             */
            NEPOMUK_EXPORT QUrl synopsis();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#trackGain 
             * 
             * ReplayGain track gain 
             */
            NEPOMUK_EXPORT QUrl trackGain();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#trackNumber 
             * 
             * Track number of the music in its album 
             */
            NEPOMUK_EXPORT QUrl trackNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#trackPeakGain 
             * 
             * ReplayGain track peak gain 
             */
            NEPOMUK_EXPORT QUrl trackPeakGain();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#writer 
             * 
             * Writer 
             */
            NEPOMUK_EXPORT QUrl writer();

            /**
             * http://www.semanticdesktop.org/ontologies/2009/02/19/nmm/metadata 
             */
            NEPOMUK_EXPORT QUrl metadata();
        }
    }
}

#endif
