// This file is generated by TableGen. Do not edit.

#ifndef LLVM_CLANG_ATTR_CLASSES_INC
#define LLVM_CLANG_ATTR_CLASSES_INC

class AcquiredAfterAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  AcquiredAfterAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::AcquiredAfter, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual AcquiredAfterAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AcquiredAfter; }
  static bool classof(const AcquiredAfterAttr *) { return true; }
};

class AcquiredBeforeAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  AcquiredBeforeAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::AcquiredBefore, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual AcquiredBeforeAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AcquiredBefore; }
  static bool classof(const AcquiredBeforeAttr *) { return true; }
};

class AliasAttr : public InheritableAttr {
unsigned aliaseeLength;
char *aliasee;


 public:
  AliasAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Aliasee
             )
    : InheritableAttr(attr::Alias, R)
              , aliaseeLength(Aliasee.size()),aliasee(new (Ctx, 1) char[aliaseeLength])
  {
      std::memcpy(aliasee, Aliasee.data(), aliaseeLength);
  }

  virtual AliasAttr *clone (ASTContext &C) const;
  llvm::StringRef getAliasee() const {
    return llvm::StringRef(aliasee, aliaseeLength);
  }
  unsigned getAliaseeLength() const {
    return aliaseeLength;
  }
  void setAliasee(ASTContext &C, llvm::StringRef S) {
    aliaseeLength = S.size();
    this->aliasee = new (C, 1) char [aliaseeLength];
    std::memcpy(this->aliasee, S.data(), aliaseeLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Alias; }
  static bool classof(const AliasAttr *) { return true; }
};

class AlignMac68kAttr : public InheritableAttr {

 public:
  AlignMac68kAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::AlignMac68k, R)
  {
  }

  virtual AlignMac68kAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlignMac68k; }
  static bool classof(const AlignMac68kAttr *) { return true; }
};

class AlignedAttr : public InheritableAttr {
bool isalignmentExpr;
union {
Expr *alignmentExpr;
TypeSourceInfo *alignmentType;
};


 public:
  AlignedAttr(SourceRange R, ASTContext &Ctx
              , bool IsAlignmentExpr, void *Alignment
             )
    : InheritableAttr(attr::Aligned, R)
              , isalignmentExpr(IsAlignmentExpr)
  {
    if (isalignmentExpr)
       alignmentExpr = reinterpret_cast<Expr *>(Alignment);
    else
       alignmentType = reinterpret_cast<TypeSourceInfo *>(Alignment);
  }

  virtual AlignedAttr *clone (ASTContext &C) const;
  bool isAlignmentDependent() const;
  unsigned getAlignment(ASTContext &Ctx) const;
  bool isAlignmentExpr() const {
    return isalignmentExpr;
  }
  Expr *getAlignmentExpr() const {
    assert(isalignmentExpr);
    return alignmentExpr;
  }
  TypeSourceInfo *getAlignmentType() const {
    assert(!isalignmentExpr);
    return alignmentType;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Aligned; }
  static bool classof(const AlignedAttr *) { return true; }
};

class AlwaysInlineAttr : public InheritableAttr {

 public:
  AlwaysInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::AlwaysInline, R)
  {
  }

  virtual AlwaysInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlwaysInline; }
  static bool classof(const AlwaysInlineAttr *) { return true; }
};

class AnalyzerNoReturnAttr : public InheritableAttr {

 public:
  AnalyzerNoReturnAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::AnalyzerNoReturn, R)
  {
  }

  virtual AnalyzerNoReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AnalyzerNoReturn; }
  static bool classof(const AnalyzerNoReturnAttr *) { return true; }
};

class AnnotateAttr : public InheritableParamAttr {
unsigned annotationLength;
char *annotation;


 public:
  AnnotateAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Annotation
             )
    : InheritableParamAttr(attr::Annotate, R)
              , annotationLength(Annotation.size()),annotation(new (Ctx, 1) char[annotationLength])
  {
      std::memcpy(annotation, Annotation.data(), annotationLength);
  }

  virtual AnnotateAttr *clone (ASTContext &C) const;
  llvm::StringRef getAnnotation() const {
    return llvm::StringRef(annotation, annotationLength);
  }
  unsigned getAnnotationLength() const {
    return annotationLength;
  }
  void setAnnotation(ASTContext &C, llvm::StringRef S) {
    annotationLength = S.size();
    this->annotation = new (C, 1) char [annotationLength];
    std::memcpy(this->annotation, S.data(), annotationLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Annotate; }
  static bool classof(const AnnotateAttr *) { return true; }
};

class ArcWeakrefUnavailableAttr : public InheritableAttr {

 public:
  ArcWeakrefUnavailableAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ArcWeakrefUnavailable, R)
  {
  }

  virtual ArcWeakrefUnavailableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ArcWeakrefUnavailable; }
  static bool classof(const ArcWeakrefUnavailableAttr *) { return true; }
};

class AsmLabelAttr : public InheritableAttr {
unsigned labelLength;
char *label;


 public:
  AsmLabelAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Label
             )
    : InheritableAttr(attr::AsmLabel, R)
              , labelLength(Label.size()),label(new (Ctx, 1) char[labelLength])
  {
      std::memcpy(label, Label.data(), labelLength);
  }

  virtual AsmLabelAttr *clone (ASTContext &C) const;
  llvm::StringRef getLabel() const {
    return llvm::StringRef(label, labelLength);
  }
  unsigned getLabelLength() const {
    return labelLength;
  }
  void setLabel(ASTContext &C, llvm::StringRef S) {
    labelLength = S.size();
    this->label = new (C, 1) char [labelLength];
    std::memcpy(this->label, S.data(), labelLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AsmLabel; }
  static bool classof(const AsmLabelAttr *) { return true; }
};

class AvailabilityAttr : public InheritableAttr {
IdentifierInfo * platform;

VersionTuple introduced;


VersionTuple deprecated;


VersionTuple obsoleted;


bool unavailable;


 public:
  AvailabilityAttr(SourceRange R, ASTContext &Ctx
              , IdentifierInfo * Platform
              , VersionTuple Introduced
              , VersionTuple Deprecated
              , VersionTuple Obsoleted
              , bool Unavailable
             )
    : InheritableAttr(attr::Availability, R)
              , platform(Platform)
              , introduced(Introduced)
              , deprecated(Deprecated)
              , obsoleted(Obsoleted)
              , unavailable(Unavailable)
  {





  }

  virtual AvailabilityAttr *clone (ASTContext &C) const;
  IdentifierInfo * getPlatform() const {
    return platform;
  }

  VersionTuple getIntroduced() const {
    return introduced;
  }
  void setIntroduced(ASTContext &C, VersionTuple V) {
    introduced = V;
  }

  VersionTuple getDeprecated() const {
    return deprecated;
  }
  void setDeprecated(ASTContext &C, VersionTuple V) {
    deprecated = V;
  }

  VersionTuple getObsoleted() const {
    return obsoleted;
  }
  void setObsoleted(ASTContext &C, VersionTuple V) {
    obsoleted = V;
  }

  bool getUnavailable() const {
    return unavailable;
  }

static llvm::StringRef getPrettyPlatformName(llvm::StringRef Platform) {
    return llvm::StringSwitch<llvm::StringRef>(Platform)
             .Case("ios", "iOS")
             .Case("macosx", "Mac OS X")
             .Default(llvm::StringRef());
} 

  static bool classof(const Attr *A) { return A->getKind() == attr::Availability; }
  static bool classof(const AvailabilityAttr *) { return true; }
};

class BlocksAttr : public InheritableAttr {
public:
  enum BlockType {
    ByRef
  };
private:
  BlockType type;


 public:
  BlocksAttr(SourceRange R, ASTContext &Ctx
              , BlockType Type
             )
    : InheritableAttr(attr::Blocks, R)
              , type(Type)
  {

  }

  virtual BlocksAttr *clone (ASTContext &C) const;
  BlockType getType() const {
    return type;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Blocks; }
  static bool classof(const BlocksAttr *) { return true; }
};

class CDeclAttr : public InheritableAttr {

 public:
  CDeclAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CDecl, R)
  {
  }

  virtual CDeclAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CDecl; }
  static bool classof(const CDeclAttr *) { return true; }
};

class CFAuditedTransferAttr : public InheritableAttr {

 public:
  CFAuditedTransferAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFAuditedTransfer, R)
  {
  }

  virtual CFAuditedTransferAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFAuditedTransfer; }
  static bool classof(const CFAuditedTransferAttr *) { return true; }
};

class CFConsumedAttr : public InheritableParamAttr {

 public:
  CFConsumedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::CFConsumed, R)
  {
  }

  virtual CFConsumedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFConsumed; }
  static bool classof(const CFConsumedAttr *) { return true; }
};

class CFReturnsNotRetainedAttr : public InheritableAttr {

 public:
  CFReturnsNotRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFReturnsNotRetained, R)
  {
  }

  virtual CFReturnsNotRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsNotRetained; }
  static bool classof(const CFReturnsNotRetainedAttr *) { return true; }
};

class CFReturnsRetainedAttr : public InheritableAttr {

 public:
  CFReturnsRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFReturnsRetained, R)
  {
  }

  virtual CFReturnsRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsRetained; }
  static bool classof(const CFReturnsRetainedAttr *) { return true; }
};

class CFUnknownTransferAttr : public InheritableAttr {

 public:
  CFUnknownTransferAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFUnknownTransfer, R)
  {
  }

  virtual CFUnknownTransferAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFUnknownTransfer; }
  static bool classof(const CFUnknownTransferAttr *) { return true; }
};

class CUDAConstantAttr : public InheritableAttr {

 public:
  CUDAConstantAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAConstant, R)
  {
  }

  virtual CUDAConstantAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAConstant; }
  static bool classof(const CUDAConstantAttr *) { return true; }
};

class CUDADeviceAttr : public Attr {

 public:
  CUDADeviceAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::CUDADevice, R)
  {
  }

  virtual CUDADeviceAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDADevice; }
  static bool classof(const CUDADeviceAttr *) { return true; }
};

class CUDAGlobalAttr : public InheritableAttr {

 public:
  CUDAGlobalAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAGlobal, R)
  {
  }

  virtual CUDAGlobalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAGlobal; }
  static bool classof(const CUDAGlobalAttr *) { return true; }
};

class CUDAHostAttr : public Attr {

 public:
  CUDAHostAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::CUDAHost, R)
  {
  }

  virtual CUDAHostAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAHost; }
  static bool classof(const CUDAHostAttr *) { return true; }
};

class CUDALaunchBoundsAttr : public InheritableAttr {
int maxThreads;

int minBlocks;


 public:
  CUDALaunchBoundsAttr(SourceRange R, ASTContext &Ctx
              , int MaxThreads
              , int MinBlocks
             )
    : InheritableAttr(attr::CUDALaunchBounds, R)
              , maxThreads(MaxThreads)
              , minBlocks(MinBlocks)
  {


  }

  virtual CUDALaunchBoundsAttr *clone (ASTContext &C) const;
  int getMaxThreads() const {
    return maxThreads;
  }

  int getMinBlocks() const {
    return minBlocks;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::CUDALaunchBounds; }
  static bool classof(const CUDALaunchBoundsAttr *) { return true; }
};

class CUDASharedAttr : public InheritableAttr {

 public:
  CUDASharedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAShared, R)
  {
  }

  virtual CUDASharedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAShared; }
  static bool classof(const CUDASharedAttr *) { return true; }
};

class CarriesDependencyAttr : public InheritableParamAttr {

 public:
  CarriesDependencyAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::CarriesDependency, R)
  {
  }

  virtual CarriesDependencyAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CarriesDependency; }
  static bool classof(const CarriesDependencyAttr *) { return true; }
};

class CleanupAttr : public InheritableAttr {
FunctionDecl * functionDecl;


 public:
  CleanupAttr(SourceRange R, ASTContext &Ctx
              , FunctionDecl * FunctionDecl
             )
    : InheritableAttr(attr::Cleanup, R)
              , functionDecl(FunctionDecl)
  {

  }

  virtual CleanupAttr *clone (ASTContext &C) const;
  FunctionDecl * getFunctionDecl() const {
    return functionDecl;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Cleanup; }
  static bool classof(const CleanupAttr *) { return true; }
};

class CommonAttr : public InheritableAttr {

 public:
  CommonAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Common, R)
  {
  }

  virtual CommonAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Common; }
  static bool classof(const CommonAttr *) { return true; }
};

class ConstAttr : public InheritableAttr {

 public:
  ConstAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Const, R)
  {
  }

  virtual ConstAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Const; }
  static bool classof(const ConstAttr *) { return true; }
};

class ConstructorAttr : public InheritableAttr {
int priority;


 public:
  ConstructorAttr(SourceRange R, ASTContext &Ctx
              , int Priority
             )
    : InheritableAttr(attr::Constructor, R)
              , priority(Priority)
  {

  }

  virtual ConstructorAttr *clone (ASTContext &C) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Constructor; }
  static bool classof(const ConstructorAttr *) { return true; }
};

class DLLExportAttr : public InheritableAttr {

 public:
  DLLExportAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::DLLExport, R)
  {
  }

  virtual DLLExportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLExport; }
  static bool classof(const DLLExportAttr *) { return true; }
};

class DLLImportAttr : public InheritableAttr {

 public:
  DLLImportAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::DLLImport, R)
  {
  }

  virtual DLLImportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLImport; }
  static bool classof(const DLLImportAttr *) { return true; }
};

class DeprecatedAttr : public InheritableAttr {
unsigned messageLength;
char *message;


 public:
  DeprecatedAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Deprecated, R)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {
      std::memcpy(message, Message.data(), messageLength);
  }

  virtual DeprecatedAttr *clone (ASTContext &C) const;
  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Deprecated; }
  static bool classof(const DeprecatedAttr *) { return true; }
};

class DestructorAttr : public InheritableAttr {
int priority;


 public:
  DestructorAttr(SourceRange R, ASTContext &Ctx
              , int Priority
             )
    : InheritableAttr(attr::Destructor, R)
              , priority(Priority)
  {

  }

  virtual DestructorAttr *clone (ASTContext &C) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Destructor; }
  static bool classof(const DestructorAttr *) { return true; }
};

class ExclusiveLockFunctionAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  ExclusiveLockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::ExclusiveLockFunction, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual ExclusiveLockFunctionAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ExclusiveLockFunction; }
  static bool classof(const ExclusiveLockFunctionAttr *) { return true; }
};

class ExclusiveLocksRequiredAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  ExclusiveLocksRequiredAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::ExclusiveLocksRequired, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual ExclusiveLocksRequiredAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ExclusiveLocksRequired; }
  static bool classof(const ExclusiveLocksRequiredAttr *) { return true; }
};

class ExclusiveTrylockFunctionAttr : public InheritableAttr {
Expr * successValue;

  unsigned argsSize;
  Expr * *args;


 public:
  ExclusiveTrylockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * SuccessValue
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::ExclusiveTrylockFunction, R)
              , successValue(SuccessValue)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {

    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual ExclusiveTrylockFunctionAttr *clone (ASTContext &C) const;
  Expr * getSuccessValue() const {
    return successValue;
  }

  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ExclusiveTrylockFunction; }
  static bool classof(const ExclusiveTrylockFunctionAttr *) { return true; }
};

class FastCallAttr : public InheritableAttr {

 public:
  FastCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::FastCall, R)
  {
  }

  virtual FastCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::FastCall; }
  static bool classof(const FastCallAttr *) { return true; }
};

class FinalAttr : public InheritableAttr {

 public:
  FinalAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Final, R)
  {
  }

  virtual FinalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Final; }
  static bool classof(const FinalAttr *) { return true; }
};

class FormatAttr : public InheritableAttr {
unsigned typeLength;
char *type;

int formatIdx;

int firstArg;


 public:
  FormatAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Type
              , int FormatIdx
              , int FirstArg
             )
    : InheritableAttr(attr::Format, R)
              , typeLength(Type.size()),type(new (Ctx, 1) char[typeLength])
              , formatIdx(FormatIdx)
              , firstArg(FirstArg)
  {
      std::memcpy(type, Type.data(), typeLength);


  }

  virtual FormatAttr *clone (ASTContext &C) const;
  llvm::StringRef getType() const {
    return llvm::StringRef(type, typeLength);
  }
  unsigned getTypeLength() const {
    return typeLength;
  }
  void setType(ASTContext &C, llvm::StringRef S) {
    typeLength = S.size();
    this->type = new (C, 1) char [typeLength];
    std::memcpy(this->type, S.data(), typeLength);
  }

  int getFormatIdx() const {
    return formatIdx;
  }

  int getFirstArg() const {
    return firstArg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Format; }
  static bool classof(const FormatAttr *) { return true; }
};

class FormatArgAttr : public InheritableAttr {
int formatIdx;


 public:
  FormatArgAttr(SourceRange R, ASTContext &Ctx
              , int FormatIdx
             )
    : InheritableAttr(attr::FormatArg, R)
              , formatIdx(FormatIdx)
  {

  }

  virtual FormatArgAttr *clone (ASTContext &C) const;
  int getFormatIdx() const {
    return formatIdx;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::FormatArg; }
  static bool classof(const FormatArgAttr *) { return true; }
};

class GNUInlineAttr : public InheritableAttr {

 public:
  GNUInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::GNUInline, R)
  {
  }

  virtual GNUInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::GNUInline; }
  static bool classof(const GNUInlineAttr *) { return true; }
};

class GuardedByAttr : public InheritableAttr {
Expr * arg;


 public:
  GuardedByAttr(SourceRange R, ASTContext &Ctx
              , Expr * Arg
             )
    : InheritableAttr(attr::GuardedBy, R)
              , arg(Arg)
  {

  }

  virtual GuardedByAttr *clone (ASTContext &C) const;
  Expr * getArg() const {
    return arg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::GuardedBy; }
  static bool classof(const GuardedByAttr *) { return true; }
};

class GuardedVarAttr : public InheritableAttr {

 public:
  GuardedVarAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::GuardedVar, R)
  {
  }

  virtual GuardedVarAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::GuardedVar; }
  static bool classof(const GuardedVarAttr *) { return true; }
};

class IBActionAttr : public InheritableAttr {

 public:
  IBActionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::IBAction, R)
  {
  }

  virtual IBActionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBAction; }
  static bool classof(const IBActionAttr *) { return true; }
};

class IBOutletAttr : public InheritableAttr {

 public:
  IBOutletAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::IBOutlet, R)
  {
  }

  virtual IBOutletAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutlet; }
  static bool classof(const IBOutletAttr *) { return true; }
};

class IBOutletCollectionAttr : public InheritableAttr {
QualType interface;

SourceLocation interfaceLoc;


 public:
  IBOutletCollectionAttr(SourceRange R, ASTContext &Ctx
              , QualType Interface
              , SourceLocation InterfaceLoc
             )
    : InheritableAttr(attr::IBOutletCollection, R)
              , interface(Interface)
              , interfaceLoc(InterfaceLoc)
  {


  }

  virtual IBOutletCollectionAttr *clone (ASTContext &C) const;
  QualType getInterface() const {
    return interface;
  }

  SourceLocation getInterfaceLoc() const {
    return interfaceLoc;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutletCollection; }
  static bool classof(const IBOutletCollectionAttr *) { return true; }
};

class InitPriorityAttr : public InheritableAttr {
unsigned priority;


 public:
  InitPriorityAttr(SourceRange R, ASTContext &Ctx
              , unsigned Priority
             )
    : InheritableAttr(attr::InitPriority, R)
              , priority(Priority)
  {

  }

  virtual InitPriorityAttr *clone (ASTContext &C) const;
  unsigned getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::InitPriority; }
  static bool classof(const InitPriorityAttr *) { return true; }
};

class LockReturnedAttr : public InheritableAttr {
Expr * arg;


 public:
  LockReturnedAttr(SourceRange R, ASTContext &Ctx
              , Expr * Arg
             )
    : InheritableAttr(attr::LockReturned, R)
              , arg(Arg)
  {

  }

  virtual LockReturnedAttr *clone (ASTContext &C) const;
  Expr * getArg() const {
    return arg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::LockReturned; }
  static bool classof(const LockReturnedAttr *) { return true; }
};

class LockableAttr : public InheritableAttr {

 public:
  LockableAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Lockable, R)
  {
  }

  virtual LockableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Lockable; }
  static bool classof(const LockableAttr *) { return true; }
};

class LocksExcludedAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  LocksExcludedAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::LocksExcluded, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual LocksExcludedAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::LocksExcluded; }
  static bool classof(const LocksExcludedAttr *) { return true; }
};

class MBlazeInterruptHandlerAttr : public InheritableAttr {

 public:
  MBlazeInterruptHandlerAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MBlazeInterruptHandler, R)
  {
  }

  virtual MBlazeInterruptHandlerAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MBlazeInterruptHandler; }
  static bool classof(const MBlazeInterruptHandlerAttr *) { return true; }
};

class MBlazeSaveVolatilesAttr : public InheritableAttr {

 public:
  MBlazeSaveVolatilesAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MBlazeSaveVolatiles, R)
  {
  }

  virtual MBlazeSaveVolatilesAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MBlazeSaveVolatiles; }
  static bool classof(const MBlazeSaveVolatilesAttr *) { return true; }
};

class MSP430InterruptAttr : public InheritableAttr {
unsigned number;


 public:
  MSP430InterruptAttr(SourceRange R, ASTContext &Ctx
              , unsigned Number
             )
    : InheritableAttr(attr::MSP430Interrupt, R)
              , number(Number)
  {

  }

  virtual MSP430InterruptAttr *clone (ASTContext &C) const;
  unsigned getNumber() const {
    return number;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MSP430Interrupt; }
  static bool classof(const MSP430InterruptAttr *) { return true; }
};

class MallocAttr : public InheritableAttr {

 public:
  MallocAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Malloc, R)
  {
  }

  virtual MallocAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Malloc; }
  static bool classof(const MallocAttr *) { return true; }
};

class MaxFieldAlignmentAttr : public InheritableAttr {
unsigned alignment;


 public:
  MaxFieldAlignmentAttr(SourceRange R, ASTContext &Ctx
              , unsigned Alignment
             )
    : InheritableAttr(attr::MaxFieldAlignment, R)
              , alignment(Alignment)
  {

  }

  virtual MaxFieldAlignmentAttr *clone (ASTContext &C) const;
  unsigned getAlignment() const {
    return alignment;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MaxFieldAlignment; }
  static bool classof(const MaxFieldAlignmentAttr *) { return true; }
};

class MayAliasAttr : public InheritableAttr {

 public:
  MayAliasAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MayAlias, R)
  {
  }

  virtual MayAliasAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MayAlias; }
  static bool classof(const MayAliasAttr *) { return true; }
};

class MsStructAttr : public InheritableAttr {

 public:
  MsStructAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MsStruct, R)
  {
  }

  virtual MsStructAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MsStruct; }
  static bool classof(const MsStructAttr *) { return true; }
};

class NSBridgedAttr : public InheritableAttr {
IdentifierInfo * bridgedType;


 public:
  NSBridgedAttr(SourceRange R, ASTContext &Ctx
              , IdentifierInfo * BridgedType
             )
    : InheritableAttr(attr::NSBridged, R)
              , bridgedType(BridgedType)
  {

  }

  virtual NSBridgedAttr *clone (ASTContext &C) const;
  IdentifierInfo * getBridgedType() const {
    return bridgedType;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::NSBridged; }
  static bool classof(const NSBridgedAttr *) { return true; }
};

class NSConsumedAttr : public InheritableParamAttr {

 public:
  NSConsumedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::NSConsumed, R)
  {
  }

  virtual NSConsumedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSConsumed; }
  static bool classof(const NSConsumedAttr *) { return true; }
};

class NSConsumesSelfAttr : public InheritableAttr {

 public:
  NSConsumesSelfAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSConsumesSelf, R)
  {
  }

  virtual NSConsumesSelfAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSConsumesSelf; }
  static bool classof(const NSConsumesSelfAttr *) { return true; }
};

class NSReturnsAutoreleasedAttr : public InheritableAttr {

 public:
  NSReturnsAutoreleasedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsAutoreleased, R)
  {
  }

  virtual NSReturnsAutoreleasedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsAutoreleased; }
  static bool classof(const NSReturnsAutoreleasedAttr *) { return true; }
};

class NSReturnsNotRetainedAttr : public InheritableAttr {

 public:
  NSReturnsNotRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsNotRetained, R)
  {
  }

  virtual NSReturnsNotRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsNotRetained; }
  static bool classof(const NSReturnsNotRetainedAttr *) { return true; }
};

class NSReturnsRetainedAttr : public InheritableAttr {

 public:
  NSReturnsRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsRetained, R)
  {
  }

  virtual NSReturnsRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsRetained; }
  static bool classof(const NSReturnsRetainedAttr *) { return true; }
};

class NakedAttr : public InheritableAttr {

 public:
  NakedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Naked, R)
  {
  }

  virtual NakedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Naked; }
  static bool classof(const NakedAttr *) { return true; }
};

class NoCommonAttr : public InheritableAttr {

 public:
  NoCommonAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoCommon, R)
  {
  }

  virtual NoCommonAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoCommon; }
  static bool classof(const NoCommonAttr *) { return true; }
};

class NoDebugAttr : public InheritableAttr {

 public:
  NoDebugAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoDebug, R)
  {
  }

  virtual NoDebugAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoDebug; }
  static bool classof(const NoDebugAttr *) { return true; }
};

class NoInlineAttr : public InheritableAttr {

 public:
  NoInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoInline, R)
  {
  }

  virtual NoInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInline; }
  static bool classof(const NoInlineAttr *) { return true; }
};

class NoInstrumentFunctionAttr : public InheritableAttr {

 public:
  NoInstrumentFunctionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoInstrumentFunction, R)
  {
  }

  virtual NoInstrumentFunctionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInstrumentFunction; }
  static bool classof(const NoInstrumentFunctionAttr *) { return true; }
};

class NoReturnAttr : public InheritableAttr {

 public:
  NoReturnAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoReturn, R)
  {
  }

  virtual NoReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoReturn; }
  static bool classof(const NoReturnAttr *) { return true; }
};

class NoThreadSafetyAnalysisAttr : public InheritableAttr {

 public:
  NoThreadSafetyAnalysisAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoThreadSafetyAnalysis, R)
  {
  }

  virtual NoThreadSafetyAnalysisAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoThreadSafetyAnalysis; }
  static bool classof(const NoThreadSafetyAnalysisAttr *) { return true; }
};

class NoThrowAttr : public InheritableAttr {

 public:
  NoThrowAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoThrow, R)
  {
  }

  virtual NoThrowAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoThrow; }
  static bool classof(const NoThrowAttr *) { return true; }
};

class NonNullAttr : public InheritableAttr {
  unsigned argsSize;
  unsigned *args;


 public:
  NonNullAttr(SourceRange R, ASTContext &Ctx
              , unsigned *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::NonNull, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual NonNullAttr *clone (ASTContext &C) const;
  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }

bool isNonNull(unsigned idx) const {
    for (args_iterator i = args_begin(), e = args_end();
         i != e; ++i)
      if (*i == idx)
        return true;
    return false;
  } 

  static bool classof(const Attr *A) { return A->getKind() == attr::NonNull; }
  static bool classof(const NonNullAttr *) { return true; }
};

class ObjCExceptionAttr : public InheritableAttr {

 public:
  ObjCExceptionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCException, R)
  {
  }

  virtual ObjCExceptionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCException; }
  static bool classof(const ObjCExceptionAttr *) { return true; }
};

class ObjCMethodFamilyAttr : public InheritableAttr {
public:
  enum FamilyKind {
    OMF_None,
    OMF_alloc,
    OMF_copy,
    OMF_init,
    OMF_mutableCopy,
    OMF_new
  };
private:
  FamilyKind family;


 public:
  ObjCMethodFamilyAttr(SourceRange R, ASTContext &Ctx
              , FamilyKind Family
             )
    : InheritableAttr(attr::ObjCMethodFamily, R)
              , family(Family)
  {

  }

  virtual ObjCMethodFamilyAttr *clone (ASTContext &C) const;
  FamilyKind getFamily() const {
    return family;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCMethodFamily; }
  static bool classof(const ObjCMethodFamilyAttr *) { return true; }
};

class ObjCNSObjectAttr : public InheritableAttr {

 public:
  ObjCNSObjectAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCNSObject, R)
  {
  }

  virtual ObjCNSObjectAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCNSObject; }
  static bool classof(const ObjCNSObjectAttr *) { return true; }
};

class ObjCPreciseLifetimeAttr : public Attr {

 public:
  ObjCPreciseLifetimeAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::ObjCPreciseLifetime, R)
  {
  }

  virtual ObjCPreciseLifetimeAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCPreciseLifetime; }
  static bool classof(const ObjCPreciseLifetimeAttr *) { return true; }
};

class ObjCReturnsInnerPointerAttr : public Attr {

 public:
  ObjCReturnsInnerPointerAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::ObjCReturnsInnerPointer, R)
  {
  }

  virtual ObjCReturnsInnerPointerAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCReturnsInnerPointer; }
  static bool classof(const ObjCReturnsInnerPointerAttr *) { return true; }
};

class OpenCLKernelAttr : public Attr {

 public:
  OpenCLKernelAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::OpenCLKernel, R)
  {
  }

  virtual OpenCLKernelAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::OpenCLKernel; }
  static bool classof(const OpenCLKernelAttr *) { return true; }
};

class OverloadableAttr : public Attr {

 public:
  OverloadableAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::Overloadable, R)
  {
  }

  virtual OverloadableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Overloadable; }
  static bool classof(const OverloadableAttr *) { return true; }
};

class OverrideAttr : public InheritableAttr {

 public:
  OverrideAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Override, R)
  {
  }

  virtual OverrideAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Override; }
  static bool classof(const OverrideAttr *) { return true; }
};

class OwnershipAttr : public InheritableAttr {
public:
  enum OwnershipKind {
    Holds,
    Returns,
    Takes
  };
private:
  OwnershipKind ownKind;

unsigned moduleLength;
char *module;

  unsigned argsSize;
  unsigned *args;


 public:
  OwnershipAttr(SourceRange R, ASTContext &Ctx
              , OwnershipKind OwnKind
              , llvm::StringRef Module
              , unsigned *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::Ownership, R)
              , ownKind(OwnKind)
              , moduleLength(Module.size()),module(new (Ctx, 1) char[moduleLength])
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {

      std::memcpy(module, Module.data(), moduleLength);
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual OwnershipAttr *clone (ASTContext &C) const;
  OwnershipKind getOwnKind() const {
    return ownKind;
  }

  llvm::StringRef getModule() const {
    return llvm::StringRef(module, moduleLength);
  }
  unsigned getModuleLength() const {
    return moduleLength;
  }
  void setModule(ASTContext &C, llvm::StringRef S) {
    moduleLength = S.size();
    this->module = new (C, 1) char [moduleLength];
    std::memcpy(this->module, S.data(), moduleLength);
  }

  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Ownership; }
  static bool classof(const OwnershipAttr *) { return true; }
};

class PackedAttr : public InheritableAttr {

 public:
  PackedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Packed, R)
  {
  }

  virtual PackedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Packed; }
  static bool classof(const PackedAttr *) { return true; }
};

class PascalAttr : public InheritableAttr {

 public:
  PascalAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Pascal, R)
  {
  }

  virtual PascalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pascal; }
  static bool classof(const PascalAttr *) { return true; }
};

class PcsAttr : public InheritableAttr {
public:
  enum PCSType {
    AAPCS,
    AAPCS_VFP
  };
private:
  PCSType pCS;


 public:
  PcsAttr(SourceRange R, ASTContext &Ctx
              , PCSType PCS
             )
    : InheritableAttr(attr::Pcs, R)
              , pCS(PCS)
  {

  }

  virtual PcsAttr *clone (ASTContext &C) const;
  PCSType getPCS() const {
    return pCS;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Pcs; }
  static bool classof(const PcsAttr *) { return true; }
};

class PtGuardedByAttr : public InheritableAttr {
Expr * arg;


 public:
  PtGuardedByAttr(SourceRange R, ASTContext &Ctx
              , Expr * Arg
             )
    : InheritableAttr(attr::PtGuardedBy, R)
              , arg(Arg)
  {

  }

  virtual PtGuardedByAttr *clone (ASTContext &C) const;
  Expr * getArg() const {
    return arg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::PtGuardedBy; }
  static bool classof(const PtGuardedByAttr *) { return true; }
};

class PtGuardedVarAttr : public InheritableAttr {

 public:
  PtGuardedVarAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::PtGuardedVar, R)
  {
  }

  virtual PtGuardedVarAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::PtGuardedVar; }
  static bool classof(const PtGuardedVarAttr *) { return true; }
};

class PureAttr : public InheritableAttr {

 public:
  PureAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Pure, R)
  {
  }

  virtual PureAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pure; }
  static bool classof(const PureAttr *) { return true; }
};

class RegparmAttr : public InheritableAttr {
unsigned numParams;


 public:
  RegparmAttr(SourceRange R, ASTContext &Ctx
              , unsigned NumParams
             )
    : InheritableAttr(attr::Regparm, R)
              , numParams(NumParams)
  {

  }

  virtual RegparmAttr *clone (ASTContext &C) const;
  unsigned getNumParams() const {
    return numParams;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Regparm; }
  static bool classof(const RegparmAttr *) { return true; }
};

class ReqdWorkGroupSizeAttr : public InheritableAttr {
unsigned xDim;

unsigned yDim;

unsigned zDim;


 public:
  ReqdWorkGroupSizeAttr(SourceRange R, ASTContext &Ctx
              , unsigned XDim
              , unsigned YDim
              , unsigned ZDim
             )
    : InheritableAttr(attr::ReqdWorkGroupSize, R)
              , xDim(XDim)
              , yDim(YDim)
              , zDim(ZDim)
  {



  }

  virtual ReqdWorkGroupSizeAttr *clone (ASTContext &C) const;
  unsigned getXDim() const {
    return xDim;
  }

  unsigned getYDim() const {
    return yDim;
  }

  unsigned getZDim() const {
    return zDim;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ReqdWorkGroupSize; }
  static bool classof(const ReqdWorkGroupSizeAttr *) { return true; }
};

class ReturnsTwiceAttr : public InheritableAttr {

 public:
  ReturnsTwiceAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ReturnsTwice, R)
  {
  }

  virtual ReturnsTwiceAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ReturnsTwice; }
  static bool classof(const ReturnsTwiceAttr *) { return true; }
};

class ScopedLockableAttr : public InheritableAttr {

 public:
  ScopedLockableAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ScopedLockable, R)
  {
  }

  virtual ScopedLockableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ScopedLockable; }
  static bool classof(const ScopedLockableAttr *) { return true; }
};

class SectionAttr : public InheritableAttr {
unsigned nameLength;
char *name;


 public:
  SectionAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Name
             )
    : InheritableAttr(attr::Section, R)
              , nameLength(Name.size()),name(new (Ctx, 1) char[nameLength])
  {
      std::memcpy(name, Name.data(), nameLength);
  }

  virtual SectionAttr *clone (ASTContext &C) const;
  llvm::StringRef getName() const {
    return llvm::StringRef(name, nameLength);
  }
  unsigned getNameLength() const {
    return nameLength;
  }
  void setName(ASTContext &C, llvm::StringRef S) {
    nameLength = S.size();
    this->name = new (C, 1) char [nameLength];
    std::memcpy(this->name, S.data(), nameLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Section; }
  static bool classof(const SectionAttr *) { return true; }
};

class SentinelAttr : public InheritableAttr {
int sentinel;

int nullPos;


 public:
  SentinelAttr(SourceRange R, ASTContext &Ctx
              , int Sentinel
              , int NullPos
             )
    : InheritableAttr(attr::Sentinel, R)
              , sentinel(Sentinel)
              , nullPos(NullPos)
  {


  }

  virtual SentinelAttr *clone (ASTContext &C) const;
  int getSentinel() const {
    return sentinel;
  }

  int getNullPos() const {
    return nullPos;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Sentinel; }
  static bool classof(const SentinelAttr *) { return true; }
};

class SharedLockFunctionAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  SharedLockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::SharedLockFunction, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual SharedLockFunctionAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::SharedLockFunction; }
  static bool classof(const SharedLockFunctionAttr *) { return true; }
};

class SharedLocksRequiredAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  SharedLocksRequiredAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::SharedLocksRequired, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual SharedLocksRequiredAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::SharedLocksRequired; }
  static bool classof(const SharedLocksRequiredAttr *) { return true; }
};

class SharedTrylockFunctionAttr : public InheritableAttr {
Expr * successValue;

  unsigned argsSize;
  Expr * *args;


 public:
  SharedTrylockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * SuccessValue
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::SharedTrylockFunction, R)
              , successValue(SuccessValue)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {

    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual SharedTrylockFunctionAttr *clone (ASTContext &C) const;
  Expr * getSuccessValue() const {
    return successValue;
  }

  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::SharedTrylockFunction; }
  static bool classof(const SharedTrylockFunctionAttr *) { return true; }
};

class StdCallAttr : public InheritableAttr {

 public:
  StdCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::StdCall, R)
  {
  }

  virtual StdCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::StdCall; }
  static bool classof(const StdCallAttr *) { return true; }
};

class ThisCallAttr : public InheritableAttr {

 public:
  ThisCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ThisCall, R)
  {
  }

  virtual ThisCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ThisCall; }
  static bool classof(const ThisCallAttr *) { return true; }
};

class TransparentUnionAttr : public InheritableAttr {

 public:
  TransparentUnionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::TransparentUnion, R)
  {
  }

  virtual TransparentUnionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::TransparentUnion; }
  static bool classof(const TransparentUnionAttr *) { return true; }
};

class UnavailableAttr : public InheritableAttr {
unsigned messageLength;
char *message;


 public:
  UnavailableAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Unavailable, R)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {
      std::memcpy(message, Message.data(), messageLength);
  }

  virtual UnavailableAttr *clone (ASTContext &C) const;
  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Unavailable; }
  static bool classof(const UnavailableAttr *) { return true; }
};

class UnlockFunctionAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  UnlockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::UnlockFunction, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual UnlockFunctionAttr *clone (ASTContext &C) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::UnlockFunction; }
  static bool classof(const UnlockFunctionAttr *) { return true; }
};

class UnusedAttr : public InheritableAttr {

 public:
  UnusedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Unused, R)
  {
  }

  virtual UnusedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Unused; }
  static bool classof(const UnusedAttr *) { return true; }
};

class UsedAttr : public InheritableAttr {

 public:
  UsedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Used, R)
  {
  }

  virtual UsedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Used; }
  static bool classof(const UsedAttr *) { return true; }
};

class UuidAttr : public InheritableAttr {
unsigned guidLength;
char *guid;


 public:
  UuidAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Guid
             )
    : InheritableAttr(attr::Uuid, R)
              , guidLength(Guid.size()),guid(new (Ctx, 1) char[guidLength])
  {
      std::memcpy(guid, Guid.data(), guidLength);
  }

  virtual UuidAttr *clone (ASTContext &C) const;
  llvm::StringRef getGuid() const {
    return llvm::StringRef(guid, guidLength);
  }
  unsigned getGuidLength() const {
    return guidLength;
  }
  void setGuid(ASTContext &C, llvm::StringRef S) {
    guidLength = S.size();
    this->guid = new (C, 1) char [guidLength];
    std::memcpy(this->guid, S.data(), guidLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Uuid; }
  static bool classof(const UuidAttr *) { return true; }
};

class VecReturnAttr : public InheritableAttr {

 public:
  VecReturnAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::VecReturn, R)
  {
  }

  virtual VecReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::VecReturn; }
  static bool classof(const VecReturnAttr *) { return true; }
};

class VisibilityAttr : public InheritableAttr {
public:
  enum VisibilityType {
    Default,
    Hidden,
    Protected
  };
private:
  VisibilityType visibility;


 public:
  VisibilityAttr(SourceRange R, ASTContext &Ctx
              , VisibilityType Visibility
             )
    : InheritableAttr(attr::Visibility, R)
              , visibility(Visibility)
  {

  }

  virtual VisibilityAttr *clone (ASTContext &C) const;
  VisibilityType getVisibility() const {
    return visibility;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Visibility; }
  static bool classof(const VisibilityAttr *) { return true; }
};

class WarnUnusedResultAttr : public InheritableAttr {

 public:
  WarnUnusedResultAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::WarnUnusedResult, R)
  {
  }

  virtual WarnUnusedResultAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WarnUnusedResult; }
  static bool classof(const WarnUnusedResultAttr *) { return true; }
};

class WeakAttr : public InheritableAttr {

 public:
  WeakAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Weak, R)
  {
  }

  virtual WeakAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Weak; }
  static bool classof(const WeakAttr *) { return true; }
};

class WeakImportAttr : public InheritableAttr {

 public:
  WeakImportAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::WeakImport, R)
  {
  }

  virtual WeakImportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakImport; }
  static bool classof(const WeakImportAttr *) { return true; }
};

class WeakRefAttr : public InheritableAttr {

 public:
  WeakRefAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::WeakRef, R)
  {
  }

  virtual WeakRefAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakRef; }
  static bool classof(const WeakRefAttr *) { return true; }
};

class X86ForceAlignArgPointerAttr : public InheritableAttr {

 public:
  X86ForceAlignArgPointerAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::X86ForceAlignArgPointer, R)
  {
  }

  virtual X86ForceAlignArgPointerAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::X86ForceAlignArgPointer; }
  static bool classof(const X86ForceAlignArgPointerAttr *) { return true; }
};

#endif
