/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenChar;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RETokenOneOf
extends REToken {
    private final List<REToken> options;
    private boolean negative;
    private boolean matchesOneChar;
    private final List<Object> addition;

    RETokenOneOf(int subIndex, String optionsStr, boolean negative, boolean insens) {
        super(subIndex);
        this.options = new ArrayList<REToken>();
        this.negative = negative;
        int i = 0;
        while (i < optionsStr.length()) {
            this.options.add(new RETokenChar(subIndex, optionsStr.charAt(i), insens));
            ++i;
        }
        this.matchesOneChar = true;
        this.addition = null;
    }

    RETokenOneOf(int subIndex, List<REToken> options, boolean negative) {
        this(subIndex, options, null, negative);
    }

    RETokenOneOf(int subIndex, List<REToken> options, List<Object> addition, boolean negative) {
        super(subIndex);
        this.options = options;
        this.addition = addition;
        this.negative = negative;
        this.matchesOneChar = negative || addition != null;
    }

    @Override
    int getMinimumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int min = Integer.MAX_VALUE;
        for (REToken t : this.options) {
            int x = t.getMinimumLength();
            if (x >= min) continue;
            min = x;
        }
        return min;
    }

    @Override
    int getMaximumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int max = 0;
        for (REToken t : this.options) {
            int x = t.getMaximumLength();
            if (x <= max) continue;
            max = x;
        }
        return max;
    }

    @Override
    boolean match(CharIndexed input, REMatch mymatch) {
        this.setHitEnd(input, mymatch);
        if (this.matchesOneChar) {
            return this.matchOneChar(input, mymatch);
        }
        return this.matchOneRE(input, mymatch);
    }

    boolean matchOneChar(CharIndexed input, REMatch mymatch) {
        boolean b;
        boolean tryOnly;
        REMatch tryMatch;
        if (this.addition == null) {
            tryMatch = mymatch;
            tryOnly = false;
        } else {
            tryMatch = (REMatch)mymatch.clone();
            tryOnly = true;
        }
        boolean bl = b = this.negative ? this.matchN(input, tryMatch, tryOnly) : this.matchP(input, tryMatch, tryOnly);
        if (this.addition == null) {
            return b;
        }
        ArrayDeque<Boolean> stack = new ArrayDeque<Boolean>();
        stack.push(new Boolean(b));
        for (Object obj : this.addition) {
            if (obj instanceof REToken) {
                b = ((REToken)obj).match(input, (REMatch)mymatch.clone());
                stack.push(new Boolean(b));
                continue;
            }
            if (obj instanceof Boolean) {
                stack.push((Boolean)obj);
                continue;
            }
            if (obj.equals("|")) {
                b = (Boolean)stack.pop();
                b = (Boolean)stack.pop() != false || b;
                stack.push(new Boolean(b));
                continue;
            }
            if (obj.equals("&")) {
                b = (Boolean)stack.pop();
                b = (Boolean)stack.pop() != false && b;
                stack.push(new Boolean(b));
                continue;
            }
            throw new RuntimeException("Invalid object found");
        }
        if (((Boolean)stack.pop()).booleanValue()) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    private boolean matchN(CharIndexed input, REMatch mymatch, boolean tryOnly) {
        if (input.charAt(mymatch.index) == '\uffff') {
            return false;
        }
        for (REToken tk : this.options) {
            REMatch tryMatch;
            if (!tk.match(input, tryMatch = (REMatch)mymatch.clone())) continue;
            return false;
        }
        if (tryOnly) {
            return true;
        }
        ++mymatch.index;
        return this.next(input, mymatch);
    }

    private boolean matchP(CharIndexed input, REMatch mymatch, boolean tryOnly) {
        for (REToken tk : this.options) {
            REMatch tryMatch;
            if (!tk.match(input, tryMatch = (REMatch)mymatch.clone())) continue;
            if (tryOnly) {
                return true;
            }
            if (!this.next(input, tryMatch)) continue;
            mymatch.assignFrom(tryMatch);
            return true;
        }
        return false;
    }

    private boolean matchOneRE(CharIndexed input, REMatch mymatch) {
        REMatch newMatch = this.findMatch(input, mymatch);
        if (newMatch != null) {
            mymatch.assignFrom(newMatch);
            return true;
        }
        return false;
    }

    @Override
    REMatch findMatch(CharIndexed input, REMatch mymatch) {
        if (this.matchesOneChar) {
            return super.findMatch(input, mymatch);
        }
        return this.findMatch(input, mymatch, 0);
    }

    @Override
    REMatch backtrack(CharIndexed input, REMatch mymatch, Object param) {
        return this.findMatch(input, mymatch, (Integer)param);
    }

    private REMatch findMatch(CharIndexed input, REMatch mymatch, int optionIndex) {
        int i = optionIndex;
        while (i < this.options.size()) {
            REToken tk = this.options.get(i);
            tk = (REToken)tk.clone();
            tk.chain(this.getNext());
            REMatch tryMatch = (REMatch)mymatch.clone();
            if (tryMatch.backtrackStack == null) {
                tryMatch.backtrackStack = new BacktrackStack();
            }
            boolean stackPushed = false;
            if (i + 1 < this.options.size()) {
                tryMatch.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, i + 1));
                stackPushed = true;
            }
            if (tk.match(input, tryMatch)) {
                return tryMatch;
            }
            if (stackPushed) {
                tryMatch.backtrackStack.pop();
            }
            ++i;
        }
        return null;
    }

    @Override
    boolean returnsFixedLengthMatches() {
        return this.matchesOneChar;
    }

    @Override
    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        int numRepeats;
        if (!this.matchesOneChar) {
            return super.findFixedLengthMatches(input, mymatch, max);
        }
        REMatch m = (REMatch)mymatch.clone();
        REToken tk = (REToken)this.clone();
        tk.chain(null);
        for (numRepeats = 0; numRepeats < max && (m = tk.findMatch(input, m)) != null; ++numRepeats) {
        }
        return numRepeats;
    }

    @Override
    void dump(CPStringBuilder os) {
        os.append(this.negative ? "[^" : "(?:");
        int i = 0;
        while (i < this.options.size()) {
            if (!this.negative && i > 0) {
                os.append('|');
            }
            this.options.get(i).dumpAll(os);
            ++i;
        }
        os.append(this.negative ? (char)']' : ')');
    }
}

