/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgTraitService.idl
 */

#ifndef __gen_nsIMsgTraitService_h__
#define __gen_nsIMsgTraitService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIMsgTraitService */
#define NS_IMSGTRAITSERVICE_IID_STR "2cb15fb0-a912-40d3-8882-f2765c75655f"

#define NS_IMSGTRAITSERVICE_IID \
  {0x2cb15fb0, 0xa912, 0x40d3, \
    { 0x88, 0x82, 0xf2, 0x76, 0x5c, 0x75, 0x65, 0x5f }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgTraitService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGTRAITSERVICE_IID)

  /**
   *  the highest ever index for a registered trait. The first trait is 1,
   *  == 0 means no traits are defined
   */
  /* readonly attribute long lastIndex; */
  NS_SCRIPTABLE NS_IMETHOD GetLastIndex(PRInt32 *aLastIndex) = 0;

  /**
   * Register a trait. May be called multiple times, but subsequent
   * calls do not register the trait
   *
   * @param id   the trait universal identifier
   *
   * @return     the internal index for the registered trait if newly
   *             registered, else 0
   */
  /* unsigned long registerTrait (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD RegisterTrait(const nsACString & id, PRUint32 *_retval NS_OUTPARAM) = 0;

  /**
   * Unregister a trait.
   *
   * @param id   the trait universal identifier
   */
  /* void unRegisterTrait (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD UnRegisterTrait(const nsACString & id) = 0;

  /**
   * is a trait registered?
   *
   * @param id   the trait universal identifier
   *
   * @return     true if registered
   */
  /* boolean isRegistered (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD IsRegistered(const nsACString & id, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * set the trait name, which is an optional short description of the trait
   *
   * @param id     the trait universal identifier
   * @param name   description of the trait.
   */
  /* void setName (in ACString id, in ACString name); */
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsACString & id, const nsACString & name) = 0;

  /**
   * get the trait name, which is an optional short description of the trait
   *
   * @param id   the trait universal identifier
   *
   * @return     description of the trait
   */
  /* ACString getName (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD GetName(const nsACString & id, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * get the internal index number for the trait.
   *
   * @param id   the trait universal identifier
   *
   * @return     internal index number for the trait
   */
  /* unsigned long getIndex (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD GetIndex(const nsACString & id, PRUint32 *_retval NS_OUTPARAM) = 0;

  /**
   * get the trait universal identifier for an internal trait index
   *
   * @param index   the internal identifier for the trait
   *
   * @return        trait universal identifier
   */
  /* ACString getId (in unsigned long index); */
  NS_SCRIPTABLE NS_IMETHOD GetId(PRUint32 index, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * enable the trait for analysis. Each enabled trait will be analyzed by
   * the bayesian code. The enabled trait is the "pro" trait that represents
   * messages matching the trait. Each enabled trait also needs a corresponding
   * anti trait defined, which represents messages that do not match the trait.
   * The anti trait does not need to be enabled
   *
   * @param id        the trait universal identifier
   * @param enabled   should this trait be processed by the bayesian analyzer?
   */
  /* void setEnabled (in ACString id, in boolean enabled); */
  NS_SCRIPTABLE NS_IMETHOD SetEnabled(const nsACString & id, PRBool enabled) = 0;

  /**
   * Should this trait be processed by the bayes analyzer?
   *
   * @param id   the trait universal identifier
   *
   * @return     true if this is a "pro" trait to process
   */
  /* boolean getEnabled (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD GetEnabled(const nsACString & id, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * set the anti trait, which indicates messages that have been marked as
   * NOT matching a particular trait.
   *
   * @param id      the trait universal identifier
   * @param antiId  trait id for messages marked as not matching the trait
   */
  /* void setAntiId (in ACString id, in ACString antiId); */
  NS_SCRIPTABLE NS_IMETHOD SetAntiId(const nsACString & id, const nsACString & antiId) = 0;

  /**
   * get the id of traits that do not match a particular trait
   *
   * @param id   the trait universal identifier for a "pro" trait
   *
   * @return     universal trait identifier for an "anti" trait that does not
   *             match the "pro" trait messages
   */
  /* ACString getAntiId (in ACString id); */
  NS_SCRIPTABLE NS_IMETHOD GetAntiId(const nsACString & id, nsACString & _retval NS_OUTPARAM) = 0;

  /**
   * get an array of traits to be analyzed by the bayesian code. This is
   * a pair of traits: a "pro" trait of messages that match the trait (and is
   * set enabled) and an "anti" trait of messages that do not match the trait.
   *
   * @param count        length of proIndices and antiIndices arrays
   * @param proIndices   trait internal index for "pro" trait to analyze
   * @param antiIndices  trait internal index for corresponding "anti" traits
   */
  /* void getEnabledIndices (out unsigned long count, [array, size_is (count)] out unsigned long proIndices, [array, size_is (count)] out unsigned long antiIndices); */
  NS_SCRIPTABLE NS_IMETHOD GetEnabledIndices(PRUint32 *count NS_OUTPARAM, PRUint32 **proIndices NS_OUTPARAM, PRUint32 **antiIndices NS_OUTPARAM) = 0;

  /**
   * Add a trait as an alias of another trait. An alias is a trait whose
   * counts will be combined with the aliased trait. This allows multiple sets
   * of corpus data to be used to provide information on a single message
   * characteristic, while allowing each individual set of corpus data to
   * retain its own identity.
   *
   * @param aTraitIndex  the internal identifier for the aliased trait
   * @param aTraitAlias  the internal identifier for the alias to add
   */
  /* void addAlias (in unsigned long aTraitIndex, in unsigned long aTraitAlias); */
  NS_SCRIPTABLE NS_IMETHOD AddAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias) = 0;

  /**
   * Removes a trait as an alias of another trait.
   *
   * @param aTraitIndex  the internal identifier for the aliased trait
   * @param aTraitAlias  the internal identifier for the alias to remove
   */
  /* void removeAlias (in unsigned long aTraitIndex, in unsigned long aTraitAlias); */
  NS_SCRIPTABLE NS_IMETHOD RemoveAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias) = 0;

  /**
   * Get an array of trait aliases for a trait index, if any
   *
   * @param aTraitIndex  the internal identifier for the aliased trait
   * @param aLength      length of array of aliases
   * @param aAliases     array of internal identifiers for aliases
   */
  /* void getAliases (in unsigned long aTraitIndex, out unsigned long aLength, [array, retval, size_is (aLength)] out unsigned long aAliases); */
  NS_SCRIPTABLE NS_IMETHOD GetAliases(PRUint32 aTraitIndex, PRUint32 *aLength NS_OUTPARAM, PRUint32 **aAliases NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgTraitService, NS_IMSGTRAITSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGTRAITSERVICE \
  NS_SCRIPTABLE NS_IMETHOD GetLastIndex(PRInt32 *aLastIndex); \
  NS_SCRIPTABLE NS_IMETHOD RegisterTrait(const nsACString & id, PRUint32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD UnRegisterTrait(const nsACString & id); \
  NS_SCRIPTABLE NS_IMETHOD IsRegistered(const nsACString & id, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsACString & id, const nsACString & name); \
  NS_SCRIPTABLE NS_IMETHOD GetName(const nsACString & id, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetIndex(const nsACString & id, PRUint32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRUint32 index, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetEnabled(const nsACString & id, PRBool enabled); \
  NS_SCRIPTABLE NS_IMETHOD GetEnabled(const nsACString & id, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetAntiId(const nsACString & id, const nsACString & antiId); \
  NS_SCRIPTABLE NS_IMETHOD GetAntiId(const nsACString & id, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetEnabledIndices(PRUint32 *count NS_OUTPARAM, PRUint32 **proIndices NS_OUTPARAM, PRUint32 **antiIndices NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD AddAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias); \
  NS_SCRIPTABLE NS_IMETHOD RemoveAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias); \
  NS_SCRIPTABLE NS_IMETHOD GetAliases(PRUint32 aTraitIndex, PRUint32 *aLength NS_OUTPARAM, PRUint32 **aAliases NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGTRAITSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetLastIndex(PRInt32 *aLastIndex) { return _to GetLastIndex(aLastIndex); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterTrait(const nsACString & id, PRUint32 *_retval NS_OUTPARAM) { return _to RegisterTrait(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UnRegisterTrait(const nsACString & id) { return _to UnRegisterTrait(id); } \
  NS_SCRIPTABLE NS_IMETHOD IsRegistered(const nsACString & id, PRBool *_retval NS_OUTPARAM) { return _to IsRegistered(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsACString & id, const nsACString & name) { return _to SetName(id, name); } \
  NS_SCRIPTABLE NS_IMETHOD GetName(const nsACString & id, nsACString & _retval NS_OUTPARAM) { return _to GetName(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetIndex(const nsACString & id, PRUint32 *_retval NS_OUTPARAM) { return _to GetIndex(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRUint32 index, nsACString & _retval NS_OUTPARAM) { return _to GetId(index, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetEnabled(const nsACString & id, PRBool enabled) { return _to SetEnabled(id, enabled); } \
  NS_SCRIPTABLE NS_IMETHOD GetEnabled(const nsACString & id, PRBool *_retval NS_OUTPARAM) { return _to GetEnabled(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetAntiId(const nsACString & id, const nsACString & antiId) { return _to SetAntiId(id, antiId); } \
  NS_SCRIPTABLE NS_IMETHOD GetAntiId(const nsACString & id, nsACString & _retval NS_OUTPARAM) { return _to GetAntiId(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetEnabledIndices(PRUint32 *count NS_OUTPARAM, PRUint32 **proIndices NS_OUTPARAM, PRUint32 **antiIndices NS_OUTPARAM) { return _to GetEnabledIndices(count, proIndices, antiIndices); } \
  NS_SCRIPTABLE NS_IMETHOD AddAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias) { return _to AddAlias(aTraitIndex, aTraitAlias); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias) { return _to RemoveAlias(aTraitIndex, aTraitAlias); } \
  NS_SCRIPTABLE NS_IMETHOD GetAliases(PRUint32 aTraitIndex, PRUint32 *aLength NS_OUTPARAM, PRUint32 **aAliases NS_OUTPARAM) { return _to GetAliases(aTraitIndex, aLength, aAliases); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGTRAITSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetLastIndex(PRInt32 *aLastIndex) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastIndex(aLastIndex); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterTrait(const nsACString & id, PRUint32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterTrait(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD UnRegisterTrait(const nsACString & id) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnRegisterTrait(id); } \
  NS_SCRIPTABLE NS_IMETHOD IsRegistered(const nsACString & id, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsRegistered(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetName(const nsACString & id, const nsACString & name) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetName(id, name); } \
  NS_SCRIPTABLE NS_IMETHOD GetName(const nsACString & id, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetIndex(const nsACString & id, PRUint32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIndex(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetId(PRUint32 index, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetId(index, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetEnabled(const nsACString & id, PRBool enabled) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEnabled(id, enabled); } \
  NS_SCRIPTABLE NS_IMETHOD GetEnabled(const nsACString & id, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEnabled(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetAntiId(const nsACString & id, const nsACString & antiId) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAntiId(id, antiId); } \
  NS_SCRIPTABLE NS_IMETHOD GetAntiId(const nsACString & id, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAntiId(id, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetEnabledIndices(PRUint32 *count NS_OUTPARAM, PRUint32 **proIndices NS_OUTPARAM, PRUint32 **antiIndices NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEnabledIndices(count, proIndices, antiIndices); } \
  NS_SCRIPTABLE NS_IMETHOD AddAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddAlias(aTraitIndex, aTraitAlias); } \
  NS_SCRIPTABLE NS_IMETHOD RemoveAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAlias(aTraitIndex, aTraitAlias); } \
  NS_SCRIPTABLE NS_IMETHOD GetAliases(PRUint32 aTraitIndex, PRUint32 *aLength NS_OUTPARAM, PRUint32 **aAliases NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAliases(aTraitIndex, aLength, aAliases); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgTraitService : public nsIMsgTraitService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGTRAITSERVICE

  nsMsgTraitService();

private:
  ~nsMsgTraitService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgTraitService, nsIMsgTraitService)

nsMsgTraitService::nsMsgTraitService()
{
  /* member initializers and constructor code */
}

nsMsgTraitService::~nsMsgTraitService()
{
  /* destructor code */
}

/* readonly attribute long lastIndex; */
NS_IMETHODIMP nsMsgTraitService::GetLastIndex(PRInt32 *aLastIndex)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long registerTrait (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::RegisterTrait(const nsACString & id, PRUint32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void unRegisterTrait (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::UnRegisterTrait(const nsACString & id)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isRegistered (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::IsRegistered(const nsACString & id, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setName (in ACString id, in ACString name); */
NS_IMETHODIMP nsMsgTraitService::SetName(const nsACString & id, const nsACString & name)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getName (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::GetName(const nsACString & id, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long getIndex (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::GetIndex(const nsACString & id, PRUint32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getId (in unsigned long index); */
NS_IMETHODIMP nsMsgTraitService::GetId(PRUint32 index, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEnabled (in ACString id, in boolean enabled); */
NS_IMETHODIMP nsMsgTraitService::SetEnabled(const nsACString & id, PRBool enabled)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getEnabled (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::GetEnabled(const nsACString & id, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setAntiId (in ACString id, in ACString antiId); */
NS_IMETHODIMP nsMsgTraitService::SetAntiId(const nsACString & id, const nsACString & antiId)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getAntiId (in ACString id); */
NS_IMETHODIMP nsMsgTraitService::GetAntiId(const nsACString & id, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getEnabledIndices (out unsigned long count, [array, size_is (count)] out unsigned long proIndices, [array, size_is (count)] out unsigned long antiIndices); */
NS_IMETHODIMP nsMsgTraitService::GetEnabledIndices(PRUint32 *count NS_OUTPARAM, PRUint32 **proIndices NS_OUTPARAM, PRUint32 **antiIndices NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addAlias (in unsigned long aTraitIndex, in unsigned long aTraitAlias); */
NS_IMETHODIMP nsMsgTraitService::AddAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAlias (in unsigned long aTraitIndex, in unsigned long aTraitAlias); */
NS_IMETHODIMP nsMsgTraitService::RemoveAlias(PRUint32 aTraitIndex, PRUint32 aTraitAlias)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getAliases (in unsigned long aTraitIndex, out unsigned long aLength, [array, retval, size_is (aLength)] out unsigned long aAliases); */
NS_IMETHODIMP nsMsgTraitService::GetAliases(PRUint32 aTraitIndex, PRUint32 *aLength NS_OUTPARAM, PRUint32 **aAliases NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgTraitService_h__ */
