/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgShutdown.idl
 */

#ifndef __gen_nsIMsgShutdown_h__
#define __gen_nsIMsgShutdown_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIUrlListener; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIWebProgressListener; /* forward declaration */


/* starting interface:    nsIMsgShutdownTask */
#define NS_IMSGSHUTDOWNTASK_IID_STR "d1b43428-b631-4629-b691-ab0e01a2db4b"

#define NS_IMSGSHUTDOWNTASK_IID \
  {0xd1b43428, 0xb631, 0x4629, \
    { 0xb6, 0x91, 0xab, 0x0e, 0x01, 0xa2, 0xdb, 0x4b }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgShutdownTask : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGSHUTDOWNTASK_IID)

  /**
   * Inform the caller wheter or not the task needs to be run. This method
   * gives the task the flexibility to cancel running a task on shutdown
   * if nothing needs to be run.
   */
  /* readonly attribute boolean needsToRunTask; */
  NS_SCRIPTABLE NS_IMETHOD GetNeedsToRunTask(PRBool *aNeedsToRunTask) = 0;

  /**
   * At shutdown-time, this function will be called to all registered implementors.
   * Shutdown will be temporarily postponed until |OnStopRequest()| has been called
   * on the passed in url-listener. 
   * @param inUrlListener The URL listener to report events to.
   * @param inMsgWindow The current message window to allow for posing dialogs.
   * @return If the shutdown URL was run or not. If the URL is running, the task
   *         will be responsible for notifying |inUrlListener| when the task is completed.
   */
  /* boolean doShutdownTask (in nsIUrlListener inUrlListener, in nsIMsgWindow inMsgWindow); */
  NS_SCRIPTABLE NS_IMETHOD DoShutdownTask(nsIUrlListener *inUrlListener, nsIMsgWindow *inMsgWindow, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Get the displayable name of the current task. This textual information will be
   * shown to the user so they know what shutdown task is being performed.
   * @return The name of the current task being performed.
   */
  /* AString getCurrentTaskName (); */
  NS_SCRIPTABLE NS_IMETHOD GetCurrentTaskName(nsAString & _retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgShutdownTask, NS_IMSGSHUTDOWNTASK_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGSHUTDOWNTASK \
  NS_SCRIPTABLE NS_IMETHOD GetNeedsToRunTask(PRBool *aNeedsToRunTask); \
  NS_SCRIPTABLE NS_IMETHOD DoShutdownTask(nsIUrlListener *inUrlListener, nsIMsgWindow *inMsgWindow, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentTaskName(nsAString & _retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGSHUTDOWNTASK(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetNeedsToRunTask(PRBool *aNeedsToRunTask) { return _to GetNeedsToRunTask(aNeedsToRunTask); } \
  NS_SCRIPTABLE NS_IMETHOD DoShutdownTask(nsIUrlListener *inUrlListener, nsIMsgWindow *inMsgWindow, PRBool *_retval NS_OUTPARAM) { return _to DoShutdownTask(inUrlListener, inMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentTaskName(nsAString & _retval NS_OUTPARAM) { return _to GetCurrentTaskName(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGSHUTDOWNTASK(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetNeedsToRunTask(PRBool *aNeedsToRunTask) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNeedsToRunTask(aNeedsToRunTask); } \
  NS_SCRIPTABLE NS_IMETHOD DoShutdownTask(nsIUrlListener *inUrlListener, nsIMsgWindow *inMsgWindow, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoShutdownTask(inUrlListener, inMsgWindow, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCurrentTaskName(nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentTaskName(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgShutdownTask : public nsIMsgShutdownTask
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGSHUTDOWNTASK

  nsMsgShutdownTask();

private:
  ~nsMsgShutdownTask();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgShutdownTask, nsIMsgShutdownTask)

nsMsgShutdownTask::nsMsgShutdownTask()
{
  /* member initializers and constructor code */
}

nsMsgShutdownTask::~nsMsgShutdownTask()
{
  /* destructor code */
}

/* readonly attribute boolean needsToRunTask; */
NS_IMETHODIMP nsMsgShutdownTask::GetNeedsToRunTask(PRBool *aNeedsToRunTask)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean doShutdownTask (in nsIUrlListener inUrlListener, in nsIMsgWindow inMsgWindow); */
NS_IMETHODIMP nsMsgShutdownTask::DoShutdownTask(nsIUrlListener *inUrlListener, nsIMsgWindow *inMsgWindow, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getCurrentTaskName (); */
NS_IMETHODIMP nsMsgShutdownTask::GetCurrentTaskName(nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIMsgShutdownService */
#define NS_IMSGSHUTDOWNSERVICE_IID_STR "483c8abb-ecf9-48a3-a394-2c604b603bd5"

#define NS_IMSGSHUTDOWNSERVICE_IID \
  {0x483c8abb, 0xecf9, 0x48a3, \
    { 0xa3, 0x94, 0x2c, 0x60, 0x4b, 0x60, 0x3b, 0xd5 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgShutdownService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGSHUTDOWNSERVICE_IID)

  /**
   * Get the number of tasks that will need to be processed at shutdown time.
   * @return The number of shutdown tasks to do.
   */
  /* long getNumTasks (); */
  NS_SCRIPTABLE NS_IMETHOD GetNumTasks(PRInt32 *_retval NS_OUTPARAM) = 0;

  /**
   * Start the shutdown tasks. 
   */
  /* void startShutdownTasks (); */
  NS_SCRIPTABLE NS_IMETHOD StartShutdownTasks(void) = 0;

  /**
   * Tell the service to stop running tasks and go ahead and shutdown the application.
   */
  /* void cancelShutdownTasks (); */
  NS_SCRIPTABLE NS_IMETHOD CancelShutdownTasks(void) = 0;

  /**
   * Set the shutdown listener.
   */
  /* void setShutdownListener (in nsIWebProgressListener inListener); */
  NS_SCRIPTABLE NS_IMETHOD SetShutdownListener(nsIWebProgressListener *inListener) = 0;

  /**
   * Set the status text of the shutdown progress dialog.
   */
  /* void setStatusText (in AString inStatusString); */
  NS_SCRIPTABLE NS_IMETHOD SetStatusText(const nsAString & inStatusString) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgShutdownService, NS_IMSGSHUTDOWNSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGSHUTDOWNSERVICE \
  NS_SCRIPTABLE NS_IMETHOD GetNumTasks(PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD StartShutdownTasks(void); \
  NS_SCRIPTABLE NS_IMETHOD CancelShutdownTasks(void); \
  NS_SCRIPTABLE NS_IMETHOD SetShutdownListener(nsIWebProgressListener *inListener); \
  NS_SCRIPTABLE NS_IMETHOD SetStatusText(const nsAString & inStatusString); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGSHUTDOWNSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetNumTasks(PRInt32 *_retval NS_OUTPARAM) { return _to GetNumTasks(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD StartShutdownTasks(void) { return _to StartShutdownTasks(); } \
  NS_SCRIPTABLE NS_IMETHOD CancelShutdownTasks(void) { return _to CancelShutdownTasks(); } \
  NS_SCRIPTABLE NS_IMETHOD SetShutdownListener(nsIWebProgressListener *inListener) { return _to SetShutdownListener(inListener); } \
  NS_SCRIPTABLE NS_IMETHOD SetStatusText(const nsAString & inStatusString) { return _to SetStatusText(inStatusString); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGSHUTDOWNSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetNumTasks(PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumTasks(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD StartShutdownTasks(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartShutdownTasks(); } \
  NS_SCRIPTABLE NS_IMETHOD CancelShutdownTasks(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelShutdownTasks(); } \
  NS_SCRIPTABLE NS_IMETHOD SetShutdownListener(nsIWebProgressListener *inListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetShutdownListener(inListener); } \
  NS_SCRIPTABLE NS_IMETHOD SetStatusText(const nsAString & inStatusString) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStatusText(inStatusString); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgShutdownService : public nsIMsgShutdownService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGSHUTDOWNSERVICE

  nsMsgShutdownService();

private:
  ~nsMsgShutdownService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgShutdownService, nsIMsgShutdownService)

nsMsgShutdownService::nsMsgShutdownService()
{
  /* member initializers and constructor code */
}

nsMsgShutdownService::~nsMsgShutdownService()
{
  /* destructor code */
}

/* long getNumTasks (); */
NS_IMETHODIMP nsMsgShutdownService::GetNumTasks(PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void startShutdownTasks (); */
NS_IMETHODIMP nsMsgShutdownService::StartShutdownTasks()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelShutdownTasks (); */
NS_IMETHODIMP nsMsgShutdownService::CancelShutdownTasks()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setShutdownListener (in nsIWebProgressListener inListener); */
NS_IMETHODIMP nsMsgShutdownService::SetShutdownListener(nsIWebProgressListener *inListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setStatusText (in AString inStatusString); */
NS_IMETHODIMP nsMsgShutdownService::SetStatusText(const nsAString & inStatusString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgShutdown_h__ */
