/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgSend.idl
 */

#ifndef __gen_nsIMsgSend_h__
#define __gen_nsIMsgSend_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsrootidl_h__
#include "nsrootidl.h"
#endif

#ifndef __gen_nsIMsgIdentity_h__
#include "nsIMsgIdentity.h"
#endif

#ifndef __gen_nsIMsgCompFields_h__
#include "nsIMsgCompFields.h"
#endif

#ifndef __gen_nsIMsgSendListener_h__
#include "nsIMsgSendListener.h"
#endif

#ifndef __gen_nsIMsgSendReport_h__
#include "nsIMsgSendReport.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

#ifndef __gen_nsIPrompt_h__
#include "nsIPrompt.h"
#endif

#ifndef __gen_MailNewsTypes2_h__
#include "MailNewsTypes2.h"
#endif

#ifndef __gen_nsIMsgComposeParams_h__
#include "nsIMsgComposeParams.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "nsIURL.h"
class nsIMsgProgress; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIRequest; /* forward declaration */

class nsIMsgDBHdr; /* forward declaration */

class nsIMsgHdr; /* forward declaration */

class nsIDocShell; /* forward declaration */

class nsIFile; /* forward declaration */

class nsILocalFile; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIMsgComposeSecure; /* forward declaration */

class nsIMsgStatusFeedback; /* forward declaration */

class nsIEditor; /* forward declaration */

typedef PRInt32  nsMsgDeliverMode;

//
// Callback declarations for message delivery
//
// For completion of send/message creation operations...
typedef nsresult (*nsMsgSendCompletionCallback) (nsresult aExitCode, void *tagData, nsILocalFile *returnFile);
// For completion of sending unsent messages operations...
typedef nsresult (*nsMsgSendUnsentMessagesCallback) (nsresult aExitCode, PRUint32 totalSentCount,
                                                     PRUint32 totalSentSuccessfully, void *tagData);
// Forward declaration
class nsMsgAttachmentHandler;
// Attachment file/URL structures
struct nsMsgAttachmentData
{
  nsIURI* url;            // The URL to attach. This should be 0 to signify "end of list".
  char *desired_type;      // The type to which this document should be
                          // converted.  Legal values are NULL, TEXT_PLAIN
                          // and APPLICATION_POSTSCRIPT (which are macros
                          // defined in net.h); other values are ignored.
  char *real_type;        // The type of the URL if known, otherwise NULL. For example, if 
                          // you were attaching a temp file which was known to contain HTML data, 
                          // you would pass in TEXT_HTML as the real_type, to override whatever type 
                          // the name of the tmp file might otherwise indicate.
  char *real_encoding;    // Goes along with real_type 
  char *real_name;        // The original name of this document, which will eventually show up in the 
                          // Content-Disposition header. For example, if you had copied a document to a 
                          // tmp file, this would be the original, human-readable name of the document.
  char *description;      // If you put a string here, it will show up as the Content-Description header.  
                          // This can be any explanatory text; it's not a file name.             
  char *x_mac_type, *x_mac_creator; // Mac-specific data that should show up as optional parameters
                                    // to the content-type header.
  PRInt32 size;                  // The size of the attachment. May be 0.
  PRBool  isExternalAttachment;  // Flag for determining if the attachment is external
};
//
// When we have downloaded a URL to a tmp file for attaching, this
// represents everything we learned about it (and did to it) in the
// process. 
//
typedef struct nsMsgAttachedFile
{
  nsCOMPtr<nsIURI> orig_url;  // Where it came from on the network (or even elsewhere on the local disk.)
  nsCOMPtr <nsILocalFile>  tmp_file;    // The tmp file in which the (possibly converted) data now resides.
  
  char        *type;        // The type of the data in file_name (not necessarily the same as the type of orig_url.)
  char        *encoding;    // Likewise, the encoding of the tmp file. This will be set only if the original 
                            // document had an encoding already; we don't do base64 encoding and so forth until 
                            // it's time to assemble a full MIME message of all parts.
  char        *description;    // For Content-Description header 
  char        *x_mac_type;    // mac-specific info 
  char        *x_mac_creator; // mac-specific info 
  char        *real_name;      // The real name of the file. 
  // Some statistics about the data that was written to the file, so that when
  // it comes time to compose a MIME message, we can make an informed decision
  // about what Content-Transfer-Encoding would be best for this attachment.
  // (If it's encoded already, we ignore this information and ship it as-is.)
  PRUint32    size;
  PRUint32    unprintable_count;
  PRUint32    highbit_count;
  PRUint32    ctl_count;
  PRUint32    null_count;
  PRUint32    max_line_length;
  
} nsMsgAttachedFile;

/* starting interface:    nsIMsgSend */
#define NS_IMSGSEND_IID_STR "8a3eb87e-6643-439b-bf0c-3aa2ede692ef"

#define NS_IMSGSEND_IID \
  {0x8a3eb87e, 0x6643, 0x439b, \
    { 0xbf, 0x0c, 0x3a, 0xa2, 0xed, 0xe6, 0x92, 0xef }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgSend : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGSEND_IID)

  enum { nsMsgDeliverNow = 0 };

  /**
   * Queue the message for sending later, but then wait for the user to
   * request to send it.
   */
  enum { nsMsgQueueForLater = 1 };

  enum { nsMsgSave = 2 };

  enum { nsMsgSaveAs = 3 };

  enum { nsMsgSaveAsDraft = 4 };

  enum { nsMsgSaveAsTemplate = 5 };

  enum { nsMsgSendUnsent = 6 };

  enum { nsMsgDeliverBackground = 8 };

  /* [noscript] void createAndSendMessage (in nsIEditor aEditor, in nsIMsgIdentity aUserIdentity, in string aAccountKey, in nsIMsgCompFields fields, in PRBool digest_p, in PRBool dont_deliver_p, in nsMsgDeliverMode mode, in nsIMsgDBHdr msgToReplace, in string attachment1_type, in string attachment1_body, in PRUint32 attachment1_body_length, [const] in nsMsgAttachmentData attachments, [const] in nsMsgAttachedFile preloaded_attachments, in voidPtr relatedPart, in nsIDOMWindowInternal parentWindow, in nsIMsgProgress progress, in nsIMsgSendListener aListener, in string password, in AUTF8String aOriginalMsgURI, in MSG_ComposeType aType); */
  NS_IMETHOD CreateAndSendMessage(nsIEditor *aEditor, nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *fields, PRBool digest_p, PRBool dont_deliver_p, nsMsgDeliverMode mode, nsIMsgDBHdr *msgToReplace, const char *attachment1_type, const char *attachment1_body, PRUint32 attachment1_body_length, const nsMsgAttachmentData *attachments, const nsMsgAttachedFile *preloaded_attachments, void *relatedPart, nsIDOMWindowInternal *parentWindow, nsIMsgProgress *progress, nsIMsgSendListener *aListener, const char *password, const nsACString & aOriginalMsgURI, MSG_ComposeType aType) = 0;

  /**
   * Sends a file to the specified composition fields, via the user identity
   * provided.
   *
   * @param aUserIdentity    The user identity to use for sending this email.
   * @param aAccountKey      The key of the account that this message relates
   *                         to.
   * @param aFields          An nsIMsgCompFields object containing information
   *                         on who to send the message to.
   * @param aSendIFile       A reference to the file to send.
   * @param aDeleteSendFileOnCompletion
   *                         Set to true if you want the send file deleted once
   *                         the message has been sent.
   * @param aDigest_p        If this is a multipart message, this param
   *                         specifies whether the message is in digest or mixed
   *                         format.
   * @param aMode            The delivery mode for sending the message (see
   *                         above for values).
   * @param aMsgToReplace    A message header representing a message to be
   *                         replaced by the one sent, this param may be null.
   * @param aListener        An nsIMsgSendListener to receive feedback on the
   *                         current send status. This parameter can also
   *                         support the nsIMsgCopyServiceListener interface to
   *                         receive notifications of copy finishing e.g. after
   *                         saving a message to the sent mail folder.
   *                         This param may be null.
   * @param aStatusFeedback  A feedback listener for slightly different feedback
   *                         on the message send status. This param may be null.
   * @param aPassword        Pass this in to prevent a dialog if the password
   *                         is needed for secure transmission.
   */
  /* void sendMessageFile (in nsIMsgIdentity aUserIdentity, in string aAccountKey, in nsIMsgCompFields aFields, in nsIFile aSendIFile, in PRBool aDeleteSendFileOnCompletion, in PRBool aDigest_p, in nsMsgDeliverMode aMode, in nsIMsgDBHdr aMsgToReplace, in nsIMsgSendListener aListener, in nsIMsgStatusFeedback aStatusFeedback, in string aPassword); */
  NS_SCRIPTABLE NS_IMETHOD SendMessageFile(nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *aFields, nsIFile *aSendIFile, PRBool aDeleteSendFileOnCompletion, PRBool aDigest_p, nsMsgDeliverMode aMode, nsIMsgDBHdr *aMsgToReplace, nsIMsgSendListener *aListener, nsIMsgStatusFeedback *aStatusFeedback, const char *aPassword) = 0;

  /* void abort (); */
  NS_SCRIPTABLE NS_IMETHOD Abort(void) = 0;

  /* nsresult fail (in nsresult failure_code, in wstring error_msg); */
  NS_SCRIPTABLE NS_IMETHOD Fail(nsresult failure_code, const PRUnichar *error_msg, nsresult *_retval NS_OUTPARAM) = 0;

  /* void setGUINotificationState (in PRBool aEnableFlag); */
  NS_SCRIPTABLE NS_IMETHOD SetGUINotificationState(PRBool aEnableFlag) = 0;

  /* void BeginCryptoEncapsulation (); */
  NS_SCRIPTABLE NS_IMETHOD BeginCryptoEncapsulation(void) = 0;

  /* readonly attribute nsIMsgSendReport sendReport; */
  NS_SCRIPTABLE NS_IMETHOD GetSendReport(nsIMsgSendReport **aSendReport) = 0;

  /* [noscript] void notifyListenerOnStartSending (in string aMsgID, in unsigned long aMsgSize); */
  NS_IMETHOD NotifyListenerOnStartSending(const char *aMsgID, PRUint32 aMsgSize) = 0;

  /* [noscript] void notifyListenerOnProgress (in string aMsgID, in unsigned long aProgress, in unsigned long aProgressMax); */
  NS_IMETHOD NotifyListenerOnProgress(const char *aMsgID, PRUint32 aProgress, PRUint32 aProgressMax) = 0;

  /* [noscript] void notifyListenerOnStatus (in string aMsgID, in wstring aMsg); */
  NS_IMETHOD NotifyListenerOnStatus(const char *aMsgID, const PRUnichar *aMsg) = 0;

  /* [noscript] void notifyListenerOnStopSending (in string aMsgID, in nsresult aStatus, in wstring aMsg, in nsIFile returnFile); */
  NS_IMETHOD NotifyListenerOnStopSending(const char *aMsgID, nsresult aStatus, const PRUnichar *aMsg, nsIFile *returnFile) = 0;

  /* [noscript] void deliverAsMailExit (in nsIURI aUrl, in nsresult aExitCode); */
  NS_IMETHOD DeliverAsMailExit(nsIURI *aUrl, nsresult aExitCode) = 0;

  /* [noscript] void deliverAsNewsExit (in nsIURI aUrl, in nsresult aExitCode); */
  NS_IMETHOD DeliverAsNewsExit(nsIURI *aUrl, nsresult aExitCode) = 0;

  /* [noscript] void sendDeliveryCallback (in nsIURI aUrl, in boolean inIsNewsDelivery, in nsresult aExitCode); */
  NS_IMETHOD SendDeliveryCallback(nsIURI *aUrl, PRBool inIsNewsDelivery, nsresult aExitCode) = 0;

  /* [noscript] void notifyListenerOnStartCopy (); */
  NS_IMETHOD NotifyListenerOnStartCopy(void) = 0;

  /* [noscript] void notifyListenerOnProgressCopy (in unsigned long aProgress, in unsigned long aProgressMax); */
  NS_IMETHOD NotifyListenerOnProgressCopy(PRUint32 aProgress, PRUint32 aProgressMax) = 0;

  /* [noscript] void notifyListenerOnStopCopy (in nsresult aStatus); */
  NS_IMETHOD NotifyListenerOnStopCopy(nsresult aStatus) = 0;

  /* void getMessageId (out ACString messageID); */
  NS_SCRIPTABLE NS_IMETHOD GetMessageId(nsACString & messageID NS_OUTPARAM) = 0;

  /* [noscript] attribute nsMsgKey messageKey; */
  NS_IMETHOD GetMessageKey(nsMsgKey *aMessageKey) = 0;
  NS_IMETHOD SetMessageKey(nsMsgKey aMessageKey) = 0;

  /* [noscript] nsIPrompt getDefaultPrompt (); */
  NS_IMETHOD GetDefaultPrompt(nsIPrompt **_retval NS_OUTPARAM) = 0;

  /* [noscript] void gatherMimeAttachments (); */
  NS_IMETHOD GatherMimeAttachments(void) = 0;

  /* [noscript] boolean getProcessAttachmentsSynchronously (); */
  NS_IMETHOD GetProcessAttachmentsSynchronously(PRBool *_retval NS_OUTPARAM) = 0;

  /* [noscript] nsMsgAttachmentHandler getAttachmentHandlers (); */
  NS_IMETHOD GetAttachmentHandlers(nsMsgAttachmentHandler **_retval NS_OUTPARAM) = 0;

  /* [noscript] readonly attribute unsigned long attachmentCount; */
  NS_IMETHOD GetAttachmentCount(PRUint32 *aAttachmentCount) = 0;

  /* [noscript] attribute unsigned long pendingAttachmentCount; */
  NS_IMETHOD GetPendingAttachmentCount(PRUint32 *aPendingAttachmentCount) = 0;
  NS_IMETHOD SetPendingAttachmentCount(PRUint32 aPendingAttachmentCount) = 0;

  /* [noscript] readonly attribute nsMsgDeliverMode deliveryMode; */
  NS_IMETHOD GetDeliveryMode(nsMsgDeliverMode *aDeliveryMode) = 0;

  /* [noscript] nsIMsgProgress getProgress (); */
  NS_IMETHOD GetProgress(nsIMsgProgress **_retval NS_OUTPARAM) = 0;

  /* nsIOutputStream getOutputStream (); */
  NS_SCRIPTABLE NS_IMETHOD GetOutputStream(nsIOutputStream **_retval NS_OUTPARAM) = 0;

  /* [noscript] attribute nsIRequest runningRequest; */
  NS_IMETHOD GetRunningRequest(nsIRequest **aRunningRequest) = 0;
  NS_IMETHOD SetRunningRequest(nsIRequest *aRunningRequest) = 0;

  /* [noscript] attribute nsresult status; */
  NS_IMETHOD GetStatus(nsresult *aStatus) = 0;
  NS_IMETHOD SetStatus(nsresult aStatus) = 0;

  /* [noscript] attribute nsIMsgComposeSecure cryptoclosure; */
  NS_IMETHOD GetCryptoclosure(nsIMsgComposeSecure **aCryptoclosure) = 0;
  NS_IMETHOD SetCryptoclosure(nsIMsgComposeSecure *aCryptoclosure) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgSend, NS_IMSGSEND_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGSEND \
  NS_IMETHOD CreateAndSendMessage(nsIEditor *aEditor, nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *fields, PRBool digest_p, PRBool dont_deliver_p, nsMsgDeliverMode mode, nsIMsgDBHdr *msgToReplace, const char *attachment1_type, const char *attachment1_body, PRUint32 attachment1_body_length, const nsMsgAttachmentData *attachments, const nsMsgAttachedFile *preloaded_attachments, void *relatedPart, nsIDOMWindowInternal *parentWindow, nsIMsgProgress *progress, nsIMsgSendListener *aListener, const char *password, const nsACString & aOriginalMsgURI, MSG_ComposeType aType); \
  NS_SCRIPTABLE NS_IMETHOD SendMessageFile(nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *aFields, nsIFile *aSendIFile, PRBool aDeleteSendFileOnCompletion, PRBool aDigest_p, nsMsgDeliverMode aMode, nsIMsgDBHdr *aMsgToReplace, nsIMsgSendListener *aListener, nsIMsgStatusFeedback *aStatusFeedback, const char *aPassword); \
  NS_SCRIPTABLE NS_IMETHOD Abort(void); \
  NS_SCRIPTABLE NS_IMETHOD Fail(nsresult failure_code, const PRUnichar *error_msg, nsresult *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetGUINotificationState(PRBool aEnableFlag); \
  NS_SCRIPTABLE NS_IMETHOD BeginCryptoEncapsulation(void); \
  NS_SCRIPTABLE NS_IMETHOD GetSendReport(nsIMsgSendReport **aSendReport); \
  NS_IMETHOD NotifyListenerOnStartSending(const char *aMsgID, PRUint32 aMsgSize); \
  NS_IMETHOD NotifyListenerOnProgress(const char *aMsgID, PRUint32 aProgress, PRUint32 aProgressMax); \
  NS_IMETHOD NotifyListenerOnStatus(const char *aMsgID, const PRUnichar *aMsg); \
  NS_IMETHOD NotifyListenerOnStopSending(const char *aMsgID, nsresult aStatus, const PRUnichar *aMsg, nsIFile *returnFile); \
  NS_IMETHOD DeliverAsMailExit(nsIURI *aUrl, nsresult aExitCode); \
  NS_IMETHOD DeliverAsNewsExit(nsIURI *aUrl, nsresult aExitCode); \
  NS_IMETHOD SendDeliveryCallback(nsIURI *aUrl, PRBool inIsNewsDelivery, nsresult aExitCode); \
  NS_IMETHOD NotifyListenerOnStartCopy(void); \
  NS_IMETHOD NotifyListenerOnProgressCopy(PRUint32 aProgress, PRUint32 aProgressMax); \
  NS_IMETHOD NotifyListenerOnStopCopy(nsresult aStatus); \
  NS_SCRIPTABLE NS_IMETHOD GetMessageId(nsACString & messageID NS_OUTPARAM); \
  NS_IMETHOD GetMessageKey(nsMsgKey *aMessageKey); \
  NS_IMETHOD SetMessageKey(nsMsgKey aMessageKey); \
  NS_IMETHOD GetDefaultPrompt(nsIPrompt **_retval NS_OUTPARAM); \
  NS_IMETHOD GatherMimeAttachments(void); \
  NS_IMETHOD GetProcessAttachmentsSynchronously(PRBool *_retval NS_OUTPARAM); \
  NS_IMETHOD GetAttachmentHandlers(nsMsgAttachmentHandler **_retval NS_OUTPARAM); \
  NS_IMETHOD GetAttachmentCount(PRUint32 *aAttachmentCount); \
  NS_IMETHOD GetPendingAttachmentCount(PRUint32 *aPendingAttachmentCount); \
  NS_IMETHOD SetPendingAttachmentCount(PRUint32 aPendingAttachmentCount); \
  NS_IMETHOD GetDeliveryMode(nsMsgDeliverMode *aDeliveryMode); \
  NS_IMETHOD GetProgress(nsIMsgProgress **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetOutputStream(nsIOutputStream **_retval NS_OUTPARAM); \
  NS_IMETHOD GetRunningRequest(nsIRequest **aRunningRequest); \
  NS_IMETHOD SetRunningRequest(nsIRequest *aRunningRequest); \
  NS_IMETHOD GetStatus(nsresult *aStatus); \
  NS_IMETHOD SetStatus(nsresult aStatus); \
  NS_IMETHOD GetCryptoclosure(nsIMsgComposeSecure **aCryptoclosure); \
  NS_IMETHOD SetCryptoclosure(nsIMsgComposeSecure *aCryptoclosure); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGSEND(_to) \
  NS_IMETHOD CreateAndSendMessage(nsIEditor *aEditor, nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *fields, PRBool digest_p, PRBool dont_deliver_p, nsMsgDeliverMode mode, nsIMsgDBHdr *msgToReplace, const char *attachment1_type, const char *attachment1_body, PRUint32 attachment1_body_length, const nsMsgAttachmentData *attachments, const nsMsgAttachedFile *preloaded_attachments, void *relatedPart, nsIDOMWindowInternal *parentWindow, nsIMsgProgress *progress, nsIMsgSendListener *aListener, const char *password, const nsACString & aOriginalMsgURI, MSG_ComposeType aType) { return _to CreateAndSendMessage(aEditor, aUserIdentity, aAccountKey, fields, digest_p, dont_deliver_p, mode, msgToReplace, attachment1_type, attachment1_body, attachment1_body_length, attachments, preloaded_attachments, relatedPart, parentWindow, progress, aListener, password, aOriginalMsgURI, aType); } \
  NS_SCRIPTABLE NS_IMETHOD SendMessageFile(nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *aFields, nsIFile *aSendIFile, PRBool aDeleteSendFileOnCompletion, PRBool aDigest_p, nsMsgDeliverMode aMode, nsIMsgDBHdr *aMsgToReplace, nsIMsgSendListener *aListener, nsIMsgStatusFeedback *aStatusFeedback, const char *aPassword) { return _to SendMessageFile(aUserIdentity, aAccountKey, aFields, aSendIFile, aDeleteSendFileOnCompletion, aDigest_p, aMode, aMsgToReplace, aListener, aStatusFeedback, aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD Abort(void) { return _to Abort(); } \
  NS_SCRIPTABLE NS_IMETHOD Fail(nsresult failure_code, const PRUnichar *error_msg, nsresult *_retval NS_OUTPARAM) { return _to Fail(failure_code, error_msg, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetGUINotificationState(PRBool aEnableFlag) { return _to SetGUINotificationState(aEnableFlag); } \
  NS_SCRIPTABLE NS_IMETHOD BeginCryptoEncapsulation(void) { return _to BeginCryptoEncapsulation(); } \
  NS_SCRIPTABLE NS_IMETHOD GetSendReport(nsIMsgSendReport **aSendReport) { return _to GetSendReport(aSendReport); } \
  NS_IMETHOD NotifyListenerOnStartSending(const char *aMsgID, PRUint32 aMsgSize) { return _to NotifyListenerOnStartSending(aMsgID, aMsgSize); } \
  NS_IMETHOD NotifyListenerOnProgress(const char *aMsgID, PRUint32 aProgress, PRUint32 aProgressMax) { return _to NotifyListenerOnProgress(aMsgID, aProgress, aProgressMax); } \
  NS_IMETHOD NotifyListenerOnStatus(const char *aMsgID, const PRUnichar *aMsg) { return _to NotifyListenerOnStatus(aMsgID, aMsg); } \
  NS_IMETHOD NotifyListenerOnStopSending(const char *aMsgID, nsresult aStatus, const PRUnichar *aMsg, nsIFile *returnFile) { return _to NotifyListenerOnStopSending(aMsgID, aStatus, aMsg, returnFile); } \
  NS_IMETHOD DeliverAsMailExit(nsIURI *aUrl, nsresult aExitCode) { return _to DeliverAsMailExit(aUrl, aExitCode); } \
  NS_IMETHOD DeliverAsNewsExit(nsIURI *aUrl, nsresult aExitCode) { return _to DeliverAsNewsExit(aUrl, aExitCode); } \
  NS_IMETHOD SendDeliveryCallback(nsIURI *aUrl, PRBool inIsNewsDelivery, nsresult aExitCode) { return _to SendDeliveryCallback(aUrl, inIsNewsDelivery, aExitCode); } \
  NS_IMETHOD NotifyListenerOnStartCopy(void) { return _to NotifyListenerOnStartCopy(); } \
  NS_IMETHOD NotifyListenerOnProgressCopy(PRUint32 aProgress, PRUint32 aProgressMax) { return _to NotifyListenerOnProgressCopy(aProgress, aProgressMax); } \
  NS_IMETHOD NotifyListenerOnStopCopy(nsresult aStatus) { return _to NotifyListenerOnStopCopy(aStatus); } \
  NS_SCRIPTABLE NS_IMETHOD GetMessageId(nsACString & messageID NS_OUTPARAM) { return _to GetMessageId(messageID); } \
  NS_IMETHOD GetMessageKey(nsMsgKey *aMessageKey) { return _to GetMessageKey(aMessageKey); } \
  NS_IMETHOD SetMessageKey(nsMsgKey aMessageKey) { return _to SetMessageKey(aMessageKey); } \
  NS_IMETHOD GetDefaultPrompt(nsIPrompt **_retval NS_OUTPARAM) { return _to GetDefaultPrompt(_retval); } \
  NS_IMETHOD GatherMimeAttachments(void) { return _to GatherMimeAttachments(); } \
  NS_IMETHOD GetProcessAttachmentsSynchronously(PRBool *_retval NS_OUTPARAM) { return _to GetProcessAttachmentsSynchronously(_retval); } \
  NS_IMETHOD GetAttachmentHandlers(nsMsgAttachmentHandler **_retval NS_OUTPARAM) { return _to GetAttachmentHandlers(_retval); } \
  NS_IMETHOD GetAttachmentCount(PRUint32 *aAttachmentCount) { return _to GetAttachmentCount(aAttachmentCount); } \
  NS_IMETHOD GetPendingAttachmentCount(PRUint32 *aPendingAttachmentCount) { return _to GetPendingAttachmentCount(aPendingAttachmentCount); } \
  NS_IMETHOD SetPendingAttachmentCount(PRUint32 aPendingAttachmentCount) { return _to SetPendingAttachmentCount(aPendingAttachmentCount); } \
  NS_IMETHOD GetDeliveryMode(nsMsgDeliverMode *aDeliveryMode) { return _to GetDeliveryMode(aDeliveryMode); } \
  NS_IMETHOD GetProgress(nsIMsgProgress **_retval NS_OUTPARAM) { return _to GetProgress(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetOutputStream(nsIOutputStream **_retval NS_OUTPARAM) { return _to GetOutputStream(_retval); } \
  NS_IMETHOD GetRunningRequest(nsIRequest **aRunningRequest) { return _to GetRunningRequest(aRunningRequest); } \
  NS_IMETHOD SetRunningRequest(nsIRequest *aRunningRequest) { return _to SetRunningRequest(aRunningRequest); } \
  NS_IMETHOD GetStatus(nsresult *aStatus) { return _to GetStatus(aStatus); } \
  NS_IMETHOD SetStatus(nsresult aStatus) { return _to SetStatus(aStatus); } \
  NS_IMETHOD GetCryptoclosure(nsIMsgComposeSecure **aCryptoclosure) { return _to GetCryptoclosure(aCryptoclosure); } \
  NS_IMETHOD SetCryptoclosure(nsIMsgComposeSecure *aCryptoclosure) { return _to SetCryptoclosure(aCryptoclosure); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGSEND(_to) \
  NS_IMETHOD CreateAndSendMessage(nsIEditor *aEditor, nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *fields, PRBool digest_p, PRBool dont_deliver_p, nsMsgDeliverMode mode, nsIMsgDBHdr *msgToReplace, const char *attachment1_type, const char *attachment1_body, PRUint32 attachment1_body_length, const nsMsgAttachmentData *attachments, const nsMsgAttachedFile *preloaded_attachments, void *relatedPart, nsIDOMWindowInternal *parentWindow, nsIMsgProgress *progress, nsIMsgSendListener *aListener, const char *password, const nsACString & aOriginalMsgURI, MSG_ComposeType aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAndSendMessage(aEditor, aUserIdentity, aAccountKey, fields, digest_p, dont_deliver_p, mode, msgToReplace, attachment1_type, attachment1_body, attachment1_body_length, attachments, preloaded_attachments, relatedPart, parentWindow, progress, aListener, password, aOriginalMsgURI, aType); } \
  NS_SCRIPTABLE NS_IMETHOD SendMessageFile(nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *aFields, nsIFile *aSendIFile, PRBool aDeleteSendFileOnCompletion, PRBool aDigest_p, nsMsgDeliverMode aMode, nsIMsgDBHdr *aMsgToReplace, nsIMsgSendListener *aListener, nsIMsgStatusFeedback *aStatusFeedback, const char *aPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->SendMessageFile(aUserIdentity, aAccountKey, aFields, aSendIFile, aDeleteSendFileOnCompletion, aDigest_p, aMode, aMsgToReplace, aListener, aStatusFeedback, aPassword); } \
  NS_SCRIPTABLE NS_IMETHOD Abort(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Abort(); } \
  NS_SCRIPTABLE NS_IMETHOD Fail(nsresult failure_code, const PRUnichar *error_msg, nsresult *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->Fail(failure_code, error_msg, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetGUINotificationState(PRBool aEnableFlag) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetGUINotificationState(aEnableFlag); } \
  NS_SCRIPTABLE NS_IMETHOD BeginCryptoEncapsulation(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->BeginCryptoEncapsulation(); } \
  NS_SCRIPTABLE NS_IMETHOD GetSendReport(nsIMsgSendReport **aSendReport) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSendReport(aSendReport); } \
  NS_IMETHOD NotifyListenerOnStartSending(const char *aMsgID, PRUint32 aMsgSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnStartSending(aMsgID, aMsgSize); } \
  NS_IMETHOD NotifyListenerOnProgress(const char *aMsgID, PRUint32 aProgress, PRUint32 aProgressMax) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnProgress(aMsgID, aProgress, aProgressMax); } \
  NS_IMETHOD NotifyListenerOnStatus(const char *aMsgID, const PRUnichar *aMsg) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnStatus(aMsgID, aMsg); } \
  NS_IMETHOD NotifyListenerOnStopSending(const char *aMsgID, nsresult aStatus, const PRUnichar *aMsg, nsIFile *returnFile) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnStopSending(aMsgID, aStatus, aMsg, returnFile); } \
  NS_IMETHOD DeliverAsMailExit(nsIURI *aUrl, nsresult aExitCode) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeliverAsMailExit(aUrl, aExitCode); } \
  NS_IMETHOD DeliverAsNewsExit(nsIURI *aUrl, nsresult aExitCode) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeliverAsNewsExit(aUrl, aExitCode); } \
  NS_IMETHOD SendDeliveryCallback(nsIURI *aUrl, PRBool inIsNewsDelivery, nsresult aExitCode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SendDeliveryCallback(aUrl, inIsNewsDelivery, aExitCode); } \
  NS_IMETHOD NotifyListenerOnStartCopy(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnStartCopy(); } \
  NS_IMETHOD NotifyListenerOnProgressCopy(PRUint32 aProgress, PRUint32 aProgressMax) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnProgressCopy(aProgress, aProgressMax); } \
  NS_IMETHOD NotifyListenerOnStopCopy(nsresult aStatus) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyListenerOnStopCopy(aStatus); } \
  NS_SCRIPTABLE NS_IMETHOD GetMessageId(nsACString & messageID NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessageId(messageID); } \
  NS_IMETHOD GetMessageKey(nsMsgKey *aMessageKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessageKey(aMessageKey); } \
  NS_IMETHOD SetMessageKey(nsMsgKey aMessageKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMessageKey(aMessageKey); } \
  NS_IMETHOD GetDefaultPrompt(nsIPrompt **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultPrompt(_retval); } \
  NS_IMETHOD GatherMimeAttachments(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->GatherMimeAttachments(); } \
  NS_IMETHOD GetProcessAttachmentsSynchronously(PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProcessAttachmentsSynchronously(_retval); } \
  NS_IMETHOD GetAttachmentHandlers(nsMsgAttachmentHandler **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttachmentHandlers(_retval); } \
  NS_IMETHOD GetAttachmentCount(PRUint32 *aAttachmentCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttachmentCount(aAttachmentCount); } \
  NS_IMETHOD GetPendingAttachmentCount(PRUint32 *aPendingAttachmentCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPendingAttachmentCount(aPendingAttachmentCount); } \
  NS_IMETHOD SetPendingAttachmentCount(PRUint32 aPendingAttachmentCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPendingAttachmentCount(aPendingAttachmentCount); } \
  NS_IMETHOD GetDeliveryMode(nsMsgDeliverMode *aDeliveryMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDeliveryMode(aDeliveryMode); } \
  NS_IMETHOD GetProgress(nsIMsgProgress **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProgress(_retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetOutputStream(nsIOutputStream **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOutputStream(_retval); } \
  NS_IMETHOD GetRunningRequest(nsIRequest **aRunningRequest) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRunningRequest(aRunningRequest); } \
  NS_IMETHOD SetRunningRequest(nsIRequest *aRunningRequest) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRunningRequest(aRunningRequest); } \
  NS_IMETHOD GetStatus(nsresult *aStatus) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStatus(aStatus); } \
  NS_IMETHOD SetStatus(nsresult aStatus) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStatus(aStatus); } \
  NS_IMETHOD GetCryptoclosure(nsIMsgComposeSecure **aCryptoclosure) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCryptoclosure(aCryptoclosure); } \
  NS_IMETHOD SetCryptoclosure(nsIMsgComposeSecure *aCryptoclosure) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCryptoclosure(aCryptoclosure); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgSend : public nsIMsgSend
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGSEND

  nsMsgSend();

private:
  ~nsMsgSend();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgSend, nsIMsgSend)

nsMsgSend::nsMsgSend()
{
  /* member initializers and constructor code */
}

nsMsgSend::~nsMsgSend()
{
  /* destructor code */
}

/* [noscript] void createAndSendMessage (in nsIEditor aEditor, in nsIMsgIdentity aUserIdentity, in string aAccountKey, in nsIMsgCompFields fields, in PRBool digest_p, in PRBool dont_deliver_p, in nsMsgDeliverMode mode, in nsIMsgDBHdr msgToReplace, in string attachment1_type, in string attachment1_body, in PRUint32 attachment1_body_length, [const] in nsMsgAttachmentData attachments, [const] in nsMsgAttachedFile preloaded_attachments, in voidPtr relatedPart, in nsIDOMWindowInternal parentWindow, in nsIMsgProgress progress, in nsIMsgSendListener aListener, in string password, in AUTF8String aOriginalMsgURI, in MSG_ComposeType aType); */
NS_IMETHODIMP nsMsgSend::CreateAndSendMessage(nsIEditor *aEditor, nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *fields, PRBool digest_p, PRBool dont_deliver_p, nsMsgDeliverMode mode, nsIMsgDBHdr *msgToReplace, const char *attachment1_type, const char *attachment1_body, PRUint32 attachment1_body_length, const nsMsgAttachmentData *attachments, const nsMsgAttachedFile *preloaded_attachments, void *relatedPart, nsIDOMWindowInternal *parentWindow, nsIMsgProgress *progress, nsIMsgSendListener *aListener, const char *password, const nsACString & aOriginalMsgURI, MSG_ComposeType aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void sendMessageFile (in nsIMsgIdentity aUserIdentity, in string aAccountKey, in nsIMsgCompFields aFields, in nsIFile aSendIFile, in PRBool aDeleteSendFileOnCompletion, in PRBool aDigest_p, in nsMsgDeliverMode aMode, in nsIMsgDBHdr aMsgToReplace, in nsIMsgSendListener aListener, in nsIMsgStatusFeedback aStatusFeedback, in string aPassword); */
NS_IMETHODIMP nsMsgSend::SendMessageFile(nsIMsgIdentity *aUserIdentity, const char *aAccountKey, nsIMsgCompFields *aFields, nsIFile *aSendIFile, PRBool aDeleteSendFileOnCompletion, PRBool aDigest_p, nsMsgDeliverMode aMode, nsIMsgDBHdr *aMsgToReplace, nsIMsgSendListener *aListener, nsIMsgStatusFeedback *aStatusFeedback, const char *aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void abort (); */
NS_IMETHODIMP nsMsgSend::Abort()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsresult fail (in nsresult failure_code, in wstring error_msg); */
NS_IMETHODIMP nsMsgSend::Fail(nsresult failure_code, const PRUnichar *error_msg, nsresult *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setGUINotificationState (in PRBool aEnableFlag); */
NS_IMETHODIMP nsMsgSend::SetGUINotificationState(PRBool aEnableFlag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void BeginCryptoEncapsulation (); */
NS_IMETHODIMP nsMsgSend::BeginCryptoEncapsulation()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgSendReport sendReport; */
NS_IMETHODIMP nsMsgSend::GetSendReport(nsIMsgSendReport **aSendReport)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnStartSending (in string aMsgID, in unsigned long aMsgSize); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnStartSending(const char *aMsgID, PRUint32 aMsgSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnProgress (in string aMsgID, in unsigned long aProgress, in unsigned long aProgressMax); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnProgress(const char *aMsgID, PRUint32 aProgress, PRUint32 aProgressMax)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnStatus (in string aMsgID, in wstring aMsg); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnStatus(const char *aMsgID, const PRUnichar *aMsg)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnStopSending (in string aMsgID, in nsresult aStatus, in wstring aMsg, in nsIFile returnFile); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnStopSending(const char *aMsgID, nsresult aStatus, const PRUnichar *aMsg, nsIFile *returnFile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void deliverAsMailExit (in nsIURI aUrl, in nsresult aExitCode); */
NS_IMETHODIMP nsMsgSend::DeliverAsMailExit(nsIURI *aUrl, nsresult aExitCode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void deliverAsNewsExit (in nsIURI aUrl, in nsresult aExitCode); */
NS_IMETHODIMP nsMsgSend::DeliverAsNewsExit(nsIURI *aUrl, nsresult aExitCode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void sendDeliveryCallback (in nsIURI aUrl, in boolean inIsNewsDelivery, in nsresult aExitCode); */
NS_IMETHODIMP nsMsgSend::SendDeliveryCallback(nsIURI *aUrl, PRBool inIsNewsDelivery, nsresult aExitCode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnStartCopy (); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnStartCopy()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnProgressCopy (in unsigned long aProgress, in unsigned long aProgressMax); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnProgressCopy(PRUint32 aProgress, PRUint32 aProgressMax)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void notifyListenerOnStopCopy (in nsresult aStatus); */
NS_IMETHODIMP nsMsgSend::NotifyListenerOnStopCopy(nsresult aStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getMessageId (out ACString messageID); */
NS_IMETHODIMP nsMsgSend::GetMessageId(nsACString & messageID NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] attribute nsMsgKey messageKey; */
NS_IMETHODIMP nsMsgSend::GetMessageKey(nsMsgKey *aMessageKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgSend::SetMessageKey(nsMsgKey aMessageKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] nsIPrompt getDefaultPrompt (); */
NS_IMETHODIMP nsMsgSend::GetDefaultPrompt(nsIPrompt **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void gatherMimeAttachments (); */
NS_IMETHODIMP nsMsgSend::GatherMimeAttachments()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] boolean getProcessAttachmentsSynchronously (); */
NS_IMETHODIMP nsMsgSend::GetProcessAttachmentsSynchronously(PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] nsMsgAttachmentHandler getAttachmentHandlers (); */
NS_IMETHODIMP nsMsgSend::GetAttachmentHandlers(nsMsgAttachmentHandler **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] readonly attribute unsigned long attachmentCount; */
NS_IMETHODIMP nsMsgSend::GetAttachmentCount(PRUint32 *aAttachmentCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] attribute unsigned long pendingAttachmentCount; */
NS_IMETHODIMP nsMsgSend::GetPendingAttachmentCount(PRUint32 *aPendingAttachmentCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgSend::SetPendingAttachmentCount(PRUint32 aPendingAttachmentCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] readonly attribute nsMsgDeliverMode deliveryMode; */
NS_IMETHODIMP nsMsgSend::GetDeliveryMode(nsMsgDeliverMode *aDeliveryMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] nsIMsgProgress getProgress (); */
NS_IMETHODIMP nsMsgSend::GetProgress(nsIMsgProgress **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIOutputStream getOutputStream (); */
NS_IMETHODIMP nsMsgSend::GetOutputStream(nsIOutputStream **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] attribute nsIRequest runningRequest; */
NS_IMETHODIMP nsMsgSend::GetRunningRequest(nsIRequest **aRunningRequest)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgSend::SetRunningRequest(nsIRequest *aRunningRequest)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] attribute nsresult status; */
NS_IMETHODIMP nsMsgSend::GetStatus(nsresult *aStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgSend::SetStatus(nsresult aStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] attribute nsIMsgComposeSecure cryptoclosure; */
NS_IMETHODIMP nsMsgSend::GetCryptoclosure(nsIMsgComposeSecure **aCryptoclosure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgSend::SetCryptoclosure(nsIMsgComposeSecure *aCryptoclosure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgSend_h__ */
