/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgIdentity.idl
 */

#ifndef __gen_nsIMsgIdentity_h__
#define __gen_nsIMsgIdentity_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsILocalFile_h__
#include "nsILocalFile.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIMsgIdentity */
#define NS_IMSGIDENTITY_IID_STR "033bddfe-9727-11de-848a-00c09fcbe317"

#define NS_IMSGIDENTITY_IID \
  {0x033bddfe, 0x9727, 0x11de, \
    { 0x84, 0x8a, 0x00, 0xc0, 0x9f, 0xcb, 0xe3, 0x17 }}

/**
 * This interface contains all the personal outgoing mail information
 * for a given person.
 * Each identity is identified by a key, which is the <id> string in
 * the identity preferences, such as in mail.identity.<id>.replyTo.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgIdentity : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGIDENTITY_IID)

  /**
   * Internal preferences ID.
   */
  /* attribute ACString key; */
  NS_SCRIPTABLE NS_IMETHOD GetKey(nsACString & aKey) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetKey(const nsACString & aKey) = 0;

  /**
   * Overriding display name for this identity. If this pref is not set
   * then this will return some composed string from the fullname and email.
   */
  /* attribute AString identityName; */
  NS_SCRIPTABLE NS_IMETHOD GetIdentityName(nsAString & aIdentityName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetIdentityName(const nsAString & aIdentityName) = 0;

  /**
   * User's full name, i.e. John Doe.
   */
  /* attribute AString fullName; */
  NS_SCRIPTABLE NS_IMETHOD GetFullName(nsAString & aFullName) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFullName(const nsAString & aFullName) = 0;

  /**
   * User's e-mail address, i.e. john@doe.com.
   */
  /* attribute ACString email; */
  NS_SCRIPTABLE NS_IMETHOD GetEmail(nsACString & aEmail) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetEmail(const nsACString & aEmail) = 0;

  /**
   * Optional replyTo address, i.e. johnNOSPAM@doe.com.
   */
  /* attribute ACString replyTo; */
  NS_SCRIPTABLE NS_IMETHOD GetReplyTo(nsACString & aReplyTo) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetReplyTo(const nsACString & aReplyTo) = 0;

  /**
   * Optional organization.
   */
  /* attribute AString organization; */
  NS_SCRIPTABLE NS_IMETHOD GetOrganization(nsAString & aOrganization) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetOrganization(const nsAString & aOrganization) = 0;

  /**
   * Should we compose with HTML by default?
   */
  /* attribute boolean composeHtml; */
  NS_SCRIPTABLE NS_IMETHOD GetComposeHtml(PRBool *aComposeHtml) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetComposeHtml(PRBool aComposeHtml) = 0;

  /**
   * Should we attach a signature from file?
   */
  /* attribute boolean attachSignature; */
  NS_SCRIPTABLE NS_IMETHOD GetAttachSignature(PRBool *aAttachSignature) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAttachSignature(PRBool aAttachSignature) = 0;

  /**
   * Should we attach a vcard by default?
   */
  /* attribute boolean attachVCard; */
  NS_SCRIPTABLE NS_IMETHOD GetAttachVCard(PRBool *aAttachVCard) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAttachVCard(PRBool aAttachVCard) = 0;

  /**
   * Should we automatically quote the original message?
   */
  /* attribute boolean autoQuote; */
  NS_SCRIPTABLE NS_IMETHOD GetAutoQuote(PRBool *aAutoQuote) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAutoQuote(PRBool aAutoQuote) = 0;

  /**
   * What should our quoting preference be?
   */
  /* attribute long replyOnTop; */
  NS_SCRIPTABLE NS_IMETHOD GetReplyOnTop(PRInt32 *aReplyOnTop) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetReplyOnTop(PRInt32 aReplyOnTop) = 0;

  /**
   * Should our signature be at the end of the quoted text when replying
   * above it?
   */
  /* attribute boolean sigBottom; */
  NS_SCRIPTABLE NS_IMETHOD GetSigBottom(PRBool *aSigBottom) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSigBottom(PRBool aSigBottom) = 0;

  /**
   * Include a signature when forwarding a message?
   */
  /* attribute boolean sigOnForward; */
  NS_SCRIPTABLE NS_IMETHOD GetSigOnForward(PRBool *aSigOnForward) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSigOnForward(PRBool aSigOnForward) = 0;

  /**
   * Include a signature when replying to a message?
   */
  /* attribute boolean sigOnReply; */
  NS_SCRIPTABLE NS_IMETHOD GetSigOnReply(PRBool *aSigOnReply) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSigOnReply(PRBool aSigOnReply) = 0;

  /**
   * The current signature file.
   */
  /* attribute nsILocalFile signature; */
  NS_SCRIPTABLE NS_IMETHOD GetSignature(nsILocalFile **aSignature) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSignature(nsILocalFile *aSignature) = 0;

  /**
   * Modification time of the signature file.
   */
  /* attribute long signatureDate; */
  NS_SCRIPTABLE NS_IMETHOD GetSignatureDate(PRInt32 *aSignatureDate) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSignatureDate(PRInt32 aSignatureDate) = 0;

  /**
   * Signature text if not read from file; format depends on htmlSigFormat.
   */
  /* attribute AString htmlSigText; */
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigText(nsAString & aHtmlSigText) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigText(const nsAString & aHtmlSigText) = 0;

  /**
   * Does htmlSigText contain HTML? Use plain text if false.
   */
  /* attribute boolean htmlSigFormat; */
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigFormat(PRBool *aHtmlSigFormat) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigFormat(PRBool aHtmlSigFormat) = 0;

  /**
   * The encoded string representing the vcard.
   */
  /* attribute ACString escapedVCard; */
  NS_SCRIPTABLE NS_IMETHOD GetEscapedVCard(nsACString & aEscapedVCard) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetEscapedVCard(const nsACString & aEscapedVCard) = 0;

  /* attribute boolean doFcc; */
  NS_SCRIPTABLE NS_IMETHOD GetDoFcc(PRBool *aDoFcc) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDoFcc(PRBool aDoFcc) = 0;

  /* attribute ACString fccFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetFccFolder(nsACString & aFccFolder) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFccFolder(const nsACString & aFccFolder) = 0;

  /* attribute boolean fccReplyFollowsParent; */
  NS_SCRIPTABLE NS_IMETHOD GetFccReplyFollowsParent(PRBool *aFccReplyFollowsParent) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFccReplyFollowsParent(PRBool aFccReplyFollowsParent) = 0;

  /**
   * @{
   * these attributes control whether the special folder pickers for
   * fcc, drafts,archives, and templates are set to pick between servers
   * (e.g., Sent on accountName) or to pick any folder on any account.
   * "0" means choose between servers; "1" means use the full folder picker.
   */
  /* attribute ACString fccFolderPickerMode; */
  NS_SCRIPTABLE NS_IMETHOD GetFccFolderPickerMode(nsACString & aFccFolderPickerMode) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetFccFolderPickerMode(const nsACString & aFccFolderPickerMode) = 0;

  /* attribute ACString draftsFolderPickerMode; */
  NS_SCRIPTABLE NS_IMETHOD GetDraftsFolderPickerMode(nsACString & aDraftsFolderPickerMode) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDraftsFolderPickerMode(const nsACString & aDraftsFolderPickerMode) = 0;

  /* attribute ACString archivesFolderPickerMode; */
  NS_SCRIPTABLE NS_IMETHOD GetArchivesFolderPickerMode(nsACString & aArchivesFolderPickerMode) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetArchivesFolderPickerMode(const nsACString & aArchivesFolderPickerMode) = 0;

  /* attribute ACString tmplFolderPickerMode; */
  NS_SCRIPTABLE NS_IMETHOD GetTmplFolderPickerMode(nsACString & aTmplFolderPickerMode) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetTmplFolderPickerMode(const nsACString & aTmplFolderPickerMode) = 0;

  /** @} */
  /* attribute boolean bccSelf; */
  NS_SCRIPTABLE NS_IMETHOD GetBccSelf(PRBool *aBccSelf) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetBccSelf(PRBool aBccSelf) = 0;

  /* attribute boolean bccOthers; */
  NS_SCRIPTABLE NS_IMETHOD GetBccOthers(PRBool *aBccOthers) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetBccOthers(PRBool aBccOthers) = 0;

  /* attribute ACString bccList; */
  NS_SCRIPTABLE NS_IMETHOD GetBccList(nsACString & aBccList) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetBccList(const nsACString & aBccList) = 0;

  /* attribute boolean doCc; */
  NS_SCRIPTABLE NS_IMETHOD GetDoCc(PRBool *aDoCc) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDoCc(PRBool aDoCc) = 0;

  /* attribute ACString doCcList; */
  NS_SCRIPTABLE NS_IMETHOD GetDoCcList(nsACString & aDoCcList) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDoCcList(const nsACString & aDoCcList) = 0;

  /* attribute boolean doBcc; */
  NS_SCRIPTABLE NS_IMETHOD GetDoBcc(PRBool *aDoBcc) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDoBcc(PRBool aDoBcc) = 0;

  /* attribute ACString doBccList; */
  NS_SCRIPTABLE NS_IMETHOD GetDoBccList(nsACString & aDoBccList) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDoBccList(const nsACString & aDoBccList) = 0;

  /**
   * @{
   * URIs for the special folders (drafts, templates, archive)
   */
  /* attribute ACString draftFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetDraftFolder(nsACString & aDraftFolder) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDraftFolder(const nsACString & aDraftFolder) = 0;

  /* attribute ACString archiveFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetArchiveFolder(nsACString & aArchiveFolder) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetArchiveFolder(const nsACString & aArchiveFolder) = 0;

  /* attribute ACString stationeryFolder; */
  NS_SCRIPTABLE NS_IMETHOD GetStationeryFolder(nsACString & aStationeryFolder) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetStationeryFolder(const nsACString & aStationeryFolder) = 0;

  /** @} */
  /* attribute boolean showSaveMsgDlg; */
  NS_SCRIPTABLE NS_IMETHOD GetShowSaveMsgDlg(PRBool *aShowSaveMsgDlg) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetShowSaveMsgDlg(PRBool aShowSaveMsgDlg) = 0;

  /* attribute ACString directoryServer; */
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryServer(nsACString & aDirectoryServer) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryServer(const nsACString & aDirectoryServer) = 0;

  /* attribute boolean overrideGlobalPref; */
  NS_SCRIPTABLE NS_IMETHOD GetOverrideGlobalPref(PRBool *aOverrideGlobalPref) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetOverrideGlobalPref(PRBool aOverrideGlobalPref) = 0;

  /**
   * If this is false, don't append the user's domain
   * to an autocomplete address with no matches
   */
  /* attribute boolean autocompleteToMyDomain; */
  NS_SCRIPTABLE NS_IMETHOD GetAutocompleteToMyDomain(PRBool *aAutocompleteToMyDomain) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetAutocompleteToMyDomain(PRBool aAutocompleteToMyDomain) = 0;

  /**
   * valid determines if the UI should use this identity
   * and the wizard uses this to determine whether or not
   * to ask the user to complete all the fields
   */
  /* attribute boolean valid; */
  NS_SCRIPTABLE NS_IMETHOD GetValid(PRBool *aValid) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetValid(PRBool aValid) = 0;

  /**
   * this is really dangerous. this destroys all pref values
   * do not call this unless you know what you're doing!
   */
  /* void clearAllValues (); */
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void) = 0;

  /**
   * the preferred smtp server for this identity.
   * if this is set, this the smtp server that should be used
   * for the message send
   */
  /* attribute ACString smtpServerKey; */
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerKey(nsACString & aSmtpServerKey) = 0;
  NS_SCRIPTABLE NS_IMETHOD SetSmtpServerKey(const nsACString & aSmtpServerKey) = 0;

  /**
   * default request for return receipt option for this identity
   * if this is set, the Return Receipt menu item on the compose
   * window will be checked
   */
  /* readonly attribute boolean requestReturnReceipt; */
  NS_SCRIPTABLE NS_IMETHOD GetRequestReturnReceipt(PRBool *aRequestReturnReceipt) = 0;

  /* readonly attribute long receiptHeaderType; */
  NS_SCRIPTABLE NS_IMETHOD GetReceiptHeaderType(PRInt32 *aReceiptHeaderType) = 0;

  /**
   * default request for DSN option for this identity
   * if this is set, the DSN menu item on the compose
   * window will be checked
   */
  /* readonly attribute boolean requestDSN; */
  NS_SCRIPTABLE NS_IMETHOD GetRequestDSN(PRBool *aRequestDSN) = 0;

  /* void copy (in nsIMsgIdentity identity); */
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIMsgIdentity *identity) = 0;

  /** 
   * these generic getter / setters, useful for extending mailnews 
   * note, these attributes persist across sessions
   */
  /* AString getUnicharAttribute (in string name); */
  NS_SCRIPTABLE NS_IMETHOD GetUnicharAttribute(const char *name, nsAString & _retval NS_OUTPARAM) = 0;

  /* void setUnicharAttribute (in string name, in AString value); */
  NS_SCRIPTABLE NS_IMETHOD SetUnicharAttribute(const char *name, const nsAString & value) = 0;

  /* ACString getCharAttribute (in string name); */
  NS_SCRIPTABLE NS_IMETHOD GetCharAttribute(const char *name, nsACString & _retval NS_OUTPARAM) = 0;

  /* void setCharAttribute (in string name, in ACString value); */
  NS_SCRIPTABLE NS_IMETHOD SetCharAttribute(const char *name, const nsACString & value) = 0;

  /* boolean getBoolAttribute (in string name); */
  NS_SCRIPTABLE NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval NS_OUTPARAM) = 0;

  /* void setBoolAttribute (in string name, in boolean value); */
  NS_SCRIPTABLE NS_IMETHOD SetBoolAttribute(const char *name, PRBool value) = 0;

  /* long getIntAttribute (in string name); */
  NS_SCRIPTABLE NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval NS_OUTPARAM) = 0;

  /* void setIntAttribute (in string name, in long value); */
  NS_SCRIPTABLE NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value) = 0;

  /* AString toString (); */
  NS_SCRIPTABLE NS_IMETHOD ToString(nsAString & _retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgIdentity, NS_IMSGIDENTITY_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGIDENTITY \
  NS_SCRIPTABLE NS_IMETHOD GetKey(nsACString & aKey); \
  NS_SCRIPTABLE NS_IMETHOD SetKey(const nsACString & aKey); \
  NS_SCRIPTABLE NS_IMETHOD GetIdentityName(nsAString & aIdentityName); \
  NS_SCRIPTABLE NS_IMETHOD SetIdentityName(const nsAString & aIdentityName); \
  NS_SCRIPTABLE NS_IMETHOD GetFullName(nsAString & aFullName); \
  NS_SCRIPTABLE NS_IMETHOD SetFullName(const nsAString & aFullName); \
  NS_SCRIPTABLE NS_IMETHOD GetEmail(nsACString & aEmail); \
  NS_SCRIPTABLE NS_IMETHOD SetEmail(const nsACString & aEmail); \
  NS_SCRIPTABLE NS_IMETHOD GetReplyTo(nsACString & aReplyTo); \
  NS_SCRIPTABLE NS_IMETHOD SetReplyTo(const nsACString & aReplyTo); \
  NS_SCRIPTABLE NS_IMETHOD GetOrganization(nsAString & aOrganization); \
  NS_SCRIPTABLE NS_IMETHOD SetOrganization(const nsAString & aOrganization); \
  NS_SCRIPTABLE NS_IMETHOD GetComposeHtml(PRBool *aComposeHtml); \
  NS_SCRIPTABLE NS_IMETHOD SetComposeHtml(PRBool aComposeHtml); \
  NS_SCRIPTABLE NS_IMETHOD GetAttachSignature(PRBool *aAttachSignature); \
  NS_SCRIPTABLE NS_IMETHOD SetAttachSignature(PRBool aAttachSignature); \
  NS_SCRIPTABLE NS_IMETHOD GetAttachVCard(PRBool *aAttachVCard); \
  NS_SCRIPTABLE NS_IMETHOD SetAttachVCard(PRBool aAttachVCard); \
  NS_SCRIPTABLE NS_IMETHOD GetAutoQuote(PRBool *aAutoQuote); \
  NS_SCRIPTABLE NS_IMETHOD SetAutoQuote(PRBool aAutoQuote); \
  NS_SCRIPTABLE NS_IMETHOD GetReplyOnTop(PRInt32 *aReplyOnTop); \
  NS_SCRIPTABLE NS_IMETHOD SetReplyOnTop(PRInt32 aReplyOnTop); \
  NS_SCRIPTABLE NS_IMETHOD GetSigBottom(PRBool *aSigBottom); \
  NS_SCRIPTABLE NS_IMETHOD SetSigBottom(PRBool aSigBottom); \
  NS_SCRIPTABLE NS_IMETHOD GetSigOnForward(PRBool *aSigOnForward); \
  NS_SCRIPTABLE NS_IMETHOD SetSigOnForward(PRBool aSigOnForward); \
  NS_SCRIPTABLE NS_IMETHOD GetSigOnReply(PRBool *aSigOnReply); \
  NS_SCRIPTABLE NS_IMETHOD SetSigOnReply(PRBool aSigOnReply); \
  NS_SCRIPTABLE NS_IMETHOD GetSignature(nsILocalFile **aSignature); \
  NS_SCRIPTABLE NS_IMETHOD SetSignature(nsILocalFile *aSignature); \
  NS_SCRIPTABLE NS_IMETHOD GetSignatureDate(PRInt32 *aSignatureDate); \
  NS_SCRIPTABLE NS_IMETHOD SetSignatureDate(PRInt32 aSignatureDate); \
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigText(nsAString & aHtmlSigText); \
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigText(const nsAString & aHtmlSigText); \
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigFormat(PRBool *aHtmlSigFormat); \
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigFormat(PRBool aHtmlSigFormat); \
  NS_SCRIPTABLE NS_IMETHOD GetEscapedVCard(nsACString & aEscapedVCard); \
  NS_SCRIPTABLE NS_IMETHOD SetEscapedVCard(const nsACString & aEscapedVCard); \
  NS_SCRIPTABLE NS_IMETHOD GetDoFcc(PRBool *aDoFcc); \
  NS_SCRIPTABLE NS_IMETHOD SetDoFcc(PRBool aDoFcc); \
  NS_SCRIPTABLE NS_IMETHOD GetFccFolder(nsACString & aFccFolder); \
  NS_SCRIPTABLE NS_IMETHOD SetFccFolder(const nsACString & aFccFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetFccReplyFollowsParent(PRBool *aFccReplyFollowsParent); \
  NS_SCRIPTABLE NS_IMETHOD SetFccReplyFollowsParent(PRBool aFccReplyFollowsParent); \
  NS_SCRIPTABLE NS_IMETHOD GetFccFolderPickerMode(nsACString & aFccFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD SetFccFolderPickerMode(const nsACString & aFccFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD GetDraftsFolderPickerMode(nsACString & aDraftsFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD SetDraftsFolderPickerMode(const nsACString & aDraftsFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD GetArchivesFolderPickerMode(nsACString & aArchivesFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD SetArchivesFolderPickerMode(const nsACString & aArchivesFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD GetTmplFolderPickerMode(nsACString & aTmplFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD SetTmplFolderPickerMode(const nsACString & aTmplFolderPickerMode); \
  NS_SCRIPTABLE NS_IMETHOD GetBccSelf(PRBool *aBccSelf); \
  NS_SCRIPTABLE NS_IMETHOD SetBccSelf(PRBool aBccSelf); \
  NS_SCRIPTABLE NS_IMETHOD GetBccOthers(PRBool *aBccOthers); \
  NS_SCRIPTABLE NS_IMETHOD SetBccOthers(PRBool aBccOthers); \
  NS_SCRIPTABLE NS_IMETHOD GetBccList(nsACString & aBccList); \
  NS_SCRIPTABLE NS_IMETHOD SetBccList(const nsACString & aBccList); \
  NS_SCRIPTABLE NS_IMETHOD GetDoCc(PRBool *aDoCc); \
  NS_SCRIPTABLE NS_IMETHOD SetDoCc(PRBool aDoCc); \
  NS_SCRIPTABLE NS_IMETHOD GetDoCcList(nsACString & aDoCcList); \
  NS_SCRIPTABLE NS_IMETHOD SetDoCcList(const nsACString & aDoCcList); \
  NS_SCRIPTABLE NS_IMETHOD GetDoBcc(PRBool *aDoBcc); \
  NS_SCRIPTABLE NS_IMETHOD SetDoBcc(PRBool aDoBcc); \
  NS_SCRIPTABLE NS_IMETHOD GetDoBccList(nsACString & aDoBccList); \
  NS_SCRIPTABLE NS_IMETHOD SetDoBccList(const nsACString & aDoBccList); \
  NS_SCRIPTABLE NS_IMETHOD GetDraftFolder(nsACString & aDraftFolder); \
  NS_SCRIPTABLE NS_IMETHOD SetDraftFolder(const nsACString & aDraftFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetArchiveFolder(nsACString & aArchiveFolder); \
  NS_SCRIPTABLE NS_IMETHOD SetArchiveFolder(const nsACString & aArchiveFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetStationeryFolder(nsACString & aStationeryFolder); \
  NS_SCRIPTABLE NS_IMETHOD SetStationeryFolder(const nsACString & aStationeryFolder); \
  NS_SCRIPTABLE NS_IMETHOD GetShowSaveMsgDlg(PRBool *aShowSaveMsgDlg); \
  NS_SCRIPTABLE NS_IMETHOD SetShowSaveMsgDlg(PRBool aShowSaveMsgDlg); \
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryServer(nsACString & aDirectoryServer); \
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryServer(const nsACString & aDirectoryServer); \
  NS_SCRIPTABLE NS_IMETHOD GetOverrideGlobalPref(PRBool *aOverrideGlobalPref); \
  NS_SCRIPTABLE NS_IMETHOD SetOverrideGlobalPref(PRBool aOverrideGlobalPref); \
  NS_SCRIPTABLE NS_IMETHOD GetAutocompleteToMyDomain(PRBool *aAutocompleteToMyDomain); \
  NS_SCRIPTABLE NS_IMETHOD SetAutocompleteToMyDomain(PRBool aAutocompleteToMyDomain); \
  NS_SCRIPTABLE NS_IMETHOD GetValid(PRBool *aValid); \
  NS_SCRIPTABLE NS_IMETHOD SetValid(PRBool aValid); \
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void); \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerKey(nsACString & aSmtpServerKey); \
  NS_SCRIPTABLE NS_IMETHOD SetSmtpServerKey(const nsACString & aSmtpServerKey); \
  NS_SCRIPTABLE NS_IMETHOD GetRequestReturnReceipt(PRBool *aRequestReturnReceipt); \
  NS_SCRIPTABLE NS_IMETHOD GetReceiptHeaderType(PRInt32 *aReceiptHeaderType); \
  NS_SCRIPTABLE NS_IMETHOD GetRequestDSN(PRBool *aRequestDSN); \
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIMsgIdentity *identity); \
  NS_SCRIPTABLE NS_IMETHOD GetUnicharAttribute(const char *name, nsAString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetUnicharAttribute(const char *name, const nsAString & value); \
  NS_SCRIPTABLE NS_IMETHOD GetCharAttribute(const char *name, nsACString & _retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetCharAttribute(const char *name, const nsACString & value); \
  NS_SCRIPTABLE NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetBoolAttribute(const char *name, PRBool value); \
  NS_SCRIPTABLE NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value); \
  NS_SCRIPTABLE NS_IMETHOD ToString(nsAString & _retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGIDENTITY(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetKey(nsACString & aKey) { return _to GetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD SetKey(const nsACString & aKey) { return _to SetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD GetIdentityName(nsAString & aIdentityName) { return _to GetIdentityName(aIdentityName); } \
  NS_SCRIPTABLE NS_IMETHOD SetIdentityName(const nsAString & aIdentityName) { return _to SetIdentityName(aIdentityName); } \
  NS_SCRIPTABLE NS_IMETHOD GetFullName(nsAString & aFullName) { return _to GetFullName(aFullName); } \
  NS_SCRIPTABLE NS_IMETHOD SetFullName(const nsAString & aFullName) { return _to SetFullName(aFullName); } \
  NS_SCRIPTABLE NS_IMETHOD GetEmail(nsACString & aEmail) { return _to GetEmail(aEmail); } \
  NS_SCRIPTABLE NS_IMETHOD SetEmail(const nsACString & aEmail) { return _to SetEmail(aEmail); } \
  NS_SCRIPTABLE NS_IMETHOD GetReplyTo(nsACString & aReplyTo) { return _to GetReplyTo(aReplyTo); } \
  NS_SCRIPTABLE NS_IMETHOD SetReplyTo(const nsACString & aReplyTo) { return _to SetReplyTo(aReplyTo); } \
  NS_SCRIPTABLE NS_IMETHOD GetOrganization(nsAString & aOrganization) { return _to GetOrganization(aOrganization); } \
  NS_SCRIPTABLE NS_IMETHOD SetOrganization(const nsAString & aOrganization) { return _to SetOrganization(aOrganization); } \
  NS_SCRIPTABLE NS_IMETHOD GetComposeHtml(PRBool *aComposeHtml) { return _to GetComposeHtml(aComposeHtml); } \
  NS_SCRIPTABLE NS_IMETHOD SetComposeHtml(PRBool aComposeHtml) { return _to SetComposeHtml(aComposeHtml); } \
  NS_SCRIPTABLE NS_IMETHOD GetAttachSignature(PRBool *aAttachSignature) { return _to GetAttachSignature(aAttachSignature); } \
  NS_SCRIPTABLE NS_IMETHOD SetAttachSignature(PRBool aAttachSignature) { return _to SetAttachSignature(aAttachSignature); } \
  NS_SCRIPTABLE NS_IMETHOD GetAttachVCard(PRBool *aAttachVCard) { return _to GetAttachVCard(aAttachVCard); } \
  NS_SCRIPTABLE NS_IMETHOD SetAttachVCard(PRBool aAttachVCard) { return _to SetAttachVCard(aAttachVCard); } \
  NS_SCRIPTABLE NS_IMETHOD GetAutoQuote(PRBool *aAutoQuote) { return _to GetAutoQuote(aAutoQuote); } \
  NS_SCRIPTABLE NS_IMETHOD SetAutoQuote(PRBool aAutoQuote) { return _to SetAutoQuote(aAutoQuote); } \
  NS_SCRIPTABLE NS_IMETHOD GetReplyOnTop(PRInt32 *aReplyOnTop) { return _to GetReplyOnTop(aReplyOnTop); } \
  NS_SCRIPTABLE NS_IMETHOD SetReplyOnTop(PRInt32 aReplyOnTop) { return _to SetReplyOnTop(aReplyOnTop); } \
  NS_SCRIPTABLE NS_IMETHOD GetSigBottom(PRBool *aSigBottom) { return _to GetSigBottom(aSigBottom); } \
  NS_SCRIPTABLE NS_IMETHOD SetSigBottom(PRBool aSigBottom) { return _to SetSigBottom(aSigBottom); } \
  NS_SCRIPTABLE NS_IMETHOD GetSigOnForward(PRBool *aSigOnForward) { return _to GetSigOnForward(aSigOnForward); } \
  NS_SCRIPTABLE NS_IMETHOD SetSigOnForward(PRBool aSigOnForward) { return _to SetSigOnForward(aSigOnForward); } \
  NS_SCRIPTABLE NS_IMETHOD GetSigOnReply(PRBool *aSigOnReply) { return _to GetSigOnReply(aSigOnReply); } \
  NS_SCRIPTABLE NS_IMETHOD SetSigOnReply(PRBool aSigOnReply) { return _to SetSigOnReply(aSigOnReply); } \
  NS_SCRIPTABLE NS_IMETHOD GetSignature(nsILocalFile **aSignature) { return _to GetSignature(aSignature); } \
  NS_SCRIPTABLE NS_IMETHOD SetSignature(nsILocalFile *aSignature) { return _to SetSignature(aSignature); } \
  NS_SCRIPTABLE NS_IMETHOD GetSignatureDate(PRInt32 *aSignatureDate) { return _to GetSignatureDate(aSignatureDate); } \
  NS_SCRIPTABLE NS_IMETHOD SetSignatureDate(PRInt32 aSignatureDate) { return _to SetSignatureDate(aSignatureDate); } \
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigText(nsAString & aHtmlSigText) { return _to GetHtmlSigText(aHtmlSigText); } \
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigText(const nsAString & aHtmlSigText) { return _to SetHtmlSigText(aHtmlSigText); } \
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigFormat(PRBool *aHtmlSigFormat) { return _to GetHtmlSigFormat(aHtmlSigFormat); } \
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigFormat(PRBool aHtmlSigFormat) { return _to SetHtmlSigFormat(aHtmlSigFormat); } \
  NS_SCRIPTABLE NS_IMETHOD GetEscapedVCard(nsACString & aEscapedVCard) { return _to GetEscapedVCard(aEscapedVCard); } \
  NS_SCRIPTABLE NS_IMETHOD SetEscapedVCard(const nsACString & aEscapedVCard) { return _to SetEscapedVCard(aEscapedVCard); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoFcc(PRBool *aDoFcc) { return _to GetDoFcc(aDoFcc); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoFcc(PRBool aDoFcc) { return _to SetDoFcc(aDoFcc); } \
  NS_SCRIPTABLE NS_IMETHOD GetFccFolder(nsACString & aFccFolder) { return _to GetFccFolder(aFccFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetFccFolder(const nsACString & aFccFolder) { return _to SetFccFolder(aFccFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetFccReplyFollowsParent(PRBool *aFccReplyFollowsParent) { return _to GetFccReplyFollowsParent(aFccReplyFollowsParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetFccReplyFollowsParent(PRBool aFccReplyFollowsParent) { return _to SetFccReplyFollowsParent(aFccReplyFollowsParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetFccFolderPickerMode(nsACString & aFccFolderPickerMode) { return _to GetFccFolderPickerMode(aFccFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetFccFolderPickerMode(const nsACString & aFccFolderPickerMode) { return _to SetFccFolderPickerMode(aFccFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetDraftsFolderPickerMode(nsACString & aDraftsFolderPickerMode) { return _to GetDraftsFolderPickerMode(aDraftsFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetDraftsFolderPickerMode(const nsACString & aDraftsFolderPickerMode) { return _to SetDraftsFolderPickerMode(aDraftsFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetArchivesFolderPickerMode(nsACString & aArchivesFolderPickerMode) { return _to GetArchivesFolderPickerMode(aArchivesFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetArchivesFolderPickerMode(const nsACString & aArchivesFolderPickerMode) { return _to SetArchivesFolderPickerMode(aArchivesFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetTmplFolderPickerMode(nsACString & aTmplFolderPickerMode) { return _to GetTmplFolderPickerMode(aTmplFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetTmplFolderPickerMode(const nsACString & aTmplFolderPickerMode) { return _to SetTmplFolderPickerMode(aTmplFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetBccSelf(PRBool *aBccSelf) { return _to GetBccSelf(aBccSelf); } \
  NS_SCRIPTABLE NS_IMETHOD SetBccSelf(PRBool aBccSelf) { return _to SetBccSelf(aBccSelf); } \
  NS_SCRIPTABLE NS_IMETHOD GetBccOthers(PRBool *aBccOthers) { return _to GetBccOthers(aBccOthers); } \
  NS_SCRIPTABLE NS_IMETHOD SetBccOthers(PRBool aBccOthers) { return _to SetBccOthers(aBccOthers); } \
  NS_SCRIPTABLE NS_IMETHOD GetBccList(nsACString & aBccList) { return _to GetBccList(aBccList); } \
  NS_SCRIPTABLE NS_IMETHOD SetBccList(const nsACString & aBccList) { return _to SetBccList(aBccList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoCc(PRBool *aDoCc) { return _to GetDoCc(aDoCc); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoCc(PRBool aDoCc) { return _to SetDoCc(aDoCc); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoCcList(nsACString & aDoCcList) { return _to GetDoCcList(aDoCcList); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoCcList(const nsACString & aDoCcList) { return _to SetDoCcList(aDoCcList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoBcc(PRBool *aDoBcc) { return _to GetDoBcc(aDoBcc); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoBcc(PRBool aDoBcc) { return _to SetDoBcc(aDoBcc); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoBccList(nsACString & aDoBccList) { return _to GetDoBccList(aDoBccList); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoBccList(const nsACString & aDoBccList) { return _to SetDoBccList(aDoBccList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDraftFolder(nsACString & aDraftFolder) { return _to GetDraftFolder(aDraftFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetDraftFolder(const nsACString & aDraftFolder) { return _to SetDraftFolder(aDraftFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetArchiveFolder(nsACString & aArchiveFolder) { return _to GetArchiveFolder(aArchiveFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetArchiveFolder(const nsACString & aArchiveFolder) { return _to SetArchiveFolder(aArchiveFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetStationeryFolder(nsACString & aStationeryFolder) { return _to GetStationeryFolder(aStationeryFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetStationeryFolder(const nsACString & aStationeryFolder) { return _to SetStationeryFolder(aStationeryFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetShowSaveMsgDlg(PRBool *aShowSaveMsgDlg) { return _to GetShowSaveMsgDlg(aShowSaveMsgDlg); } \
  NS_SCRIPTABLE NS_IMETHOD SetShowSaveMsgDlg(PRBool aShowSaveMsgDlg) { return _to SetShowSaveMsgDlg(aShowSaveMsgDlg); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryServer(nsACString & aDirectoryServer) { return _to GetDirectoryServer(aDirectoryServer); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryServer(const nsACString & aDirectoryServer) { return _to SetDirectoryServer(aDirectoryServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetOverrideGlobalPref(PRBool *aOverrideGlobalPref) { return _to GetOverrideGlobalPref(aOverrideGlobalPref); } \
  NS_SCRIPTABLE NS_IMETHOD SetOverrideGlobalPref(PRBool aOverrideGlobalPref) { return _to SetOverrideGlobalPref(aOverrideGlobalPref); } \
  NS_SCRIPTABLE NS_IMETHOD GetAutocompleteToMyDomain(PRBool *aAutocompleteToMyDomain) { return _to GetAutocompleteToMyDomain(aAutocompleteToMyDomain); } \
  NS_SCRIPTABLE NS_IMETHOD SetAutocompleteToMyDomain(PRBool aAutocompleteToMyDomain) { return _to SetAutocompleteToMyDomain(aAutocompleteToMyDomain); } \
  NS_SCRIPTABLE NS_IMETHOD GetValid(PRBool *aValid) { return _to GetValid(aValid); } \
  NS_SCRIPTABLE NS_IMETHOD SetValid(PRBool aValid) { return _to SetValid(aValid); } \
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void) { return _to ClearAllValues(); } \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerKey(nsACString & aSmtpServerKey) { return _to GetSmtpServerKey(aSmtpServerKey); } \
  NS_SCRIPTABLE NS_IMETHOD SetSmtpServerKey(const nsACString & aSmtpServerKey) { return _to SetSmtpServerKey(aSmtpServerKey); } \
  NS_SCRIPTABLE NS_IMETHOD GetRequestReturnReceipt(PRBool *aRequestReturnReceipt) { return _to GetRequestReturnReceipt(aRequestReturnReceipt); } \
  NS_SCRIPTABLE NS_IMETHOD GetReceiptHeaderType(PRInt32 *aReceiptHeaderType) { return _to GetReceiptHeaderType(aReceiptHeaderType); } \
  NS_SCRIPTABLE NS_IMETHOD GetRequestDSN(PRBool *aRequestDSN) { return _to GetRequestDSN(aRequestDSN); } \
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIMsgIdentity *identity) { return _to Copy(identity); } \
  NS_SCRIPTABLE NS_IMETHOD GetUnicharAttribute(const char *name, nsAString & _retval NS_OUTPARAM) { return _to GetUnicharAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetUnicharAttribute(const char *name, const nsAString & value) { return _to SetUnicharAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharAttribute(const char *name, nsACString & _retval NS_OUTPARAM) { return _to GetCharAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetCharAttribute(const char *name, const nsACString & value) { return _to SetCharAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval NS_OUTPARAM) { return _to GetBoolAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetBoolAttribute(const char *name, PRBool value) { return _to SetBoolAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval NS_OUTPARAM) { return _to GetIntAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value) { return _to SetIntAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD ToString(nsAString & _retval NS_OUTPARAM) { return _to ToString(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGIDENTITY(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetKey(nsACString & aKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD SetKey(const nsACString & aKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetKey(aKey); } \
  NS_SCRIPTABLE NS_IMETHOD GetIdentityName(nsAString & aIdentityName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIdentityName(aIdentityName); } \
  NS_SCRIPTABLE NS_IMETHOD SetIdentityName(const nsAString & aIdentityName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIdentityName(aIdentityName); } \
  NS_SCRIPTABLE NS_IMETHOD GetFullName(nsAString & aFullName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFullName(aFullName); } \
  NS_SCRIPTABLE NS_IMETHOD SetFullName(const nsAString & aFullName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFullName(aFullName); } \
  NS_SCRIPTABLE NS_IMETHOD GetEmail(nsACString & aEmail) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEmail(aEmail); } \
  NS_SCRIPTABLE NS_IMETHOD SetEmail(const nsACString & aEmail) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEmail(aEmail); } \
  NS_SCRIPTABLE NS_IMETHOD GetReplyTo(nsACString & aReplyTo) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReplyTo(aReplyTo); } \
  NS_SCRIPTABLE NS_IMETHOD SetReplyTo(const nsACString & aReplyTo) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReplyTo(aReplyTo); } \
  NS_SCRIPTABLE NS_IMETHOD GetOrganization(nsAString & aOrganization) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOrganization(aOrganization); } \
  NS_SCRIPTABLE NS_IMETHOD SetOrganization(const nsAString & aOrganization) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOrganization(aOrganization); } \
  NS_SCRIPTABLE NS_IMETHOD GetComposeHtml(PRBool *aComposeHtml) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetComposeHtml(aComposeHtml); } \
  NS_SCRIPTABLE NS_IMETHOD SetComposeHtml(PRBool aComposeHtml) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetComposeHtml(aComposeHtml); } \
  NS_SCRIPTABLE NS_IMETHOD GetAttachSignature(PRBool *aAttachSignature) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttachSignature(aAttachSignature); } \
  NS_SCRIPTABLE NS_IMETHOD SetAttachSignature(PRBool aAttachSignature) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAttachSignature(aAttachSignature); } \
  NS_SCRIPTABLE NS_IMETHOD GetAttachVCard(PRBool *aAttachVCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttachVCard(aAttachVCard); } \
  NS_SCRIPTABLE NS_IMETHOD SetAttachVCard(PRBool aAttachVCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAttachVCard(aAttachVCard); } \
  NS_SCRIPTABLE NS_IMETHOD GetAutoQuote(PRBool *aAutoQuote) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAutoQuote(aAutoQuote); } \
  NS_SCRIPTABLE NS_IMETHOD SetAutoQuote(PRBool aAutoQuote) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAutoQuote(aAutoQuote); } \
  NS_SCRIPTABLE NS_IMETHOD GetReplyOnTop(PRInt32 *aReplyOnTop) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReplyOnTop(aReplyOnTop); } \
  NS_SCRIPTABLE NS_IMETHOD SetReplyOnTop(PRInt32 aReplyOnTop) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReplyOnTop(aReplyOnTop); } \
  NS_SCRIPTABLE NS_IMETHOD GetSigBottom(PRBool *aSigBottom) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSigBottom(aSigBottom); } \
  NS_SCRIPTABLE NS_IMETHOD SetSigBottom(PRBool aSigBottom) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSigBottom(aSigBottom); } \
  NS_SCRIPTABLE NS_IMETHOD GetSigOnForward(PRBool *aSigOnForward) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSigOnForward(aSigOnForward); } \
  NS_SCRIPTABLE NS_IMETHOD SetSigOnForward(PRBool aSigOnForward) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSigOnForward(aSigOnForward); } \
  NS_SCRIPTABLE NS_IMETHOD GetSigOnReply(PRBool *aSigOnReply) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSigOnReply(aSigOnReply); } \
  NS_SCRIPTABLE NS_IMETHOD SetSigOnReply(PRBool aSigOnReply) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSigOnReply(aSigOnReply); } \
  NS_SCRIPTABLE NS_IMETHOD GetSignature(nsILocalFile **aSignature) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSignature(aSignature); } \
  NS_SCRIPTABLE NS_IMETHOD SetSignature(nsILocalFile *aSignature) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSignature(aSignature); } \
  NS_SCRIPTABLE NS_IMETHOD GetSignatureDate(PRInt32 *aSignatureDate) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSignatureDate(aSignatureDate); } \
  NS_SCRIPTABLE NS_IMETHOD SetSignatureDate(PRInt32 aSignatureDate) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSignatureDate(aSignatureDate); } \
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigText(nsAString & aHtmlSigText) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHtmlSigText(aHtmlSigText); } \
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigText(const nsAString & aHtmlSigText) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHtmlSigText(aHtmlSigText); } \
  NS_SCRIPTABLE NS_IMETHOD GetHtmlSigFormat(PRBool *aHtmlSigFormat) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHtmlSigFormat(aHtmlSigFormat); } \
  NS_SCRIPTABLE NS_IMETHOD SetHtmlSigFormat(PRBool aHtmlSigFormat) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHtmlSigFormat(aHtmlSigFormat); } \
  NS_SCRIPTABLE NS_IMETHOD GetEscapedVCard(nsACString & aEscapedVCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEscapedVCard(aEscapedVCard); } \
  NS_SCRIPTABLE NS_IMETHOD SetEscapedVCard(const nsACString & aEscapedVCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEscapedVCard(aEscapedVCard); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoFcc(PRBool *aDoFcc) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoFcc(aDoFcc); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoFcc(PRBool aDoFcc) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDoFcc(aDoFcc); } \
  NS_SCRIPTABLE NS_IMETHOD GetFccFolder(nsACString & aFccFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFccFolder(aFccFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetFccFolder(const nsACString & aFccFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFccFolder(aFccFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetFccReplyFollowsParent(PRBool *aFccReplyFollowsParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFccReplyFollowsParent(aFccReplyFollowsParent); } \
  NS_SCRIPTABLE NS_IMETHOD SetFccReplyFollowsParent(PRBool aFccReplyFollowsParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFccReplyFollowsParent(aFccReplyFollowsParent); } \
  NS_SCRIPTABLE NS_IMETHOD GetFccFolderPickerMode(nsACString & aFccFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFccFolderPickerMode(aFccFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetFccFolderPickerMode(const nsACString & aFccFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFccFolderPickerMode(aFccFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetDraftsFolderPickerMode(nsACString & aDraftsFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDraftsFolderPickerMode(aDraftsFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetDraftsFolderPickerMode(const nsACString & aDraftsFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDraftsFolderPickerMode(aDraftsFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetArchivesFolderPickerMode(nsACString & aArchivesFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetArchivesFolderPickerMode(aArchivesFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetArchivesFolderPickerMode(const nsACString & aArchivesFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetArchivesFolderPickerMode(aArchivesFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetTmplFolderPickerMode(nsACString & aTmplFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTmplFolderPickerMode(aTmplFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD SetTmplFolderPickerMode(const nsACString & aTmplFolderPickerMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTmplFolderPickerMode(aTmplFolderPickerMode); } \
  NS_SCRIPTABLE NS_IMETHOD GetBccSelf(PRBool *aBccSelf) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBccSelf(aBccSelf); } \
  NS_SCRIPTABLE NS_IMETHOD SetBccSelf(PRBool aBccSelf) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBccSelf(aBccSelf); } \
  NS_SCRIPTABLE NS_IMETHOD GetBccOthers(PRBool *aBccOthers) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBccOthers(aBccOthers); } \
  NS_SCRIPTABLE NS_IMETHOD SetBccOthers(PRBool aBccOthers) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBccOthers(aBccOthers); } \
  NS_SCRIPTABLE NS_IMETHOD GetBccList(nsACString & aBccList) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBccList(aBccList); } \
  NS_SCRIPTABLE NS_IMETHOD SetBccList(const nsACString & aBccList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBccList(aBccList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoCc(PRBool *aDoCc) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoCc(aDoCc); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoCc(PRBool aDoCc) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDoCc(aDoCc); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoCcList(nsACString & aDoCcList) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoCcList(aDoCcList); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoCcList(const nsACString & aDoCcList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDoCcList(aDoCcList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoBcc(PRBool *aDoBcc) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoBcc(aDoBcc); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoBcc(PRBool aDoBcc) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDoBcc(aDoBcc); } \
  NS_SCRIPTABLE NS_IMETHOD GetDoBccList(nsACString & aDoBccList) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoBccList(aDoBccList); } \
  NS_SCRIPTABLE NS_IMETHOD SetDoBccList(const nsACString & aDoBccList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDoBccList(aDoBccList); } \
  NS_SCRIPTABLE NS_IMETHOD GetDraftFolder(nsACString & aDraftFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDraftFolder(aDraftFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetDraftFolder(const nsACString & aDraftFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDraftFolder(aDraftFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetArchiveFolder(nsACString & aArchiveFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetArchiveFolder(aArchiveFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetArchiveFolder(const nsACString & aArchiveFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetArchiveFolder(aArchiveFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetStationeryFolder(nsACString & aStationeryFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStationeryFolder(aStationeryFolder); } \
  NS_SCRIPTABLE NS_IMETHOD SetStationeryFolder(const nsACString & aStationeryFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStationeryFolder(aStationeryFolder); } \
  NS_SCRIPTABLE NS_IMETHOD GetShowSaveMsgDlg(PRBool *aShowSaveMsgDlg) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShowSaveMsgDlg(aShowSaveMsgDlg); } \
  NS_SCRIPTABLE NS_IMETHOD SetShowSaveMsgDlg(PRBool aShowSaveMsgDlg) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetShowSaveMsgDlg(aShowSaveMsgDlg); } \
  NS_SCRIPTABLE NS_IMETHOD GetDirectoryServer(nsACString & aDirectoryServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDirectoryServer(aDirectoryServer); } \
  NS_SCRIPTABLE NS_IMETHOD SetDirectoryServer(const nsACString & aDirectoryServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDirectoryServer(aDirectoryServer); } \
  NS_SCRIPTABLE NS_IMETHOD GetOverrideGlobalPref(PRBool *aOverrideGlobalPref) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOverrideGlobalPref(aOverrideGlobalPref); } \
  NS_SCRIPTABLE NS_IMETHOD SetOverrideGlobalPref(PRBool aOverrideGlobalPref) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOverrideGlobalPref(aOverrideGlobalPref); } \
  NS_SCRIPTABLE NS_IMETHOD GetAutocompleteToMyDomain(PRBool *aAutocompleteToMyDomain) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAutocompleteToMyDomain(aAutocompleteToMyDomain); } \
  NS_SCRIPTABLE NS_IMETHOD SetAutocompleteToMyDomain(PRBool aAutocompleteToMyDomain) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAutocompleteToMyDomain(aAutocompleteToMyDomain); } \
  NS_SCRIPTABLE NS_IMETHOD GetValid(PRBool *aValid) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetValid(aValid); } \
  NS_SCRIPTABLE NS_IMETHOD SetValid(PRBool aValid) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetValid(aValid); } \
  NS_SCRIPTABLE NS_IMETHOD ClearAllValues(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearAllValues(); } \
  NS_SCRIPTABLE NS_IMETHOD GetSmtpServerKey(nsACString & aSmtpServerKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSmtpServerKey(aSmtpServerKey); } \
  NS_SCRIPTABLE NS_IMETHOD SetSmtpServerKey(const nsACString & aSmtpServerKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSmtpServerKey(aSmtpServerKey); } \
  NS_SCRIPTABLE NS_IMETHOD GetRequestReturnReceipt(PRBool *aRequestReturnReceipt) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestReturnReceipt(aRequestReturnReceipt); } \
  NS_SCRIPTABLE NS_IMETHOD GetReceiptHeaderType(PRInt32 *aReceiptHeaderType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReceiptHeaderType(aReceiptHeaderType); } \
  NS_SCRIPTABLE NS_IMETHOD GetRequestDSN(PRBool *aRequestDSN) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestDSN(aRequestDSN); } \
  NS_SCRIPTABLE NS_IMETHOD Copy(nsIMsgIdentity *identity) { return !_to ? NS_ERROR_NULL_POINTER : _to->Copy(identity); } \
  NS_SCRIPTABLE NS_IMETHOD GetUnicharAttribute(const char *name, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUnicharAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetUnicharAttribute(const char *name, const nsAString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUnicharAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD GetCharAttribute(const char *name, nsACString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetCharAttribute(const char *name, const nsACString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCharAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBoolAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetBoolAttribute(const char *name, PRBool value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBoolAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIntAttribute(name, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIntAttribute(name, value); } \
  NS_SCRIPTABLE NS_IMETHOD ToString(nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ToString(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgIdentity : public nsIMsgIdentity
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGIDENTITY

  nsMsgIdentity();

private:
  ~nsMsgIdentity();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgIdentity, nsIMsgIdentity)

nsMsgIdentity::nsMsgIdentity()
{
  /* member initializers and constructor code */
}

nsMsgIdentity::~nsMsgIdentity()
{
  /* destructor code */
}

/* attribute ACString key; */
NS_IMETHODIMP nsMsgIdentity::GetKey(nsACString & aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetKey(const nsACString & aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString identityName; */
NS_IMETHODIMP nsMsgIdentity::GetIdentityName(nsAString & aIdentityName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetIdentityName(const nsAString & aIdentityName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString fullName; */
NS_IMETHODIMP nsMsgIdentity::GetFullName(nsAString & aFullName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetFullName(const nsAString & aFullName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString email; */
NS_IMETHODIMP nsMsgIdentity::GetEmail(nsACString & aEmail)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetEmail(const nsACString & aEmail)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString replyTo; */
NS_IMETHODIMP nsMsgIdentity::GetReplyTo(nsACString & aReplyTo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetReplyTo(const nsACString & aReplyTo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString organization; */
NS_IMETHODIMP nsMsgIdentity::GetOrganization(nsAString & aOrganization)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetOrganization(const nsAString & aOrganization)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean composeHtml; */
NS_IMETHODIMP nsMsgIdentity::GetComposeHtml(PRBool *aComposeHtml)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetComposeHtml(PRBool aComposeHtml)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean attachSignature; */
NS_IMETHODIMP nsMsgIdentity::GetAttachSignature(PRBool *aAttachSignature)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetAttachSignature(PRBool aAttachSignature)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean attachVCard; */
NS_IMETHODIMP nsMsgIdentity::GetAttachVCard(PRBool *aAttachVCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetAttachVCard(PRBool aAttachVCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean autoQuote; */
NS_IMETHODIMP nsMsgIdentity::GetAutoQuote(PRBool *aAutoQuote)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetAutoQuote(PRBool aAutoQuote)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long replyOnTop; */
NS_IMETHODIMP nsMsgIdentity::GetReplyOnTop(PRInt32 *aReplyOnTop)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetReplyOnTop(PRInt32 aReplyOnTop)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean sigBottom; */
NS_IMETHODIMP nsMsgIdentity::GetSigBottom(PRBool *aSigBottom)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetSigBottom(PRBool aSigBottom)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean sigOnForward; */
NS_IMETHODIMP nsMsgIdentity::GetSigOnForward(PRBool *aSigOnForward)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetSigOnForward(PRBool aSigOnForward)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean sigOnReply; */
NS_IMETHODIMP nsMsgIdentity::GetSigOnReply(PRBool *aSigOnReply)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetSigOnReply(PRBool aSigOnReply)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsILocalFile signature; */
NS_IMETHODIMP nsMsgIdentity::GetSignature(nsILocalFile **aSignature)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetSignature(nsILocalFile *aSignature)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long signatureDate; */
NS_IMETHODIMP nsMsgIdentity::GetSignatureDate(PRInt32 *aSignatureDate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetSignatureDate(PRInt32 aSignatureDate)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute AString htmlSigText; */
NS_IMETHODIMP nsMsgIdentity::GetHtmlSigText(nsAString & aHtmlSigText)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetHtmlSigText(const nsAString & aHtmlSigText)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean htmlSigFormat; */
NS_IMETHODIMP nsMsgIdentity::GetHtmlSigFormat(PRBool *aHtmlSigFormat)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetHtmlSigFormat(PRBool aHtmlSigFormat)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString escapedVCard; */
NS_IMETHODIMP nsMsgIdentity::GetEscapedVCard(nsACString & aEscapedVCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetEscapedVCard(const nsACString & aEscapedVCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean doFcc; */
NS_IMETHODIMP nsMsgIdentity::GetDoFcc(PRBool *aDoFcc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDoFcc(PRBool aDoFcc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString fccFolder; */
NS_IMETHODIMP nsMsgIdentity::GetFccFolder(nsACString & aFccFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetFccFolder(const nsACString & aFccFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean fccReplyFollowsParent; */
NS_IMETHODIMP nsMsgIdentity::GetFccReplyFollowsParent(PRBool *aFccReplyFollowsParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetFccReplyFollowsParent(PRBool aFccReplyFollowsParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString fccFolderPickerMode; */
NS_IMETHODIMP nsMsgIdentity::GetFccFolderPickerMode(nsACString & aFccFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetFccFolderPickerMode(const nsACString & aFccFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString draftsFolderPickerMode; */
NS_IMETHODIMP nsMsgIdentity::GetDraftsFolderPickerMode(nsACString & aDraftsFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDraftsFolderPickerMode(const nsACString & aDraftsFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString archivesFolderPickerMode; */
NS_IMETHODIMP nsMsgIdentity::GetArchivesFolderPickerMode(nsACString & aArchivesFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetArchivesFolderPickerMode(const nsACString & aArchivesFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString tmplFolderPickerMode; */
NS_IMETHODIMP nsMsgIdentity::GetTmplFolderPickerMode(nsACString & aTmplFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetTmplFolderPickerMode(const nsACString & aTmplFolderPickerMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean bccSelf; */
NS_IMETHODIMP nsMsgIdentity::GetBccSelf(PRBool *aBccSelf)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetBccSelf(PRBool aBccSelf)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean bccOthers; */
NS_IMETHODIMP nsMsgIdentity::GetBccOthers(PRBool *aBccOthers)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetBccOthers(PRBool aBccOthers)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString bccList; */
NS_IMETHODIMP nsMsgIdentity::GetBccList(nsACString & aBccList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetBccList(const nsACString & aBccList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean doCc; */
NS_IMETHODIMP nsMsgIdentity::GetDoCc(PRBool *aDoCc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDoCc(PRBool aDoCc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString doCcList; */
NS_IMETHODIMP nsMsgIdentity::GetDoCcList(nsACString & aDoCcList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDoCcList(const nsACString & aDoCcList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean doBcc; */
NS_IMETHODIMP nsMsgIdentity::GetDoBcc(PRBool *aDoBcc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDoBcc(PRBool aDoBcc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString doBccList; */
NS_IMETHODIMP nsMsgIdentity::GetDoBccList(nsACString & aDoBccList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDoBccList(const nsACString & aDoBccList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString draftFolder; */
NS_IMETHODIMP nsMsgIdentity::GetDraftFolder(nsACString & aDraftFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDraftFolder(const nsACString & aDraftFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString archiveFolder; */
NS_IMETHODIMP nsMsgIdentity::GetArchiveFolder(nsACString & aArchiveFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetArchiveFolder(const nsACString & aArchiveFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString stationeryFolder; */
NS_IMETHODIMP nsMsgIdentity::GetStationeryFolder(nsACString & aStationeryFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetStationeryFolder(const nsACString & aStationeryFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean showSaveMsgDlg; */
NS_IMETHODIMP nsMsgIdentity::GetShowSaveMsgDlg(PRBool *aShowSaveMsgDlg)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetShowSaveMsgDlg(PRBool aShowSaveMsgDlg)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString directoryServer; */
NS_IMETHODIMP nsMsgIdentity::GetDirectoryServer(nsACString & aDirectoryServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetDirectoryServer(const nsACString & aDirectoryServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean overrideGlobalPref; */
NS_IMETHODIMP nsMsgIdentity::GetOverrideGlobalPref(PRBool *aOverrideGlobalPref)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetOverrideGlobalPref(PRBool aOverrideGlobalPref)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean autocompleteToMyDomain; */
NS_IMETHODIMP nsMsgIdentity::GetAutocompleteToMyDomain(PRBool *aAutocompleteToMyDomain)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetAutocompleteToMyDomain(PRBool aAutocompleteToMyDomain)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean valid; */
NS_IMETHODIMP nsMsgIdentity::GetValid(PRBool *aValid)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetValid(PRBool aValid)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearAllValues (); */
NS_IMETHODIMP nsMsgIdentity::ClearAllValues()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString smtpServerKey; */
NS_IMETHODIMP nsMsgIdentity::GetSmtpServerKey(nsACString & aSmtpServerKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIdentity::SetSmtpServerKey(const nsACString & aSmtpServerKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean requestReturnReceipt; */
NS_IMETHODIMP nsMsgIdentity::GetRequestReturnReceipt(PRBool *aRequestReturnReceipt)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long receiptHeaderType; */
NS_IMETHODIMP nsMsgIdentity::GetReceiptHeaderType(PRInt32 *aReceiptHeaderType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean requestDSN; */
NS_IMETHODIMP nsMsgIdentity::GetRequestDSN(PRBool *aRequestDSN)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void copy (in nsIMsgIdentity identity); */
NS_IMETHODIMP nsMsgIdentity::Copy(nsIMsgIdentity *identity)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getUnicharAttribute (in string name); */
NS_IMETHODIMP nsMsgIdentity::GetUnicharAttribute(const char *name, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setUnicharAttribute (in string name, in AString value); */
NS_IMETHODIMP nsMsgIdentity::SetUnicharAttribute(const char *name, const nsAString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getCharAttribute (in string name); */
NS_IMETHODIMP nsMsgIdentity::GetCharAttribute(const char *name, nsACString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCharAttribute (in string name, in ACString value); */
NS_IMETHODIMP nsMsgIdentity::SetCharAttribute(const char *name, const nsACString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getBoolAttribute (in string name); */
NS_IMETHODIMP nsMsgIdentity::GetBoolAttribute(const char *name, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBoolAttribute (in string name, in boolean value); */
NS_IMETHODIMP nsMsgIdentity::SetBoolAttribute(const char *name, PRBool value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getIntAttribute (in string name); */
NS_IMETHODIMP nsMsgIdentity::GetIntAttribute(const char *name, PRInt32 *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setIntAttribute (in string name, in long value); */
NS_IMETHODIMP nsMsgIdentity::SetIntAttribute(const char *name, PRInt32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString toString (); */
NS_IMETHODIMP nsMsgIdentity::ToString(nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgIdentity_h__ */
