/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIMsgFolderListener.idl
 */

#ifndef __gen_nsIMsgFolderListener_h__
#define __gen_nsIMsgFolderListener_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgDBHdr; /* forward declaration */

class nsIMsgFolder; /* forward declaration */

class nsIArray; /* forward declaration */


/* starting interface:    nsIMsgFolderListener */
#define NS_IMSGFOLDERLISTENER_IID_STR "63533aa2-9e03-424c-b308-a3ee5ad47bc5"

#define NS_IMSGFOLDERLISTENER_IID \
  {0x63533aa2, 0x9e03, 0x424c, \
    { 0xb3, 0x08, 0xa3, 0xee, 0x5a, 0xd4, 0x7b, 0xc5 }}

/**
 * This is similar to nsIFolderListener, but with slightly different semantics,
 * especially w.r.t. moving messages and folders.  Some listeners want to know
 * about moves, instead of getting an itemAdded and itemRemoved notification.
 * Folder listeners also only tend to get called if a view is open on the folder,
 * which is not always the case. I don't want to change nsIFolderListener at this
 * point since there are lots of extensions that rely on it. Eventually,
 * these two interfaces should be combined somehow.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIMsgFolderListener : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IMSGFOLDERLISTENER_IID)

  /**
   * Notified immediately after a message is added to a folder. This could be a
   * new incoming message to a local folder, or a new message in an IMAP folder
   * when it is opened.
   *
   * You may want to consider using the msgsClassified notification instead of
   * this notification if any of the following are true:
   *
   * - You only want to be notified about messages after junk classification
   *   has occurred (if it is going to occur for a message).  This also goes for
   *   trait classification which is a generic use of the bayesian engine at
   *   the heart of the spam logic.
   *
   * - You only want to be notified about messages after all filters have been
   *   run.  Although some filters may be run before the msgAdded notification
   *   is generated, filters dependent on junk/trait classification wait until
   *   classification completes.
   *
   * @param aMsg The message header that was just added
   */
  /* void msgAdded (in nsIMsgDBHdr aMsg); */
  NS_SCRIPTABLE NS_IMETHOD MsgAdded(nsIMsgDBHdr *aMsg) = 0;

  /**
   * Notification that (new to the client) messages have been through junk and
   * trait classification.  This event will occur for all messages at some point
   * after their existence is revealed by msgAdded.
   *
   * Because junk classification does not run if no messages have ever been
   * marked as junk by the user, it is possible to receive this message without
   * any classification having actually been performed.  We still generate the
   * notification in this case so that code is reliably notified about the
   * existence of the new message headers.
   *
   * @param aMsgs The message headers that have been classified or were
   *     intentionally not classified.
   * @param aJunkProcessed Were the messages processed for junk classification?
   * @param aTraitProcessed Were the messages processed for trait
   *     classification?
   */
  /* void msgsClassified (in nsIArray aMsgs, in boolean aJunkProcessed, in boolean aTraitProcessed); */
  NS_SCRIPTABLE NS_IMETHOD MsgsClassified(nsIArray *aMsgs, PRBool aJunkProcessed, PRBool aTraitProcessed) = 0;

  /**
   * Notified after a command to delete a group of messages has been given, but before the
   * messages have actually been deleted.
   *
   * @param aMsgs An array of the message headers about to be deleted
   *
   * @note
   * This notification will not take place if the messages are being deleted from the folder
   * as the result of a move to another folder. Instead, the msgsMoveCopyCompleted() notification
   * takes place.
   *
   * @note
   * "Deleting" to a trash folder is actually a move, and is covered by msgsMoveCopyCompleted()
   *
   * @note
   * If the user has selected the IMAP delete model (marking messages as deleted, then purging them
   * later) for an IMAP account, this notification will not take place on the delete. This will only
   * take place on the purge.
   */
  /* void msgsDeleted (in nsIArray aMsgs); */
  NS_SCRIPTABLE NS_IMETHOD MsgsDeleted(nsIArray *aMsgs) = 0;

  /**
   * Notified after a command to move or copy a group of messages completes. In
   * case of a move, this is before the messages have been deleted from the
   * source folder.
   *
   * @param aMove true if a move, false if a copy
   * @param aSrcMsgs An array of the message headers in the source folder
   * @param aDestFolder The folder these messages were moved to.
   * @param aDestMsgs Present only for local folder moves, it provides the list
   *     of target message headers.
   *
   * @note
   * If messages are moved from a server which uses the IMAP delete model,
   * you'll get aMove = false. That's because the messages are not deleted from
   * the source database, but instead simply marked deleted.
   */
  /* void msgsMoveCopyCompleted (in boolean aMove, in nsIArray aSrcMsgs, in nsIMsgFolder aDestFolder, in nsIArray aDestMsgs); */
  NS_SCRIPTABLE NS_IMETHOD MsgsMoveCopyCompleted(PRBool aMove, nsIArray *aSrcMsgs, nsIMsgFolder *aDestFolder, nsIArray *aDestMsgs) = 0;

  /**
   * Notified after a folder has been added.
   *
   * @param aFolder The folder that has just been added
   */
  /* void folderAdded (in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD FolderAdded(nsIMsgFolder *aFolder) = 0;

  /**
   * Notified after a folder has been deleted and its corresponding file(s) deleted from disk.
   *
   * @param aFolder The folder that has just been deleted
   *
   * @note
   * "Deleting" to a trash folder is actually a move, and is covered by folderMoveCopyCompleted()
   */
  /* void folderDeleted (in nsIMsgFolder aFolder); */
  NS_SCRIPTABLE NS_IMETHOD FolderDeleted(nsIMsgFolder *aFolder) = 0;

  /**
   * Notified after a command to move or copy a folder completes. In case of a move, at this point,
   * the original folder and its files have already been moved to the new location.
   *
   * @param aMove true if a move, false if a copy
   * @param aSrcFolder The original folder that was moved
   * @param aDestFolder The parent folder this folder was moved to
   */
  /* void folderMoveCopyCompleted (in boolean aMove, in nsIMsgFolder aSrcFolder, in nsIMsgFolder aDestFolder); */
  NS_SCRIPTABLE NS_IMETHOD FolderMoveCopyCompleted(PRBool aMove, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDestFolder) = 0;

  /**
   * Notified after a folder is renamed.
   *
   * @param aOrigFolder The folder with the old name
   * @param aNewFolder The folder with the new name
   */
  /* void folderRenamed (in nsIMsgFolder aOrigFolder, in nsIMsgFolder aNewFolder); */
  NS_SCRIPTABLE NS_IMETHOD FolderRenamed(nsIMsgFolder *aOrigFolder, nsIMsgFolder *aNewFolder) = 0;

  /**
   * Notified when a particular event takes place for an item.
   *
   * Current uses by event string:
   *
   * - FolderCompactStart: nsIMsgFolderCompactor is beginning compaction of the
   *    folder.  If the summary file was missing or out-of-date and a parse
   *    is required, this notification will come after the completion of the
   *    parse.  The compactor will be holding the folder's semaphore when
   *    this notification is generated.  This only happens for local folders
   *    currently.  aItem is the folder.
   * - FolderCompactFinish: nsIMsgFolderCompactor has completed compaction of
   *    the folder.  This notification will be generated immediately prior to
   *    the nsIFolderListener::itemEvent() notification with a
   *    "CompactCompleted" atom.  At this point, the folder semaphore has been
   *    released and the database has been committed.  aItem is the folder.
   *
   * - FolderReindexTriggered: The user has opted to rebuild the mork msf index
   *    for a folder.  Following this notification, the database will be
   *    closed, backed up (so that header properties can be propagated), and
   *    then rebuilt from the source.  The rebuild is triggered by a call to
   *    updateFolder, so an nsIFolderListener OnItemEvent(folder,
   *    FolderLoaded atom) notification will be received if you want to know
   *    when this is all completed.  Note: this event is only generated for
   *    Thunderbird because the event currently comes from Thunderbird-specific
   *    code.
   *
   * - JunkStatusChanged: Indicates that some messages that had already been
   *    reported by msgsClassified have had their junk status changed.  This
   *    event will not fire for the initial automatic classification of
   *    messages; msgsClassified will tell you about those messages.  This
   *    notification may be promoted to an explicit callback function at some
   *    point.  This is not guaranteed to be a comprehensive source of junk
   *    notification events; right now any time an nsMsgDBView marks things as
   *    junk/non-junk a notification is produced.  aItem is an nsIArray of
   *    messages, aData is either a "junk" or "notjunk" atom if all of the
   *    messages have the same state.
   *
   * @param aItem The item the event takes place on
   * @param aEvent String describing the event
   * @param aData Data relevant to the event
   */
  /* void itemEvent (in nsISupports aItem, in ACString aEvent, in nsISupports aData); */
  NS_SCRIPTABLE NS_IMETHOD ItemEvent(nsISupports *aItem, const nsACString & aEvent, nsISupports *aData) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIMsgFolderListener, NS_IMSGFOLDERLISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGFOLDERLISTENER \
  NS_SCRIPTABLE NS_IMETHOD MsgAdded(nsIMsgDBHdr *aMsg); \
  NS_SCRIPTABLE NS_IMETHOD MsgsClassified(nsIArray *aMsgs, PRBool aJunkProcessed, PRBool aTraitProcessed); \
  NS_SCRIPTABLE NS_IMETHOD MsgsDeleted(nsIArray *aMsgs); \
  NS_SCRIPTABLE NS_IMETHOD MsgsMoveCopyCompleted(PRBool aMove, nsIArray *aSrcMsgs, nsIMsgFolder *aDestFolder, nsIArray *aDestMsgs); \
  NS_SCRIPTABLE NS_IMETHOD FolderAdded(nsIMsgFolder *aFolder); \
  NS_SCRIPTABLE NS_IMETHOD FolderDeleted(nsIMsgFolder *aFolder); \
  NS_SCRIPTABLE NS_IMETHOD FolderMoveCopyCompleted(PRBool aMove, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDestFolder); \
  NS_SCRIPTABLE NS_IMETHOD FolderRenamed(nsIMsgFolder *aOrigFolder, nsIMsgFolder *aNewFolder); \
  NS_SCRIPTABLE NS_IMETHOD ItemEvent(nsISupports *aItem, const nsACString & aEvent, nsISupports *aData); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGFOLDERLISTENER(_to) \
  NS_SCRIPTABLE NS_IMETHOD MsgAdded(nsIMsgDBHdr *aMsg) { return _to MsgAdded(aMsg); } \
  NS_SCRIPTABLE NS_IMETHOD MsgsClassified(nsIArray *aMsgs, PRBool aJunkProcessed, PRBool aTraitProcessed) { return _to MsgsClassified(aMsgs, aJunkProcessed, aTraitProcessed); } \
  NS_SCRIPTABLE NS_IMETHOD MsgsDeleted(nsIArray *aMsgs) { return _to MsgsDeleted(aMsgs); } \
  NS_SCRIPTABLE NS_IMETHOD MsgsMoveCopyCompleted(PRBool aMove, nsIArray *aSrcMsgs, nsIMsgFolder *aDestFolder, nsIArray *aDestMsgs) { return _to MsgsMoveCopyCompleted(aMove, aSrcMsgs, aDestFolder, aDestMsgs); } \
  NS_SCRIPTABLE NS_IMETHOD FolderAdded(nsIMsgFolder *aFolder) { return _to FolderAdded(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD FolderDeleted(nsIMsgFolder *aFolder) { return _to FolderDeleted(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD FolderMoveCopyCompleted(PRBool aMove, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDestFolder) { return _to FolderMoveCopyCompleted(aMove, aSrcFolder, aDestFolder); } \
  NS_SCRIPTABLE NS_IMETHOD FolderRenamed(nsIMsgFolder *aOrigFolder, nsIMsgFolder *aNewFolder) { return _to FolderRenamed(aOrigFolder, aNewFolder); } \
  NS_SCRIPTABLE NS_IMETHOD ItemEvent(nsISupports *aItem, const nsACString & aEvent, nsISupports *aData) { return _to ItemEvent(aItem, aEvent, aData); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGFOLDERLISTENER(_to) \
  NS_SCRIPTABLE NS_IMETHOD MsgAdded(nsIMsgDBHdr *aMsg) { return !_to ? NS_ERROR_NULL_POINTER : _to->MsgAdded(aMsg); } \
  NS_SCRIPTABLE NS_IMETHOD MsgsClassified(nsIArray *aMsgs, PRBool aJunkProcessed, PRBool aTraitProcessed) { return !_to ? NS_ERROR_NULL_POINTER : _to->MsgsClassified(aMsgs, aJunkProcessed, aTraitProcessed); } \
  NS_SCRIPTABLE NS_IMETHOD MsgsDeleted(nsIArray *aMsgs) { return !_to ? NS_ERROR_NULL_POINTER : _to->MsgsDeleted(aMsgs); } \
  NS_SCRIPTABLE NS_IMETHOD MsgsMoveCopyCompleted(PRBool aMove, nsIArray *aSrcMsgs, nsIMsgFolder *aDestFolder, nsIArray *aDestMsgs) { return !_to ? NS_ERROR_NULL_POINTER : _to->MsgsMoveCopyCompleted(aMove, aSrcMsgs, aDestFolder, aDestMsgs); } \
  NS_SCRIPTABLE NS_IMETHOD FolderAdded(nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderAdded(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD FolderDeleted(nsIMsgFolder *aFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderDeleted(aFolder); } \
  NS_SCRIPTABLE NS_IMETHOD FolderMoveCopyCompleted(PRBool aMove, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDestFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderMoveCopyCompleted(aMove, aSrcFolder, aDestFolder); } \
  NS_SCRIPTABLE NS_IMETHOD FolderRenamed(nsIMsgFolder *aOrigFolder, nsIMsgFolder *aNewFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderRenamed(aOrigFolder, aNewFolder); } \
  NS_SCRIPTABLE NS_IMETHOD ItemEvent(nsISupports *aItem, const nsACString & aEvent, nsISupports *aData) { return !_to ? NS_ERROR_NULL_POINTER : _to->ItemEvent(aItem, aEvent, aData); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgFolderListener : public nsIMsgFolderListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGFOLDERLISTENER

  nsMsgFolderListener();

private:
  ~nsMsgFolderListener();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgFolderListener, nsIMsgFolderListener)

nsMsgFolderListener::nsMsgFolderListener()
{
  /* member initializers and constructor code */
}

nsMsgFolderListener::~nsMsgFolderListener()
{
  /* destructor code */
}

/* void msgAdded (in nsIMsgDBHdr aMsg); */
NS_IMETHODIMP nsMsgFolderListener::MsgAdded(nsIMsgDBHdr *aMsg)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void msgsClassified (in nsIArray aMsgs, in boolean aJunkProcessed, in boolean aTraitProcessed); */
NS_IMETHODIMP nsMsgFolderListener::MsgsClassified(nsIArray *aMsgs, PRBool aJunkProcessed, PRBool aTraitProcessed)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void msgsDeleted (in nsIArray aMsgs); */
NS_IMETHODIMP nsMsgFolderListener::MsgsDeleted(nsIArray *aMsgs)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void msgsMoveCopyCompleted (in boolean aMove, in nsIArray aSrcMsgs, in nsIMsgFolder aDestFolder, in nsIArray aDestMsgs); */
NS_IMETHODIMP nsMsgFolderListener::MsgsMoveCopyCompleted(PRBool aMove, nsIArray *aSrcMsgs, nsIMsgFolder *aDestFolder, nsIArray *aDestMsgs)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void folderAdded (in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsMsgFolderListener::FolderAdded(nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void folderDeleted (in nsIMsgFolder aFolder); */
NS_IMETHODIMP nsMsgFolderListener::FolderDeleted(nsIMsgFolder *aFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void folderMoveCopyCompleted (in boolean aMove, in nsIMsgFolder aSrcFolder, in nsIMsgFolder aDestFolder); */
NS_IMETHODIMP nsMsgFolderListener::FolderMoveCopyCompleted(PRBool aMove, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDestFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void folderRenamed (in nsIMsgFolder aOrigFolder, in nsIMsgFolder aNewFolder); */
NS_IMETHODIMP nsMsgFolderListener::FolderRenamed(nsIMsgFolder *aOrigFolder, nsIMsgFolder *aNewFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void itemEvent (in nsISupports aItem, in ACString aEvent, in nsISupports aData); */
NS_IMETHODIMP nsMsgFolderListener::ItemEvent(nsISupports *aItem, const nsACString & aEvent, nsISupports *aData)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMsgFolderListener_h__ */
