/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbLDIFService.idl
 */

#ifndef __gen_nsIAbLDIFService_h__
#define __gen_nsIAbLDIFService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFile; /* forward declaration */

class nsIAddrDatabase; /* forward declaration */


/* starting interface:    nsIAbLDIFService */
#define NS_IABLDIFSERVICE_IID_STR "7afaa95f-0b1c-4d8a-a65f-bb5073ed6d39"

#define NS_IABLDIFSERVICE_IID \
  {0x7afaa95f, 0x0b1c, 0x4d8a, \
    { 0xa6, 0x5f, 0xbb, 0x50, 0x73, 0xed, 0x6d, 0x39 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIAbLDIFService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABLDIFSERVICE_IID)

  /**
   * Determine if a file is likely to be an LDIF file based on field
   * names that commonly appear in LDIF files.
   *
   * @param       aSrc   The file to examine
   *    
   * @return      PR_TRUE if the file appears to be of LDIF type,
   *              PR_FALSE otherwise
   */
  /* boolean isLDIFFile (in nsIFile aSrc); */
  NS_SCRIPTABLE NS_IMETHOD IsLDIFFile(nsIFile *aSrc, PRBool *_retval NS_OUTPARAM) = 0;

  /**
   * Imports a file into the specified address book.
   *
   * @param       aDb             The address book to import addresses into.
   *
   * @param       aSrc            The file to import addresses from.
   *
   * @param       aStoreLocAsHome Stores the address as a home rather than work
   *                              address.
   *
   * @param       aProgress       May be null, but if a pointer is supplied,
   *                              then it will be updated regularly with the
   *                              current position of reading from the file.
   *
   */
  /* void importLDIFFile (in nsIAddrDatabase aDb, in nsIFile aSrc, in boolean aStoreLocAsHome, inout unsigned long aProgress); */
  NS_SCRIPTABLE NS_IMETHOD ImportLDIFFile(nsIAddrDatabase *aDb, nsIFile *aSrc, PRBool aStoreLocAsHome, PRUint32 *aProgress NS_INOUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbLDIFService, NS_IABLDIFSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABLDIFSERVICE \
  NS_SCRIPTABLE NS_IMETHOD IsLDIFFile(nsIFile *aSrc, PRBool *_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD ImportLDIFFile(nsIAddrDatabase *aDb, nsIFile *aSrc, PRBool aStoreLocAsHome, PRUint32 *aProgress NS_INOUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABLDIFSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD IsLDIFFile(nsIFile *aSrc, PRBool *_retval NS_OUTPARAM) { return _to IsLDIFFile(aSrc, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ImportLDIFFile(nsIAddrDatabase *aDb, nsIFile *aSrc, PRBool aStoreLocAsHome, PRUint32 *aProgress NS_INOUTPARAM) { return _to ImportLDIFFile(aDb, aSrc, aStoreLocAsHome, aProgress); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABLDIFSERVICE(_to) \
  NS_SCRIPTABLE NS_IMETHOD IsLDIFFile(nsIFile *aSrc, PRBool *_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsLDIFFile(aSrc, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD ImportLDIFFile(nsIAddrDatabase *aDb, nsIFile *aSrc, PRBool aStoreLocAsHome, PRUint32 *aProgress NS_INOUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->ImportLDIFFile(aDb, aSrc, aStoreLocAsHome, aProgress); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbLDIFService : public nsIAbLDIFService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABLDIFSERVICE

  nsAbLDIFService();

private:
  ~nsAbLDIFService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbLDIFService, nsIAbLDIFService)

nsAbLDIFService::nsAbLDIFService()
{
  /* member initializers and constructor code */
}

nsAbLDIFService::~nsAbLDIFService()
{
  /* destructor code */
}

/* boolean isLDIFFile (in nsIFile aSrc); */
NS_IMETHODIMP nsAbLDIFService::IsLDIFFile(nsIFile *aSrc, PRBool *_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void importLDIFFile (in nsIAddrDatabase aDb, in nsIFile aSrc, in boolean aStoreLocAsHome, inout unsigned long aProgress); */
NS_IMETHODIMP nsAbLDIFService::ImportLDIFFile(nsIAddrDatabase *aDb, nsIFile *aSrc, PRBool aStoreLocAsHome, PRUint32 *aProgress NS_INOUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAbLDIFService_h__ */
