/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbItem.idl
 */

#ifndef __gen_nsIAbItem_h__
#define __gen_nsIAbItem_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgHeaderParser; /* forward declaration */

class nsIStringBundle; /* forward declaration */


/* starting interface:    nsIAbItem */
#define NS_IABITEM_IID_STR "f7320616-3139-419b-a7c3-37441da3caf3"

#define NS_IABITEM_IID \
  {0xf7320616, 0x3139, 0x419b, \
    { 0xa7, 0xc3, 0x37, 0x44, 0x1d, 0xa3, 0xca, 0xf3 }}

/**
 * A containable item for address books.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIAbItem : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABITEM_IID)

  /**
   * @{
   * These constants reflect the possible values of the
   * mail.addr_book.lastnamefirst preferences. They are intended to be used in
   * generateName, defined below.
   */
  enum { GENERATE_DISPLAY_NAME = 0U };

  enum { GENERATE_LAST_FIRST_ORDER = 1U };

  enum { GENERATE_FIRST_LAST_ORDER = 2U };

  /** @} */
/** 
   * Generate a name from the item for display purposes.
   *
   * If this item is an nsIAbCard, then it will use the aGenerateFormat option
   * to determine the string to return.
   * If this item is not an nsIAbCard, then the aGenerateFormat option may be
   * ignored, and the displayName of the item returned.
   *
   * @param  aGenerateFormat The format to generate as per the GENERATE_*
   *                         constants above.
   * @param  aBundle         An optional parameter that is a pointer to a string
   *                         bundle that holds:
   *           chrome://messenger/locale/addressbook/addressBook.properties
   *                         If this bundle is not supplied, then the function
   *                         will obtain the bundle itself. If cached by the
   *                         caller and supplied to this function, then
   *                         performance will be improved over many calls.
   * @return                 A string containing the generated name.
   */
  /* AString generateName (in long aGenerateFormat, [optional] in nsIStringBundle aBundle); */
  NS_SCRIPTABLE NS_IMETHOD GenerateName(PRInt32 aGenerateFormat, nsIStringBundle *aBundle, nsAString & _retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbItem, NS_IABITEM_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABITEM \
  NS_SCRIPTABLE NS_IMETHOD GenerateName(PRInt32 aGenerateFormat, nsIStringBundle *aBundle, nsAString & _retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABITEM(_to) \
  NS_SCRIPTABLE NS_IMETHOD GenerateName(PRInt32 aGenerateFormat, nsIStringBundle *aBundle, nsAString & _retval NS_OUTPARAM) { return _to GenerateName(aGenerateFormat, aBundle, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABITEM(_to) \
  NS_SCRIPTABLE NS_IMETHOD GenerateName(PRInt32 aGenerateFormat, nsIStringBundle *aBundle, nsAString & _retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GenerateName(aGenerateFormat, aBundle, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbItem : public nsIAbItem
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABITEM

  nsAbItem();

private:
  ~nsAbItem();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbItem, nsIAbItem)

nsAbItem::nsAbItem()
{
  /* member initializers and constructor code */
}

nsAbItem::~nsAbItem()
{
  /* destructor code */
}

/* AString generateName (in long aGenerateFormat, [optional] in nsIStringBundle aBundle); */
NS_IMETHODIMP nsAbItem::GenerateName(PRInt32 aGenerateFormat, nsIStringBundle *aBundle, nsAString & _retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAbItem_h__ */
