/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbCollection.idl
 */

#ifndef __gen_nsIAbCollection_h__
#define __gen_nsIAbCollection_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIAbItem_h__
#include "nsIAbItem.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIAbCard; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */


/* starting interface:    nsIAbCollection */
#define NS_IABCOLLECTION_IID_STR "67f9d071-3853-4ba1-bd85-df108dd10625"

#define NS_IABCOLLECTION_IID \
  {0x67f9d071, 0x3853, 0x4ba1, \
    { 0xbd, 0x85, 0xdf, 0x10, 0x8d, 0xd1, 0x06, 0x25 }}

/**
 * A collection of address book items.
 */
class NS_NO_VTABLE NS_SCRIPTABLE nsIAbCollection : public nsIAbItem {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IABCOLLECTION_IID)

  /**
   * Returns true if this collection is read-only.
   */
  /* readonly attribute boolean readOnly; */
  NS_SCRIPTABLE NS_IMETHOD GetReadOnly(PRBool *aReadOnly) = 0;

  /**
   * Returns true if this collection is accessed over a network connection.
   */
  /* readonly attribute boolean isRemote; */
  NS_SCRIPTABLE NS_IMETHOD GetIsRemote(PRBool *aIsRemote) = 0;

  /**
   * Returns true if this collection is accessed over a secure connection.
   *
   * If isRemote returns false, then this value MUST be false as well.
   */
  /* readonly attribute boolean isSecure; */
  NS_SCRIPTABLE NS_IMETHOD GetIsSecure(PRBool *aIsSecure) = 0;

  /** 
   * Returns an address book card for the specified email address if found.
   *
   * If there are multiple cards with the given email address, this method will
   * return one of these cards in an implementation-defined manner.
   *
   * Matching is performed in a case-insensitive manner.
   *
   * This method performs a synchronous operation. If the collection cannot do
   * the search in such a manner, then it should throw NS_ERROR_NOT_IMPLEMENTED.
   *
   * @param  emailAddress The email address to find in any of the email address
   *                      fields. If emailAddress is empty, the database won't
   *                      be searched and the function will return as if no card
   *                      was found.
   * @return              An nsIAbCard if one was found, else returns NULL.
   * @exception NS_ERROR_NOT_IMPLEMENTED If the collection cannot do this.
   */
  /* nsIAbCard cardForEmailAddress (in AUTF8String emailAddress); */
  NS_SCRIPTABLE NS_IMETHOD CardForEmailAddress(const nsACString & emailAddress, nsIAbCard **_retval NS_OUTPARAM) = 0;

  /**
   * Returns an address book card for the specified property if found.
   *
   * If there are multiple cards with the given value for the property, this
   * method will return one of these cards in an implementation-defined manner.
   *
   * This method performs a synchronous operation. If the collection cannot do
   * the search in such a manner, then it should throw NS_ERROR_NOT_IMPLEMENTED.
   *
   * If the property is not natively a string, it can still be searched for
   * using the string-encoded value of the property, e.g. "0". See
   * nsIAbCard::getPropertyAsAUTF8String for more information. Empty values will
   * return no match, to prevent spurious results.
   *
   * @param  aProperty      The property to look for.
   * @param  aValue         The value to search for.
   * @param  aCaseSensitive True if matching should be done case-sensitively.
   * @result                An nsIAbCard if one was found, else returns NULL.
   * @exception NS_ERROR_NOT_IMPLEMENTED If the collection cannot do this.
   */
  /* nsIAbCard getCardFromProperty (in string aProperty, in AUTF8String aValue, in boolean aCaseSensitive); */
  NS_SCRIPTABLE NS_IMETHOD GetCardFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsIAbCard **_retval NS_OUTPARAM) = 0;

  /**
   * Returns all address book cards with a specific property matching value
   *
   * This function is almost identical to getCardFromProperty, with the
   * exception of returning all cards rather than just the first.
   *
   * @param  aProperty      The property to look for.
   * @param  aValue         The value to search for.
   * @param  aCaseSensitive True if matching should be done case-sensitively.
   * @result                A nsISimpleEnumerator that holds nsIAbCard
   *                        instances.
   */
  /* nsISimpleEnumerator getCardsFromProperty (in string aProperty, in AUTF8String aValue, in boolean aCaseSensitive); */
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsISimpleEnumerator **_retval NS_OUTPARAM) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIAbCollection, NS_IABCOLLECTION_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABCOLLECTION \
  NS_SCRIPTABLE NS_IMETHOD GetReadOnly(PRBool *aReadOnly); \
  NS_SCRIPTABLE NS_IMETHOD GetIsRemote(PRBool *aIsRemote); \
  NS_SCRIPTABLE NS_IMETHOD GetIsSecure(PRBool *aIsSecure); \
  NS_SCRIPTABLE NS_IMETHOD CardForEmailAddress(const nsACString & emailAddress, nsIAbCard **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetCardFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsIAbCard **_retval NS_OUTPARAM); \
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsISimpleEnumerator **_retval NS_OUTPARAM); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABCOLLECTION(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetReadOnly(PRBool *aReadOnly) { return _to GetReadOnly(aReadOnly); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsRemote(PRBool *aIsRemote) { return _to GetIsRemote(aIsRemote); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsSecure(PRBool *aIsSecure) { return _to GetIsSecure(aIsSecure); } \
  NS_SCRIPTABLE NS_IMETHOD CardForEmailAddress(const nsACString & emailAddress, nsIAbCard **_retval NS_OUTPARAM) { return _to CardForEmailAddress(emailAddress, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsIAbCard **_retval NS_OUTPARAM) { return _to GetCardFromProperty(aProperty, aValue, aCaseSensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsISimpleEnumerator **_retval NS_OUTPARAM) { return _to GetCardsFromProperty(aProperty, aValue, aCaseSensitive, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABCOLLECTION(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetReadOnly(PRBool *aReadOnly) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReadOnly(aReadOnly); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsRemote(PRBool *aIsRemote) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsRemote(aIsRemote); } \
  NS_SCRIPTABLE NS_IMETHOD GetIsSecure(PRBool *aIsSecure) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsSecure(aIsSecure); } \
  NS_SCRIPTABLE NS_IMETHOD CardForEmailAddress(const nsACString & emailAddress, nsIAbCard **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->CardForEmailAddress(emailAddress, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsIAbCard **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCardFromProperty(aProperty, aValue, aCaseSensitive, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetCardsFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsISimpleEnumerator **_retval NS_OUTPARAM) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCardsFromProperty(aProperty, aValue, aCaseSensitive, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbCollection : public nsIAbCollection
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABCOLLECTION

  nsAbCollection();

private:
  ~nsAbCollection();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbCollection, nsIAbCollection)

nsAbCollection::nsAbCollection()
{
  /* member initializers and constructor code */
}

nsAbCollection::~nsAbCollection()
{
  /* destructor code */
}

/* readonly attribute boolean readOnly; */
NS_IMETHODIMP nsAbCollection::GetReadOnly(PRBool *aReadOnly)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean isRemote; */
NS_IMETHODIMP nsAbCollection::GetIsRemote(PRBool *aIsRemote)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean isSecure; */
NS_IMETHODIMP nsAbCollection::GetIsSecure(PRBool *aIsSecure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbCard cardForEmailAddress (in AUTF8String emailAddress); */
NS_IMETHODIMP nsAbCollection::CardForEmailAddress(const nsACString & emailAddress, nsIAbCard **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAbCard getCardFromProperty (in string aProperty, in AUTF8String aValue, in boolean aCaseSensitive); */
NS_IMETHODIMP nsAbCollection::GetCardFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsIAbCard **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISimpleEnumerator getCardsFromProperty (in string aProperty, in AUTF8String aValue, in boolean aCaseSensitive); */
NS_IMETHODIMP nsAbCollection::GetCardsFromProperty(const char *aProperty, const nsACString & aValue, PRBool aCaseSensitive, nsISimpleEnumerator **_retval NS_OUTPARAM)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAbCollection_h__ */
