#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.snmpd.new:
if [ -e etc/rc.d/rc.snmpd ]; then
  cp -a etc/rc.d/rc.snmpd etc/rc.d/rc.snmpd.new.incoming
  cat etc/rc.d/rc.snmpd.new > etc/rc.d/rc.snmpd.new.incoming
  mv etc/rc.d/rc.snmpd.new.incoming etc/rc.d/rc.snmpd.new
fi

config etc/snmp/snmpd.conf.new
config etc/rc.d/rc.snmpd.new

( cd usr/lib ; rm -rf libnetsnmpagent.so.25 )
( cd usr/lib ; ln -sf libnetsnmpagent.so.25.0.1 libnetsnmpagent.so.25 )
( cd usr/lib ; rm -rf libnetsnmphelpers.so.25 )
( cd usr/lib ; ln -sf libnetsnmphelpers.so.25.0.1 libnetsnmphelpers.so.25 )
( cd usr/lib ; rm -rf libnetsnmp.so )
( cd usr/lib ; ln -sf libnetsnmp.so.25.0.1 libnetsnmp.so )
( cd usr/lib ; rm -rf libnetsnmpmibs.so.25 )
( cd usr/lib ; ln -sf libnetsnmpmibs.so.25.0.1 libnetsnmpmibs.so.25 )
( cd usr/lib ; rm -rf libnetsnmptrapd.so )
( cd usr/lib ; ln -sf libnetsnmptrapd.so.25.0.1 libnetsnmptrapd.so )
( cd usr/lib ; rm -rf libnetsnmphelpers.so )
( cd usr/lib ; ln -sf libnetsnmphelpers.so.25.0.1 libnetsnmphelpers.so )
( cd usr/lib ; rm -rf libnetsnmp.so.25 )
( cd usr/lib ; ln -sf libnetsnmp.so.25.0.1 libnetsnmp.so.25 )
( cd usr/lib ; rm -rf libnetsnmpmibs.so )
( cd usr/lib ; ln -sf libnetsnmpmibs.so.25.0.1 libnetsnmpmibs.so )
( cd usr/lib ; rm -rf libnetsnmpagent.so )
( cd usr/lib ; ln -sf libnetsnmpagent.so.25.0.1 libnetsnmpagent.so )
( cd usr/lib ; rm -rf libnetsnmptrapd.so.25 )
( cd usr/lib ; ln -sf libnetsnmptrapd.so.25.0.1 libnetsnmptrapd.so.25 )
( cd usr/bin ; rm -rf snmpinform )
( cd usr/bin ; ln -sf snmptrap snmpinform )
