/* This file is part of the KDE libraries
   Copyright 2010 Canonical
   Author: Aurelien Gateau <aurelien.gateau@canonical.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License (LGPL) as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later
   version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef DBUSMENUQT_VERSION_H
#define DBUSMENUQT_VERSION_H

#define DBUSMENUQT_VERSION_MAJOR 0
#define DBUSMENUQT_VERSION_MINOR 6
#define DBUSMENUQT_VERSION_PATCH 4

#define DBUSMENUQT_MAKE_VERSION(a, b, c) (((a) << 16) | ((b) << 8) | (c))

#define DBUSMENUQT_VERSION DBUSMENUQT_MAKE_VERSION( \
    DBUSMENUQT_VERSION_MAJOR, \
    DBUSMENUQT_VERSION_MINOR, \
    DBUSMENUQT_VERSION_PATCH)

// Use this macro to add code which depends on a minimum version of dbusmenu-qt
#define DBUSMENUQT_IS_VERSION(a, b, c) \
    (DBUSMENUQT_VERSION >= DBUSMENUQT_MAKE_VERSION(a, b, c))

#endif /*DBUSMENUQT_VERSION_H */
